/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.localization;

import com.sap.ip.bi.sdk.localization.BIResourceAccessor;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import java.util.HashMap;
import java.util.Locale;

public class BIMessage {
    private static final int MAX_LENGTH_MESSAGE_PREFIX = 27;
    private static final String PACKAGEPREFIX = (class$com$sap$ip$bi$sdk$localization$BIMessage == null ? (class$com$sap$ip$bi$sdk$localization$BIMessage = BIMessage.class$("com.sap.ip.bi.sdk.localization.BIMessage")) : class$com$sap$ip$bi$sdk$localization$BIMessage).getPackage().getName();
    private static final Object synchronizationMonitor = new Object();
    private static final HashMap prefixAccessor = new HashMap();
    private static final HashMap accessorPrefix = new HashMap();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$localization$BIMessage;

    public static BIResourceAccessor getResourceAccessorByMessageId(String messageId) {
        String prefix = messageId.substring(0, messageId.length() - 5);
        return BIMessage.getResourceAccessorByPrefix(prefix);
    }

    public static BIResourceAccessor getResourceAccessorByPrefix(String prefix) {
        BIResourceAccessor resourceAccessor = null;
        Object object = synchronizationMonitor;
        synchronized (object) {
            if (prefixAccessor.containsKey(prefix)) {
                resourceAccessor = (BIResourceAccessor)((Object)prefixAccessor.get(prefix));
            } else {
                resourceAccessor = BIResourceAccessor.createInstance(BIMessage.getBundle(prefix));
                prefixAccessor.put(prefix, resourceAccessor);
                accessorPrefix.put(resourceAccessor, prefix);
            }
        }
        return resourceAccessor;
    }

    public static BIResourceAccessor getResourceAccessorByBundleName(String bundleName) {
        return BIMessage.getResourceAccessorByPrefix(BIMessage.getPrefix(bundleName));
    }

    public static String getPrefix(BIResourceAccessor resourceAccessor) {
        Object object = synchronizationMonitor;
        synchronized (object) {
            if (resourceAccessor == null || !accessorPrefix.containsKey((Object)resourceAccessor)) {
                throw new RuntimeException("Unknown BIResourceAccessor " + (Object)((Object)resourceAccessor));
            }
            String string = (String)accessorPrefix.get((Object)resourceAccessor);
            return string;
        }
    }

    public static String getBundle(BIResourceAccessor resourceAccessor) {
        return BIMessage.getBundle(BIMessage.getPrefix(resourceAccessor));
    }

    public static String getText(String messageId) {
        return BIMessage.getResourceAccessorByMessageId(messageId).getMessageText(Locale.getDefault(), messageId);
    }

    public static String getText(Locale locale, String messageId) {
        return BIMessage.getResourceAccessorByMessageId(messageId).getMessageText(locale, messageId);
    }

    public static String getText(String messageId, Object[] obj) {
        return BIMessage.getText(Locale.getDefault(), messageId, obj);
    }

    public static String getText(Locale locale, String messageId, Object[] obj) {
        LocalizableTextFormatter localizableText = new LocalizableTextFormatter((ResourceAccessor)BIMessage.getResourceAccessorByMessageId(messageId), messageId, obj);
        try {
            return localizableText.format(locale);
        }
        catch (LocalizationException e) {
            return BIMessage.getText(messageId);
        }
    }

    private static void checkMessagePrefixLength(String messagePrefix) {
        if (messagePrefix.length() > 27) {
            throw new RuntimeException("Length of Message prefix " + messagePrefix + " exceeds maximum of " + 27 + " characters");
        }
    }

    private static String getBundle(String messagePrefix) {
        BIMessage.checkMessagePrefixLength(messagePrefix);
        String bundleName = PACKAGEPREFIX + '.' + messagePrefix;
        bundleName = bundleName.substring(bundleName.lastIndexOf(46) + 1);
        bundleName = bundleName.toUpperCase().substring(0, 1) + bundleName.substring(1);
        bundleName = PACKAGEPREFIX + '.' + messagePrefix + '.' + bundleName;
        return bundleName;
    }

    private static String getPrefix(String bundleName) {
        String messagePrefix = bundleName;
        messagePrefix = messagePrefix.substring(PACKAGEPREFIX.length() + 1);
        messagePrefix = messagePrefix.substring(0, messagePrefix.lastIndexOf(46));
        BIMessage.checkMessagePrefixLength(messagePrefix);
        return messagePrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

