/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational.schema;

import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaType;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;

public class TableObject
extends GenericSchemaObject {
    private final TableType type;

    public TableObject(String catalogName, String schemaName, String tableName, TableType type) {
        super(SchemaType.TABLE);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.type = type;
    }

    public TableObject(String catalogName, String schemaName, String tableName, String tableType) {
        super(SchemaType.TABLE);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.type = TableType.getType(tableType);
    }

    public TableObject(CatalogObject catalog, String schemaName, String tableName, TableType type) {
        super(SchemaType.TABLE);
        this.catalogName = catalog.catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.type = type;
    }

    public TableObject(CatalogObject catalog, String schemaName, String tableName, String tableType) {
        super(SchemaType.TABLE);
        this.catalogName = catalog.catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.type = TableType.getType(tableType);
    }

    public TableObject(SchemaObject schema, String tableName, TableType type) {
        super(SchemaType.TABLE);
        this.catalogName = schema.catalogName;
        this.schemaName = schema.schemaName;
        this.tableName = tableName;
        this.type = type;
    }

    public TableObject(SchemaObject schema, String tableName, String tableType) {
        super(SchemaType.TABLE);
        this.catalogName = schema.catalogName;
        this.schemaName = schema.schemaName;
        this.tableName = tableName;
        this.type = TableType.getType(tableType);
    }

    public TableType getType() {
        return this.type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getQualifiedCatalogName() {
        return super.catalogName();
    }

    public String getQualifiedSchemaName() {
        return super.schemaName();
    }

    public boolean isDeferred() {
        return false;
    }
}

