/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational.schema;

import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaType;

public class GenericSchemaObject
implements Comparable {
    private static int globalPosition = 0;
    private int position = 0;
    private final SchemaType schemaObjectType;
    private boolean isDeferred = false;
    protected String catalogName = null;
    protected String schemaName = null;
    protected String tableName = null;
    protected String columnName = null;
    protected String dataTypeName = null;
    protected String description = null;
    protected String mofId = null;
    private static final String SCHEMA_EMPTY_NAME = "";
    private static final char SCHEMA_SEP = '#';
    private static final char SCHEMA_ESCAPE = '\\';

    public GenericSchemaObject(SchemaType schemaObjectType) {
        this.schemaObjectType = schemaObjectType;
        this.position = globalPosition++;
    }

    public String getMofId() {
        return this.mofId;
    }

    public void setMofId(String mofId) {
        this.mofId = mofId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isCatalog() {
        return this.schemaObjectType == SchemaType.CATALOG;
    }

    public boolean isSchema() {
        return this.schemaObjectType == SchemaType.SCHEMA;
    }

    public boolean isTable() {
        return this.schemaObjectType == SchemaType.TABLE;
    }

    public boolean isColumn() {
        return this.schemaObjectType == SchemaType.COLUMN;
    }

    public boolean isDataType() {
        return this.schemaObjectType == SchemaType.DATATYPE;
    }

    public boolean equals(GenericSchemaObject other) {
        if (other == null || this.schemaObjectType != other.schemaObjectType) {
            return false;
        }
        if (this.schemaObjectType == SchemaType.CATALOG) {
            return this.equalsCatalog(other);
        }
        if (this.schemaObjectType == SchemaType.SCHEMA) {
            return this.equalsSchema(other);
        }
        if (this.schemaObjectType == SchemaType.TABLE) {
            return this.equalsTable(other);
        }
        if (this.schemaObjectType == SchemaType.COLUMN) {
            return this.equalsColumn(other);
        }
        if (this.schemaObjectType == SchemaType.DATATYPE) {
            return this.equalsDataType(other);
        }
        return false;
    }

    public String toString() {
        if (this.schemaObjectType == SchemaType.CATALOG) {
            return this.catalogName();
        }
        if (this.schemaObjectType == SchemaType.SCHEMA) {
            return this.schemaName();
        }
        if (this.schemaObjectType == SchemaType.TABLE) {
            return this.tableName();
        }
        if (this.schemaObjectType == SchemaType.COLUMN) {
            return this.columnName();
        }
        if (this.schemaObjectType == SchemaType.DATATYPE) {
            return this.dataTypeName();
        }
        throw new RuntimeException();
    }

    public int getPosition() {
        return this.position;
    }

    public int compareTo(Object other) {
        if (!(other instanceof GenericSchemaObject) || other == null) {
            throw new ClassCastException();
        }
        return this.getPosition() - ((GenericSchemaObject)other).getPosition();
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    public void setDeferred(boolean isDeferred) {
        this.isDeferred = isDeferred;
    }

    private boolean equalsCatalog(GenericSchemaObject other) {
        return this.sameName(this.catalogName, other.catalogName);
    }

    private boolean equalsSchema(GenericSchemaObject other) {
        return this.equalsCatalog(other) && this.sameName(this.schemaName, other.schemaName);
    }

    private boolean equalsTable(GenericSchemaObject other) {
        return this.equalsSchema(other) && this.sameName(this.tableName, other.tableName);
    }

    private boolean equalsColumn(GenericSchemaObject other) {
        return this.equalsTable(other) && this.sameName(this.columnName, other.columnName);
    }

    private boolean equalsDataType(GenericSchemaObject other) {
        return this.equalsColumn(other) && this.sameName(this.dataTypeName, other.dataTypeName);
    }

    private boolean sameName(String thisName, String otherName) {
        return thisName == null && otherName == null || thisName != null && thisName.equals(otherName);
    }

    protected String addSuffix(String suffix) {
        return '#' + this.escape(suffix);
    }

    private String escape(String name) {
        if (name == null) {
            return null;
        }
        char[] data = name.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (data[i] == '\\' || data[i] == '#') {
                buf.append('#');
            }
            buf.append(data[i]);
            ++i;
        }
        return buf.toString();
    }

    protected final String catalogName() {
        if (this.catalogName == null) {
            return SCHEMA_EMPTY_NAME;
        }
        return this.escape(this.catalogName).toString();
    }

    protected final String schemaName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.catalogName()).append('#');
        if (this.schemaName == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(this.escape(this.schemaName));
        }
        return buf.toString();
    }

    protected final String tableName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.schemaName()).append('#');
        if (this.tableName == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(this.escape(this.tableName));
        }
        return buf.toString();
    }

    protected final String columnName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.tableName()).append('#');
        if (this.columnName == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(this.escape(this.columnName));
        }
        return buf.toString();
    }

    protected final String dataTypeName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.columnName()).append('#');
        if (this.dataTypeName == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(this.escape(this.dataTypeName));
        }
        return buf.toString();
    }
}

