/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.relational.IBIObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import java.util.Collections;
import java.util.List;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Schema;

public abstract class RelationalObjectFinder
implements IBIObjectFinder {
    private final TableType[] defaultTypes = new TableType[]{IBIRelational.TABLE};
    public static final List QUALIFIED_TABLE_NAME = Collections.unmodifiableList(Utilities.getUtilities().decodeQualifiedName("org.omg.cwm.resource.relational.Table"));

    protected RelationalObjectFinder() {
    }

    protected abstract List findTable(List var1, QueryFilters var2) throws BIResourceException;

    public List findTable(String catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        QueryFilters filter = new QueryFilters();
        filter.add(new QueryFilter("CATALOG", 0, catalog));
        filter.add(new QueryFilter("SCHEMA", 0, schemaPattern));
        filter.add(new QueryFilter("TABLE", 0, tableNamePattern));
        int i = 0;
        while (type != null && i < type.length) {
            filter.add(new QueryFilter("TABLE_TYPE", 0, type[i].toString()));
            ++i;
        }
        return this.findTable(QUALIFIED_TABLE_NAME, filter);
    }

    public List findTable(String catalog, String schemaPattern, String tableNamePattern) throws BIResourceException {
        return this.findTable(catalog, schemaPattern, tableNamePattern, this.defaultTypes);
    }

    public List findTable(Catalog catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        if (catalog == null) {
            return this.findTable((String)null, schemaPattern, tableNamePattern, type);
        }
        return this.findTable(catalog.getName(), schemaPattern, tableNamePattern, type);
    }

    public List findTable(Catalog catalog, String schemaPattern, String tableNamePattern) throws BIResourceException {
        return this.findTable(catalog, schemaPattern, tableNamePattern, this.defaultTypes);
    }

    public List findTable(Schema schema, String tableNamePattern, TableType[] type) throws BIResourceException {
        if (schema == null) {
            return this.findTable((String)null, (String)null, tableNamePattern, type);
        }
        return this.findTable((Catalog)schema.getNamespace(), schema.getName(), tableNamePattern, type);
    }

    public List findTable(Schema schema, String tableNamePattern) throws BIResourceException {
        return this.findTable(schema, tableNamePattern, this.defaultTypes);
    }
}

