/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational;

import com.sap.ip.bi.sdk.dac.connector.impl.BIMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.relational.IBIObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.relational.MetaStore;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalConnectionPersistence;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalPersistenceMetaData;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.ColumnObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.DataTypeObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;
import com.sap.ip.bi.sdk.exception.BIException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.Association;
import com.sap.ip.mmr.foundation.AssociationList;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.Instantiator;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import org.omg.cwm.foundation.keysindexes.KeysIndexesPackage;
import org.omg.cwm.objectmodel.core.ChangeableKindEnum;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.Multiplicity;
import org.omg.cwm.objectmodel.core.MultiplicityRange;
import org.omg.cwm.objectmodel.core.OrderingKindEnum;
import org.omg.cwm.objectmodel.core.ScopeKindEnum;
import org.omg.cwm.objectmodel.core.TaggedValue;
import org.omg.cwm.objectmodel.core.VisibilityKindEnum;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.RelationalPackage;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.SqlsimpleType;
import org.omg.cwm.resource.relational.Table;
import org.omg.cwm.resource.relational.enumerations.NullableTypeEnum;

public abstract class RelationalMDRConnection
extends BIMDRConnection
implements RelationalConnectionPersistence,
RelationalPersistenceMetaData {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$relational$RelationalMDRConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$relational$RelationalMDRConnection = RelationalMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.relational.RelationalMDRConnection")) : class$com$sap$ip$bi$sdk$dac$connector$relational$RelationalMDRConnection).getName());
    private static final Category loggingCat = BILoggingSetup.METADATA.getCategory();
    private IBIMonitor monitor = null;
    private static List packageName = null;
    private RelationalPackage relPack = null;
    private KeysIndexesPackage keyPack = null;
    private static final String SCHEMA_EMPTY_NAME = "";
    private static final char SCHEMA_SEP = '#';
    private static final char SCHEMA_ESCAPE = '\\';
    private static final String ASSOC_CLASSIFIER_FEATURE = "org.omg.cwm.objectmodel.Core.ClassifierFeature";
    private static final String ASSOC_ELEMENT_OWNERSHIP = "org.omg.cwm.objectmodel.Core.ElementOwnership";
    private static final String ASSOC_STRUCTURAL_FEATURE_TYPE = "org.omg.cwm.objectmodel.Core.StructuralFeatureType";
    private static final String ASSOC_TAGGEDELEMENT = "org.omg.cwm.objectmodel.Core.TaggedElement";
    private static final String ASSOC_RANGE_MULTIPLICITY = "org.omg.cwm.objectmodel.Core.RangeMultiplicity";
    private static final String CATALOG_CLASSNAME = "org.omg.cwm.resource.relational.Catalog";
    private static final String SCHEMA_CLASSNAME = "org.omg.cwm.resource.relational.Schema";
    private static final String TABLE_CLASSNAME = "org.omg.cwm.resource.relational.Table";
    private static final String COLUMN_CLASSNAME = "org.omg.cwm.resource.relational.Column";
    private static final String SQLSIMPLETYPE_CLASSNAME = "org.omg.cwm.resource.relational.SqlsimpleType";
    private static final String TAGGED_VALUE_CLASSNAME = "org.omg.cwm.objectmodel.core.TaggedValue";
    private static final String MULTIPLICITY_CLASSNAME = "org.omg.cwm.objectmodel.core.Multiplicity";
    private static final String MULTIPLICITY_RANGE_CLASSNAME = "org.omg.cwm.objectmodel.core.MultiplicityRange";
    private final boolean AUTOCOMMIT = true;
    private final boolean NOCOMMIT = false;
    private Catalog currentCatalog = null;
    private Schema currentSchema = null;
    private String MULTIPLICITY_1_1 = null;
    private String MULTIPLICITY_RANGE_1_1 = null;
    private String fixedCatalog = null;
    private String fixedSchema = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$relational$RelationalMDRConnection;
    static /* synthetic */ Class class$org$omg$cwm$resource$relational$Catalog;
    static /* synthetic */ Class class$org$omg$cwm$resource$relational$Schema;
    static /* synthetic */ Class class$org$omg$cwm$resource$relational$Table;
    static /* synthetic */ Class class$org$omg$cwm$resource$relational$Column;
    static /* synthetic */ Class class$org$omg$cwm$resource$relational$SqlsimpleType;

    public RelationalMDRConnection() {
        super(packageName, null);
    }

    public RelationalMDRConnection(IBIConnectionInfo connectionInfo) {
        super(connectionInfo, packageName, null);
    }

    public RefPackage connect() throws BIResourceException {
        RefPackage refPackage;
        String method = "connect()";
        loggingLoc.entering("connect()");
        try {
            RefPackage ref = super.connect();
            this.relPack = (RelationalPackage)ref.refPackage((String)packageName.get(0));
            this.keyPack = (KeysIndexesPackage)ref.refPackage((String)packageName.get(1));
            this.setupDefaults();
            refPackage = ref;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return refPackage;
    }

    private void setupDefaults() throws BIResourceException {
        Multiplicity oneToOne = (Multiplicity)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), MULTIPLICITY_CLASSNAME, Collections.EMPTY_LIST, true);
        ((IMMRObject)oneToOne).set___State(StateEnum.STATE_UNCHANGED);
        this.MULTIPLICITY_1_1 = oneToOne.refMofId();
        this.getMetaStore().putInstance(this.MULTIPLICITY_1_1, (Object)oneToOne);
        ArrayList<Integer> args = new ArrayList<Integer>(2);
        args.add(new Integer(1));
        args.add(new Integer(1));
        MultiplicityRange oneToOneRange = (MultiplicityRange)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), MULTIPLICITY_RANGE_CLASSNAME, Collections.EMPTY_LIST, true);
        ((IMMRObject)oneToOneRange).set___State(StateEnum.STATE_UNCHANGED);
        this.MULTIPLICITY_RANGE_1_1 = oneToOneRange.refMofId();
    }

    public void setCurrentCatalog(Catalog current) throws BIResourceException {
        String method = "setCurrentCatalog(Catalog)";
        loggingLoc.entering("setCurrentCatalog(Catalog)");
        try {
            this.currentCatalog = current;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Catalog getCurrentCatalog() throws BIResourceException {
        Catalog catalog;
        String method = "getCurrentCatalog()";
        loggingLoc.entering("getCurrentCatalog()");
        try {
            catalog = this.currentCatalog;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return catalog;
    }

    public String getCurrentCatalogName() {
        if (this.currentCatalog != null) {
            return this.currentCatalog.getName();
        }
        return null;
    }

    public void setCurrentSchema(Schema current) throws BIResourceException {
        String method = "setCurrentSchema(Schema)";
        loggingLoc.entering("setCurrentSchema(Schema)");
        try {
            this.currentSchema = current;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Schema getCurrentSchema() throws BIResourceException {
        Schema schema;
        String method = "getCurrentSchema()";
        loggingLoc.entering("getCurrentSchema()");
        try {
            schema = this.currentSchema;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return schema;
    }

    public String getCurrentSchemaName() {
        if (this.currentSchema != null) {
            return this.currentSchema.getName();
        }
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.mdr != null) {
            return this.mdr.getLocalTransaction();
        }
        throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_1001");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelElement createM1Instance(GenericSchemaObject meta, Class instance, boolean autoCommit) throws BIResourceException {
        ModelElement modelElement;
        String method = "createM1Instance(GenericSchemaObject, Class, boolean)";
        loggingLoc.entering("createM1Instance(GenericSchemaObject, Class, boolean)");
        try {
            try {
                modelElement = this.createM1InstanceInternal(meta, instance);
                Object var7_7 = null;
            }
            catch (ResourceException ex) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2001", new Object[]{instance}, ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return modelElement;
    }

    public void submitM1Instance() throws BIResourceException {
        String method = "submitM1Instance()";
        loggingLoc.entering("submitM1Instance()");
        try {
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private ModelElement createM1InstanceInternal(GenericSchemaObject schemaObj, Class instance) throws BIResourceException {
        String method = "createM1InstanceInternal(GenericSchemaObject, Class)";
        try {
            ModelElement me = null;
            if (instance.equals(class$org$omg$cwm$resource$relational$Catalog == null ? (class$org$omg$cwm$resource$relational$Catalog = RelationalMDRConnection.class$(CATALOG_CLASSNAME)) : class$org$omg$cwm$resource$relational$Catalog)) {
                me = this.createCatalog((CatalogObject)schemaObj);
            } else if (instance.equals(class$org$omg$cwm$resource$relational$Schema == null ? (class$org$omg$cwm$resource$relational$Schema = RelationalMDRConnection.class$(SCHEMA_CLASSNAME)) : class$org$omg$cwm$resource$relational$Schema)) {
                me = this.createSchema((SchemaObject)schemaObj);
            } else if (instance.equals(class$org$omg$cwm$resource$relational$Table == null ? (class$org$omg$cwm$resource$relational$Table = RelationalMDRConnection.class$(TABLE_CLASSNAME)) : class$org$omg$cwm$resource$relational$Table)) {
                me = this.createTable((TableObject)schemaObj);
            } else if (instance.equals(class$org$omg$cwm$resource$relational$Column == null ? (class$org$omg$cwm$resource$relational$Column = RelationalMDRConnection.class$(COLUMN_CLASSNAME)) : class$org$omg$cwm$resource$relational$Column)) {
                me = this.createColumn((ColumnObject)schemaObj);
            } else {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2002", new Object[]{instance.getName()});
            }
            ModelElement modelElement = me;
            Object var7_6 = null;
            return modelElement;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) throws BIException {
        AssociationsOfObject associationsOfObject;
        block19: {
            AssociationsOfObject associationsOfObject2;
            block18: {
                AssociationsOfObject associationsOfObject3;
                block17: {
                    AssociationsOfObject associationsOfObject4;
                    block16: {
                        AssociationsOfObject associationsOfObject5;
                        block15: {
                            AssociationsOfObject associationsOfObject6;
                            block14: {
                                AssociationsOfObject associationsOfObject7;
                                block13: {
                                    AssociationsOfObject associationsOfObject8;
                                    block12: {
                                        String method = "selectM1Assoc(IConnection, String, String)";
                                        loggingLoc.entering("selectM1Assoc(IConnection, String, String)");
                                        try {
                                            if (!this.assertConnection(connection)) {
                                                associationsOfObject8 = null;
                                                Object var8_9 = null;
                                                break block12;
                                            }
                                            if (associationId == null) {
                                                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_1003");
                                            }
                                            if (associationId == ASSOC_TAGGEDELEMENT) {
                                                associationsOfObject7 = this.selectTaggedValueAssoc(associationId, mofId);
                                                break block13;
                                            }
                                            if (associationId == ASSOC_RANGE_MULTIPLICITY) {
                                                associationsOfObject6 = this.selectRangeMultiplicityAssoc(associationId, mofId);
                                                break block14;
                                            }
                                            GenericSchemaObject object = this.getMetaStore().getObjectByMofId(mofId);
                                            if (object instanceof CatalogObject) {
                                                associationsOfObject5 = this.selectCatalogAssoc(connection, associationId, (CatalogObject)object);
                                                break block15;
                                            }
                                            if (object instanceof SchemaObject) {
                                                associationsOfObject4 = this.selectSchemaAssoc(connection, associationId, (SchemaObject)object);
                                                break block16;
                                            }
                                            if (object instanceof TableObject) {
                                                associationsOfObject3 = this.selectTableAssoc(connection, associationId, (TableObject)object);
                                                break block17;
                                            }
                                            if (object instanceof ColumnObject) {
                                                associationsOfObject2 = this.selectColumnAssoc(connection, associationId, (ColumnObject)object);
                                                break block18;
                                            }
                                            if (object instanceof SqlsimpleType) {
                                                associationsOfObject = null;
                                                break block19;
                                            }
                                            if (object == null) {
                                                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_2009", new Object[]{mofId});
                                            }
                                            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_2010", new Object[]{object.getClass().toString(), mofId});
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_17 = null;
                                            loggingLoc.exiting();
                                            throw throwable;
                                        }
                                    }
                                    loggingLoc.exiting();
                                    return associationsOfObject8;
                                }
                                Object var8_10 = null;
                                loggingLoc.exiting();
                                return associationsOfObject7;
                            }
                            Object var8_11 = null;
                            loggingLoc.exiting();
                            return associationsOfObject6;
                        }
                        Object var8_12 = null;
                        loggingLoc.exiting();
                        return associationsOfObject5;
                    }
                    Object var8_13 = null;
                    loggingLoc.exiting();
                    return associationsOfObject4;
                }
                Object var8_14 = null;
                loggingLoc.exiting();
                return associationsOfObject3;
            }
            Object var8_15 = null;
            loggingLoc.exiting();
            return associationsOfObject2;
        }
        Object var8_16 = null;
        loggingLoc.exiting();
        return associationsOfObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        ArrayList<String> arrayList;
        block34: {
            List list;
            block33: {
                List list2;
                block32: {
                    List list3;
                    block31: {
                        String method = "queryM1(IConnection, List, QueryFilters, boolean)";
                        loggingLoc.entering("queryM1(IConnection, List, QueryFilters, boolean)");
                        try {
                            boolean instanceCreated;
                            block29: {
                                block28: {
                                    block27: {
                                        block25: {
                                            block26: {
                                                String catalog = null;
                                                String schemaPattern = null;
                                                String tableNamePattern = null;
                                                ArrayList<TableType> type = null;
                                                instanceCreated = false;
                                                try {
                                                    try {
                                                        if (!this.assertConnection(connection)) {
                                                            list3 = null;
                                                            Object var17_15 = null;
                                                            if (!instanceCreated) break block25;
                                                            break block26;
                                                        }
                                                        this.assertQueryM1QualifiedNameOfType(qualifiedNameOfType);
                                                        if (filters == null) {
                                                            list2 = this.getTable();
                                                            break block27;
                                                        }
                                                        Iterator i = filters.iterator();
                                                        while (true) {
                                                            block35: {
                                                                if (i.hasNext()) break block35;
                                                            }
                                                            QueryFilter f = (QueryFilter)i.next();
                                                            if (f == null) continue;
                                                            if ("TABLE".equals(f.getAttribute())) {
                                                                tableNamePattern = f.getValue();
                                                                continue;
                                                            }
                                                            if ("SCHEMA".equals(f.getAttribute())) {
                                                                schemaPattern = f.getValue();
                                                                continue;
                                                            }
                                                            if ("CATALOG".equals(f.getAttribute())) {
                                                                catalog = f.getValue();
                                                                continue;
                                                            }
                                                            if (!"TABLE_TYPE".equals(f.getAttribute())) continue;
                                                            if (type == null) {
                                                                type = new ArrayList<TableType>();
                                                            }
                                                            type.add(TableType.getType(f.getValue()));
                                                        }
                                                        List tableObjs = this.assertFindTable(catalog, schemaPattern, tableNamePattern, type == null ? null : type.toArray(new TableType[0]));
                                                        if (tableObjs == null || tableObjs.size() <= 0) {
                                                            list = null;
                                                            break block28;
                                                        }
                                                        ArrayList<String> tableMofids = new ArrayList<String>();
                                                        Iterator i2 = tableObjs.iterator();
                                                        while (true) {
                                                            if (!i2.hasNext()) {
                                                                arrayList = tableMofids;
                                                                break block29;
                                                            }
                                                            TableObject t = (TableObject)i2.next();
                                                            if (t == null) continue;
                                                            if (t.getMofId() != null) {
                                                                tableMofids.add(t.getMofId());
                                                                continue;
                                                            }
                                                            this.createM1Instance(t, class$org$omg$cwm$resource$relational$Table == null ? RelationalMDRConnection.class$(TABLE_CLASSNAME) : class$org$omg$cwm$resource$relational$Table, false);
                                                            instanceCreated = true;
                                                            tableMofids.add(t.getMofId());
                                                        }
                                                    }
                                                    catch (BIResourceException ex) {
                                                        ex.log();
                                                        loggingLoc.debugT("queryM1(IConnection, List, QueryFilters, boolean)", "sdk.dac.connector.rel_2000");
                                                        List list4 = null;
                                                        Object var17_19 = null;
                                                        if (instanceCreated) {
                                                            try {
                                                                this.submitM1Instance();
                                                            }
                                                            catch (BIResourceException ex2) {
                                                                BIRuntimeException rex = new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_2000", (Throwable)((Object)ex2));
                                                                loggingLoc.throwing("queryM1(IConnection, List, QueryFilters, boolean)", (Throwable)((Object)rex));
                                                                throw rex;
                                                            }
                                                        }
                                                        Object var21_37 = null;
                                                        loggingLoc.exiting();
                                                        return list4;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    Object var17_20 = null;
                                                    if (!instanceCreated) throw throwable;
                                                    try {}
                                                    catch (BIResourceException ex2) {
                                                        BIRuntimeException rex = new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_2000", (Throwable)((Object)ex2));
                                                        loggingLoc.throwing("queryM1(IConnection, List, QueryFilters, boolean)", (Throwable)((Object)rex));
                                                        throw rex;
                                                    }
                                                    this.submitM1Instance();
                                                    throw throwable;
                                                }
                                            }
                                            try {}
                                            catch (BIResourceException ex2) {
                                                BIRuntimeException rex = new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_2000", (Throwable)((Object)ex2));
                                                loggingLoc.throwing("queryM1(IConnection, List, QueryFilters, boolean)", (Throwable)((Object)rex));
                                                throw rex;
                                            }
                                            this.submitM1Instance();
                                        }
                                        Object var21_33 = null;
                                        break block31;
                                    }
                                    Object var17_16 = null;
                                    if (!instanceCreated) break block32;
                                    try {}
                                    catch (BIResourceException ex2) {
                                        BIRuntimeException rex = new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_2000", (Throwable)((Object)ex2));
                                        loggingLoc.throwing("queryM1(IConnection, List, QueryFilters, boolean)", (Throwable)((Object)rex));
                                        throw rex;
                                    }
                                    this.submitM1Instance();
                                    break block32;
                                }
                                Object var17_17 = null;
                                if (!instanceCreated) break block33;
                                try {}
                                catch (BIResourceException ex2) {
                                    BIRuntimeException rex = new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_2000", (Throwable)((Object)ex2));
                                    loggingLoc.throwing("queryM1(IConnection, List, QueryFilters, boolean)", (Throwable)((Object)rex));
                                    throw rex;
                                }
                                this.submitM1Instance();
                                break block33;
                            }
                            Object var17_18 = null;
                            if (!instanceCreated) break block34;
                            try {}
                            catch (BIResourceException ex2) {
                                BIRuntimeException rex = new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_2000", (Throwable)((Object)ex2));
                                loggingLoc.throwing("queryM1(IConnection, List, QueryFilters, boolean)", (Throwable)((Object)rex));
                                throw rex;
                            }
                            this.submitM1Instance();
                            break block34;
                        }
                        catch (Throwable throwable) {
                            Object var21_38 = null;
                            loggingLoc.exiting();
                            throw throwable;
                        }
                    }
                    loggingLoc.exiting();
                    return list3;
                }
                Object var21_34 = null;
                loggingLoc.exiting();
                return list2;
            }
            Object var21_35 = null;
            loggingLoc.exiting();
            return list;
        }
        Object var21_36 = null;
        loggingLoc.exiting();
        return arrayList;
    }

    public Collection insertM1(IConnection connection, Collection objects) throws BIException {
        Collection collection;
        String method = "insertM1(IConnection, Collection)";
        loggingLoc.entering("insertM1(IConnection, Collection)");
        try {
            collection = null;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return collection;
    }

    public Collection deleteM1(IConnection connection, Collection objects) throws BIException {
        Collection collection;
        String method = "deleteM1(IConnection, Collection)";
        loggingLoc.entering("deleteM1(IConnection, Collection)");
        try {
            collection = null;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return collection;
    }

    public void deleteM1All(IConnection connection) throws BIException {
        String method = "deleteM1All(IConnection)";
        loggingLoc.entering("deleteM1All(IConnection)");
        try {
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate) throws BIException {
        ArrayList<RefBaseObject> arrayList;
        String method = "selectM1(IConnection, Collection, boolean)";
        loggingLoc.entering("selectM1(IConnection, Collection, boolean)");
        try {
            ArrayList<RefBaseObject> selected = new ArrayList<RefBaseObject>();
            Iterator iter = mofIdsOrObjects.iterator();
            while (iter.hasNext()) {
                String mofId;
                Object item = iter.next();
                RefBaseObject stored = null;
                if (item instanceof String) {
                    mofId = (String)item;
                    stored = (RefBaseObject)this.getMetaStore().getInstanceByMofId(mofId);
                } else {
                    mofId = ((RefBaseObject)item).refMofId();
                    stored = (RefBaseObject)this.getMetaStore().getInstanceByMofId(mofId);
                }
                if (stored == null) continue;
                selected.add(stored);
            }
            arrayList = selected.size() > 0 ? selected : null;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return arrayList;
    }

    private AssociationsOfObject selectRangeMultiplicityAssoc(String associationId, String mofId) {
        String method = "selectTaggedValueAssoc(String, String)";
        try {
            AssociationsOfObject assocObj = new AssociationsOfObject(mofId);
            if (mofId != null && this.MULTIPLICITY_1_1 != null && this.MULTIPLICITY_RANGE_1_1 != null && mofId.equals(this.MULTIPLICITY_1_1)) {
                assocObj.getMofIdsForward().add(new Association(this.MULTIPLICITY_1_1, this.MULTIPLICITY_RANGE_1_1, associationId));
            }
            AssociationsOfObject associationsOfObject = null;
            Object var7_6 = null;
            return associationsOfObject;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    private AssociationsOfObject selectTaggedValueAssoc(String associationId, String mofId) {
        String method = "selectTaggedValueAssoc(String, String)";
        try {
            AssociationsOfObject assocObj = new AssociationsOfObject(mofId);
            GenericSchemaObject sObj = this.getMetaStore().getObjectByMofId(mofId);
            ModelElement mObj = (ModelElement)this.getMetaStore().getInstanceByMofId(mofId);
            try {
                Map tv;
                if (sObj != null && mObj != null && (tv = this.getMetaStore().getTaggedValues(sObj)) != null && tv.size() > 0) {
                    Iterator i = tv.keySet().iterator();
                    while (i.hasNext()) {
                        String tag = (String)i.next();
                        String value = (String)tv.get(tag);
                        TaggedValue t = this.createTaggedElement(mObj, tag, value);
                        assocObj.getMofIdsForward().add(new Association(mofId, t.refMofId(), associationId));
                    }
                }
            }
            catch (BIResourceException ex) {
                ex.log();
                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId}, (Throwable)((Object)ex));
            }
            AssociationsOfObject associationsOfObject = assocObj;
            Object var13_13 = null;
            return associationsOfObject;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            throw throwable;
        }
    }

    private AssociationsOfObject selectCatalogAssoc(IConnection connection, String associationId, CatalogObject catalog) {
        String method = "selectCatalogAssoc(IConnection, String, CatalogObject)";
        try {
            if (associationId.equals(ASSOC_ELEMENT_OWNERSHIP)) {
                try {
                    this.assertCatalogSchemaAssocLoaded(catalog);
                }
                catch (BIResourceException ex) {
                    ex.log();
                    throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
                }
                AssociationsOfObject assoc = new AssociationsOfObject(catalog.getMofId());
                Iterator i = this.getMetaStore().getSchema(catalog).iterator();
                while (i.hasNext()) {
                    SchemaObject schema = (SchemaObject)i.next();
                    String schemaMofId = schema.getMofId();
                    if (schema.getMofId() == null) {
                        try {
                            Schema s = (Schema)this.createSchema(schema);
                            schema.setMofId(s.refMofId());
                        }
                        catch (BIResourceException ex) {
                            ex.log();
                            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
                        }
                    }
                    assoc.getMofIdsBackward().add(new Association(catalog.getMofId(), schema.getMofId(), associationId));
                }
                AssociationsOfObject associationsOfObject = assoc;
                Object var11_12 = null;
                return associationsOfObject;
            }
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            throw throwable;
        }
    }

    private AssociationsOfObject selectSchemaAssoc(IConnection connection, String associationId, SchemaObject schema) {
        String method = "selectSchemaAssoc(IConnection, String, SchemaObject)";
        try {
            if (associationId.equals(ASSOC_ELEMENT_OWNERSHIP)) {
                try {
                    this.assertSchemaTableAssocLoaded(schema);
                }
                catch (BIResourceException ex) {
                    ex.log();
                    throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
                }
                CatalogObject catalog = null;
                try {
                    this.assertCatalogSchemaAssocLoaded(schema);
                    catalog = this.getMetaStore().getCatalog(schema);
                    if (catalog.getMofId() == null) {
                        Catalog c = (Catalog)this.createCatalog(catalog);
                        catalog.setMofId(c.refMofId());
                    }
                }
                catch (BIResourceException ex) {
                    ex.log();
                    throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
                }
                AssociationsOfObject assoc = new AssociationsOfObject(schema.getMofId());
                AssociationList forwards = assoc.getMofIdsForward();
                AssociationList backwards = assoc.getMofIdsBackward();
                forwards.add(new Association(schema.getMofId(), catalog.getMofId(), associationId));
                if (this.getMetaStore().getTable(schema) != null) {
                    Iterator i = this.getMetaStore().getTable(schema).iterator();
                    while (i.hasNext()) {
                        TableObject table = (TableObject)i.next();
                        if (table.getMofId() == null) {
                            try {
                                Table t = (Table)this.createTable(table);
                                table.setMofId(t.refMofId());
                            }
                            catch (BIResourceException ex) {
                                ex.log();
                                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
                            }
                        }
                        backwards.add(new Association(schema.getMofId(), table.getMofId(), associationId));
                    }
                }
                AssociationsOfObject associationsOfObject = assoc;
                Object var13_15 = null;
                return associationsOfObject;
            }
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AssociationsOfObject selectTableAssoc(IConnection connection, String associationId, TableObject table) {
        String method = "selectTableAssoc(IConnection, String, TableObject)";
        try {
            if (associationId.equals(ASSOC_ELEMENT_OWNERSHIP)) {
                SchemaObject schema = null;
                try {
                    this.assertSchemaTableAssocLoaded(table);
                    schema = this.getMetaStore().getSchema(table);
                    if (schema.getMofId() == null) {
                        Schema s = (Schema)this.createSchema(schema);
                        schema.setMofId(s.refMofId());
                    }
                }
                catch (BIResourceException ex) {
                    ex.log();
                    throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
                }
                AssociationsOfObject assoc = new AssociationsOfObject(table.getMofId());
                assoc.getMofIdsForward().add(new Association(table.getMofId(), schema.getMofId(), associationId));
                return assoc;
            }
            if (!associationId.equals(ASSOC_CLASSIFIER_FEATURE)) throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
            try {
                this.assertTableColumnAssocLoaded(table);
            }
            catch (BIResourceException ex) {
                ex.log();
                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3002", new Object[]{associationId});
            }
            AssociationsOfObject assoc = new AssociationsOfObject(table.getMofId());
            AssociationList forwards = assoc.getMofIdsForward();
            Iterator i = this.getMetaStore().getColumn(table).iterator();
            while (i.hasNext()) {
                ColumnObject column = (ColumnObject)i.next();
                if (column.getMofId() == null) {
                    try {
                        Column c = (Column)this.createColumn(column);
                        column.setMofId(c.refMofId());
                    }
                    catch (BIResourceException ex) {
                        ex.log();
                        throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2001", new Object[]{class$org$omg$cwm$resource$relational$Column == null ? (class$org$omg$cwm$resource$relational$Column = RelationalMDRConnection.class$(COLUMN_CLASSNAME)) : class$org$omg$cwm$resource$relational$Column});
                    }
                }
                forwards.add(new Association(table.getMofId(), column.getMofId(), associationId));
            }
            return assoc;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AssociationsOfObject selectColumnAssoc(IConnection connection, String associationId, ColumnObject column) {
        String method = "selectColumnAssoc(IConnection, String, ColumnObject)";
        try {
            if (associationId.equals(ASSOC_STRUCTURAL_FEATURE_TYPE)) {
                String columnMofId = column.getMofId();
                DataTypeObject type = this.getMetaStore().getDataType(column);
                if (type == null) {
                    try {
                        SqlsimpleType t = (SqlsimpleType)this.createSimpleType(column);
                        type = new DataTypeObject(column);
                        type.setMofId(t.refMofId());
                        this.getMetaStore().addDataType(type);
                    }
                    catch (BIResourceException ex) {
                        ex.log();
                        throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2001", new Object[]{class$org$omg$cwm$resource$relational$SqlsimpleType == null ? (class$org$omg$cwm$resource$relational$SqlsimpleType = RelationalMDRConnection.class$(SQLSIMPLETYPE_CLASSNAME)) : class$org$omg$cwm$resource$relational$SqlsimpleType});
                    }
                }
                String typeId = type.getMofId();
                AssociationsOfObject assoc = new AssociationsOfObject(columnMofId);
                assoc.getMofIdsForward().add(new Association(columnMofId, typeId, associationId));
                return assoc;
            }
            if (!associationId.equals(ASSOC_CLASSIFIER_FEATURE)) throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
            String columnMofId = column.getMofId();
            String tableId = null;
            tableId = this.getMetaStore().getTable(column).getMofId();
            AssociationsOfObject assoc = new AssociationsOfObject(columnMofId);
            assoc.getMofIdsBackward().add(new Association(columnMofId, tableId, associationId));
            return assoc;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            throw throwable;
        }
    }

    public List getCatalog() throws BIResourceException {
        List list;
        String method = "getCatalog()";
        loggingLoc.entering("getCatalog()");
        try {
            list = this.getCatalog(true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    private List getCatalog(boolean submit) throws BIResourceException {
        String method = "getCatalog(boolean)";
        try {
            this.assertMetaDataLoaded();
            this.assertCatalogsLoaded();
            ArrayList<Catalog> catalogList = new ArrayList<Catalog>();
            Iterator i = this.getMetaStore().getCatalog().values().iterator();
            while (i.hasNext()) {
                CatalogObject c = (CatalogObject)i.next();
                Catalog catalog = (Catalog)this.createM1Instance(c, class$org$omg$cwm$resource$relational$Catalog == null ? RelationalMDRConnection.class$(CATALOG_CLASSNAME) : class$org$omg$cwm$resource$relational$Catalog, false);
                catalogList.add(catalog);
            }
            if (submit) {
                this.submitM1Instance();
            }
            ArrayList<Catalog> arrayList = catalogList;
            Object var8_7 = null;
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private TaggedValue createTaggedElement(ModelElement obj, String tag, String value) throws BIResourceException {
        String method = "createTaggedElement(ModelElement, String, String)";
        try {
            TaggedValue tv = (TaggedValue)this.getMetaStore().getTaggedValueInstances(obj.refMofId()).get(tag);
            if (tv == null) {
                ArrayList<String> args = new ArrayList<String>(2);
                args.add(tag);
                args.add(value);
                tv = (TaggedValue)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), TAGGED_VALUE_CLASSNAME, args, true);
                ((IMMRObject)tv).set___State(StateEnum.STATE_UNCHANGED);
                this.getMetaStore().putInstance(tv.refMofId(), (Object)tv);
                this.getMetaStore().putTaggedValueInstance(obj.refMofId(), tag, tv.refMofId());
            }
            TaggedValue taggedValue = tv;
            Object var8_7 = null;
            return taggedValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private ModelElement createCatalog(GenericSchemaObject catalogObj) throws BIResourceException {
        String method = "createCatalog(GenericSchemaObject)";
        try {
            Catalog cat = (Catalog)this.getMetaStore().getInstance(catalogObj);
            if (cat == null) {
                ArrayList<String> args = new ArrayList<String>(4);
                args.add(((CatalogObject)catalogObj).getCatalogName());
                args.add((String)VisibilityKindEnum.VK_PUBLIC);
                args.add(null);
                args.add(null);
                cat = (Catalog)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), CATALOG_CLASSNAME, args, true);
                ((IMMRObject)cat).set___State(StateEnum.STATE_UNCHANGED);
                catalogObj.setMofId(cat.refMofId());
                this.getMetaStore().putInstance(catalogObj, (Object)cat);
            }
            Catalog catalog = cat;
            Object var6_5 = null;
            return catalog;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    public List getSchema() throws BIResourceException {
        List list;
        String method = "getSchema()";
        loggingLoc.entering("getSchema()");
        try {
            list = this.getSchema(true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    private List getSchema(boolean submit) throws BIResourceException {
        String method = "getSchema(boolean)";
        try {
            this.assertMetaDataLoaded();
            this.assertSchemasLoaded();
            ArrayList<Schema> schemaList = new ArrayList<Schema>();
            Iterator i = this.getMetaStore().getSchema().values().iterator();
            while (i.hasNext()) {
                SchemaObject s = (SchemaObject)i.next();
                Schema schema = (Schema)this.createM1Instance(s, class$org$omg$cwm$resource$relational$Schema == null ? RelationalMDRConnection.class$(SCHEMA_CLASSNAME) : class$org$omg$cwm$resource$relational$Schema, false);
                schemaList.add(schema);
            }
            if (submit) {
                this.submitM1Instance();
            }
            ArrayList<Schema> arrayList = schemaList;
            Object var8_7 = null;
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private ModelElement createSchema(SchemaObject schemaObj) throws BIResourceException {
        String method = "createSchema(SchemaObject)";
        try {
            Schema schema = (Schema)this.getMetaStore().getInstance(schemaObj);
            if (schema == null) {
                ArrayList<String> args = new ArrayList<String>(2);
                args.add(schemaObj.getSchemaName());
                args.add((String)VisibilityKindEnum.VK_PUBLIC);
                schema = (Schema)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), SCHEMA_CLASSNAME, args, true);
                ((IMMRObject)schema).set___State(StateEnum.STATE_UNCHANGED);
                schemaObj.setMofId(schema.refMofId());
                this.getMetaStore().putInstance(schemaObj, (Object)schema);
            }
            Schema schema2 = schema;
            Object var6_5 = null;
            return schema2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    public List getTable() throws BIResourceException {
        ArrayList<Table> arrayList;
        String method = "getTable()";
        loggingLoc.entering("getTable()");
        try {
            this.assertMetaDataLoaded();
            this.assertTablesLoaded();
            ArrayList<Table> tableList = new ArrayList<Table>();
            Iterator i = this.getMetaStore().getTable().values().iterator();
            while (i.hasNext()) {
                TableObject t = (TableObject)i.next();
                Table table = (Table)this.createM1Instance(t, class$org$omg$cwm$resource$relational$Table == null ? RelationalMDRConnection.class$(TABLE_CLASSNAME) : class$org$omg$cwm$resource$relational$Table, false);
                tableList.add(table);
            }
            this.submitM1Instance();
            arrayList = tableList;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return arrayList;
    }

    public List getTableTypes() throws BIResourceException {
        String method = "getTableTypes()";
        loggingLoc.entering("getTableTypes()");
        try {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_1000");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public List findTable(String catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        ArrayList<Table> arrayList;
        String method = "findTable(String, String, String, TableType[])";
        loggingLoc.entering("findTable(String, String, String, TableType[])");
        try {
            List tables = this.assertFindTable(catalog, schemaPattern, tableNamePattern, type);
            ArrayList<Table> tableList = new ArrayList<Table>();
            Iterator i = tables.iterator();
            while (i.hasNext()) {
                TableObject t = (TableObject)i.next();
                Table table = (Table)this.createM1Instance(t, class$org$omg$cwm$resource$relational$Table == null ? RelationalMDRConnection.class$(TABLE_CLASSNAME) : class$org$omg$cwm$resource$relational$Table, false);
                t.setMofId(table.refMofId());
                tableList.add(table);
            }
            this.submitM1Instance();
            arrayList = tableList;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return arrayList;
    }

    private ModelElement createTable(TableObject tableObj) throws BIResourceException {
        String method = "createTable(TableObject)";
        try {
            Table table = (Table)this.getMetaStore().getInstance(tableObj);
            if (table == null) {
                Boolean isTemporary = Boolean.FALSE;
                Boolean isSystem = Boolean.FALSE;
                if (tableObj.getType() == TableType.SYSTEM_TABLE) {
                    isSystem = Boolean.TRUE;
                }
                if (tableObj.getType() == TableType.GLOBAL_TEMPORARY || tableObj.getType() == TableType.LOCAL_TEMPORARY) {
                    isTemporary = Boolean.TRUE;
                }
                ArrayList<Object> args = new ArrayList<Object>(6);
                args.add(tableObj.getTableName());
                args.add(VisibilityKindEnum.VK_PUBLIC);
                args.add(Boolean.FALSE);
                args.add(isTemporary);
                args.add(null);
                args.add(isSystem);
                table = (Table)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), TABLE_CLASSNAME, args, true);
                ((IMMRObject)table).set___State(StateEnum.STATE_UNCHANGED);
                tableObj.setMofId(table.refMofId());
                this.getMetaStore().putInstance(tableObj, (Object)table);
            }
            Table table2 = table;
            Object var8_7 = null;
            return table2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private List getColumn(Table table) throws BIResourceException {
        String method = "getColumn(Table)";
        try {
            if (table == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_2016");
            }
            TableObject tableObj = (TableObject)this.getMetaStore().getObjectByMofId(table.refMofId());
            if (tableObj == null) {
                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_2017", new Object[]{table.refMofId()});
            }
            List list = this.getColumn(tableObj);
            Object var6_5 = null;
            return list;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private List getColumn(TableObject tableObj) throws BIResourceException {
        String method = "getColumn(TableObject)";
        try {
            this.assertMetaDataLoaded();
            this.assertColumnsLoaded(tableObj);
            ArrayList<Column> columnList = new ArrayList<Column>();
            Iterator i = this.getMetaStore().getColumn(tableObj).iterator();
            while (i.hasNext()) {
                ColumnObject c = (ColumnObject)i.next();
                Column column = (Column)this.createM1Instance(c, class$org$omg$cwm$resource$relational$Column == null ? RelationalMDRConnection.class$(COLUMN_CLASSNAME) : class$org$omg$cwm$resource$relational$Column, false);
                columnList.add(column);
            }
            this.submitM1Instance();
            ArrayList<Column> arrayList = columnList;
            Object var8_7 = null;
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private ModelElement createColumn(ColumnObject columnObj) throws BIResourceException {
        String method = "createColumn(ColumnObject)";
        try {
            Column column = (Column)this.getMetaStore().getInstance(columnObj);
            if (column == null) {
                Multiplicity oneToOne = (Multiplicity)this.getMetaStore().getInstanceByMofId(this.MULTIPLICITY_1_1);
                NullableTypeEnum nullable = NullableTypeEnum.COLUMN_NULLABLE_UNKNOWN;
                switch (columnObj.getNullable()) {
                    case 0: {
                        nullable = NullableTypeEnum.COLUMN_NO_NULLS;
                    }
                    case 1: {
                        nullable = NullableTypeEnum.COLUMN_NULLABLE;
                    }
                    case 2: {
                        nullable = NullableTypeEnum.COLUMN_NULLABLE_UNKNOWN;
                    }
                }
                ArrayList<Object> args = new ArrayList<Object>(14);
                args.add(columnObj.getColumnName());
                args.add(VisibilityKindEnum.VK_PUBLIC);
                args.add(ScopeKindEnum.SK_INSTANCE);
                args.add(ChangeableKindEnum.CK_FROZEN);
                args.add(oneToOne);
                args.add(OrderingKindEnum.OK_ORDERED);
                args.add(ScopeKindEnum.SK_INSTANCE);
                args.add(null);
                args.add(new Integer(columnObj.getColumnSize()));
                args.add(new Integer(columnObj.getDecimalDigits()));
                args.add(nullable);
                args.add(new Integer(columnObj.getColumnSize()));
                args.add(null);
                args.add(null);
                column = (Column)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), COLUMN_CLASSNAME, args, true);
                ((IMMRObject)column).set___State(StateEnum.STATE_UNCHANGED);
                columnObj.setMofId(column.refMofId());
                this.getMetaStore().putInstance(columnObj, (Object)column);
            }
            Column column2 = column;
            Object var8_7 = null;
            return column2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private ModelElement createSimpleType(ColumnObject columnObj) throws BIResourceException {
        String method = "createSimpleType(ColumnObject)";
        try {
            SqlsimpleType type = (SqlsimpleType)this.getMetaStore().getInstanceByName(columnObj.getColumnTypeName());
            if (type == null) {
                DataTypeObject t = new DataTypeObject(columnObj);
                ArrayList<Object> args = new ArrayList<Object>(10);
                args.add(t.getTypeName());
                args.add(VisibilityKindEnum.VK_PUBLIC);
                args.add(Boolean.FALSE);
                args.add(new Integer(columnObj.getDataType()));
                args.add(new Integer(columnObj.getColumnSize()));
                args.add(new Integer(columnObj.getCharOctetLength()));
                args.add(new Integer(columnObj.getColumnSize()));
                args.add(new Integer(columnObj.getNumPrecRadix()));
                args.add(new Integer(columnObj.getDecimalDigits()));
                args.add(new Integer(0));
                type = (SqlsimpleType)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), SQLSIMPLETYPE_CLASSNAME, args, true);
                ((IMMRObject)type).set___State(StateEnum.STATE_UNCHANGED);
                t.setMofId(type.refMofId());
                this.getMetaStore().addDataType(t);
                this.getMetaStore().putInstance(t, (Object)type);
            }
            SqlsimpleType sqlsimpleType = type;
            Object var7_6 = null;
            return sqlsimpleType;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    private void assertNotNull(Object obj) throws BIResourceException {
        String method = "assertNotNull(Object)";
        try {
            if (obj == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_2018", new Object[]{obj});
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    private void assertQueryM1QualifiedNameOfType(List qualifiedNameOfType) throws BIResourceException {
        String method = "assertQueryM1QualifiedNameOfType(List)";
        try {
            if (qualifiedNameOfType != IBIObjectFinder.QUALIFIED_TABLE_NAME) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2000");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    public void setFixedCatalog(String fixedCatalog) {
        this.fixedCatalog = fixedCatalog;
    }

    public String getFixedCatalog() {
        return this.fixedCatalog;
    }

    public void setFixedSchema(String fixedSchema) {
        this.fixedSchema = fixedSchema;
    }

    public String getFixedSchema() {
        return this.fixedSchema;
    }

    public abstract void assertMetaDataLoaded() throws BIResourceException;

    public abstract void assertCatalogsLoaded() throws BIResourceException;

    public abstract void assertSchemasLoaded() throws BIResourceException;

    public abstract void assertSchemasLoaded(CatalogObject var1) throws BIResourceException;

    public abstract void assertTablesLoaded() throws BIResourceException;

    public abstract void assertTablesLoaded(SchemaObject var1) throws BIResourceException;

    public abstract void assertColumnsLoaded(TableObject var1) throws BIResourceException;

    public abstract void assertTableColumnAssocLoaded(GenericSchemaObject var1) throws BIResourceException;

    public abstract void assertCatalogSchemaAssocLoaded(GenericSchemaObject var1) throws BIResourceException;

    public abstract void assertSchemaTableAssocLoaded(GenericSchemaObject var1) throws BIResourceException;

    public abstract List assertFindTable(String var1, String var2, String var3, TableType[] var4) throws BIResourceException;

    public abstract MetaStore getMetaStore();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        packageName = new ArrayList();
        packageName.add("org.omg.cwm.resource.Relational");
        packageName.add("org.omg.cwm.foundation.KeysIndexes");
    }
}

