/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational;

import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.ColumnObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.DataTypeObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;
import com.sap.ip.bi.sdk.util.impl.MultiHash;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MetaStore
extends MultiHash {
    public static final String OBJECT = "OBJECT";
    public static final String INSTANCE = "INSTANCE";
    public static final String CATALOG = "CATALOG";
    public static final String CATALOG_SCHEMA = "CATALOG->SCHEMA";
    public static final String SCHEMA = "SCHEMA";
    public static final String SCHEMA_TABLE = "SCHEMA->TABLE";
    public static final String TABLE = "TABLE";
    public static final String TABLE_COLUMN = "TABLE->COLUMN";
    public static final String COLUMN = "COLUMN";
    public static final String COLUMN_DATATYPE = "COLUMN->DATATYPE";
    public static final String DATATYPE = "DATATYPE";
    public static final String TAGGEDVALUES = "TAGGEDVALUES";
    public static final String TAGGEDVALUES_INSTANCE = "OBJECT->TAGGEDVALUES";

    public void clear() {
        super.clear();
    }

    public Map getTaggedValues(GenericSchemaObject obj) {
        if (obj == null) {
            return Collections.EMPTY_MAP;
        }
        return this.getTaggedValuesByName(obj.toString());
    }

    public Map getTaggedValuesByMofId(String mofId) {
        GenericSchemaObject obj = this.getObjectByMofId(mofId);
        if (obj == null) {
            return Collections.EMPTY_MAP;
        }
        return this.getTaggedValues(obj);
    }

    public Map getTaggedValuesByName(String qualifiedName) {
        if (qualifiedName == null) {
            return Collections.EMPTY_MAP;
        }
        return this.getMapStore(TAGGEDVALUES, qualifiedName);
    }

    public Map getTaggedValueInstances(String mofId) {
        return this.getMapStore(TAGGEDVALUES_INSTANCE, mofId);
    }

    public Map getTaggedValueInstances(GenericSchemaObject obj) {
        if (obj == null || obj.getMofId() == null) {
            return Collections.EMPTY_MAP;
        }
        return this.getMapStore(TAGGEDVALUES_INSTANCE, obj.getMofId());
    }

    public void putTaggedValue(GenericSchemaObject obj, String tag, String value) {
        if (obj != null) {
            this.addMap(TAGGEDVALUES, obj.toString(), tag, value);
        }
    }

    public void putTaggedValueInstance(String mofId, String tag, String tagMofId) {
        this.addMap(TAGGEDVALUES_INSTANCE, mofId, tag, tagMofId);
    }

    public GenericSchemaObject getObjectByMofId(String mofId) {
        return (GenericSchemaObject)this.getStore(OBJECT).get(mofId);
    }

    public GenericSchemaObject getObjectByName(String qualifiedName) {
        return (GenericSchemaObject)this.getStore(OBJECT).get(qualifiedName);
    }

    public Object getInstance(GenericSchemaObject obj) {
        return this.getStore(INSTANCE).get(obj.toString());
    }

    public Object getInstanceByName(String qualifiedName) {
        return this.getStore(INSTANCE).get(qualifiedName);
    }

    public Object getInstanceByMofId(String mofId) {
        return this.getStore(INSTANCE).get(mofId);
    }

    public void putInstance(GenericSchemaObject obj, Object instance) {
        if (obj != null) {
            this.add(OBJECT, obj.getMofId(), obj);
            this.add(OBJECT, obj.toString(), instance);
            this.add(INSTANCE, obj.getMofId(), instance);
            this.add(INSTANCE, obj.toString(), instance);
        }
    }

    public void putInstance(String mofId, Object instance) {
        if (mofId != null) {
            this.add(INSTANCE, mofId, instance);
        }
    }

    public boolean containsCatalog(CatalogObject catalog) {
        return this.getCatalog().containsKey(catalog.toString());
    }

    public void addCatalog(CatalogObject catalog) {
        if (catalog != null) {
            this.add(CATALOG, catalog.toString(), catalog);
        }
    }

    public Map getCatalog() {
        return this.getStore(CATALOG);
    }

    public CatalogObject getCatalog(SchemaObject schema) {
        if (schema == null) {
            return (CatalogObject)this.getStore(CATALOG).get(null);
        }
        return (CatalogObject)this.getStore(CATALOG).get(schema.getQualifiedCatalogName());
    }

    public void addSchema(SchemaObject schema) {
        if (schema != null) {
            this.add(SCHEMA, schema.toString(), schema);
            this.addMultiple(CATALOG_SCHEMA, (Object)schema.getQualifiedCatalogName(), schema);
        }
    }

    public boolean containsSchema(SchemaObject schema) {
        return this.getSchema().containsKey(schema.toString());
    }

    public Map getSchema() {
        return this.getStore(SCHEMA);
    }

    public Set getSchema(CatalogObject catalog) {
        if (catalog == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CATALOG_SCHEMA).get(catalog.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getSchema(SchemaObject schema) {
        if (schema == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CATALOG_SCHEMA).get(schema.getQualifiedCatalogName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public SchemaObject getSchema(TableObject table) {
        if (table == null) {
            return (SchemaObject)this.getStore(SCHEMA).get(null);
        }
        return (SchemaObject)this.getStore(SCHEMA).get(table.getQualifiedSchemaName());
    }

    public boolean containsTable(TableObject table) {
        return this.getTable().containsKey(table.toString());
    }

    public void addTable(TableObject table) {
        if (table != null) {
            this.add(TABLE, table.toString(), table);
            this.addMultiple(SCHEMA_TABLE, (Object)table.getQualifiedSchemaName(), table);
        }
    }

    public Map getTable() {
        return this.getStore(TABLE);
    }

    public Set getTable(SchemaObject schema) {
        if (schema == null) {
            return null;
        }
        return (Set)this.getStore(SCHEMA_TABLE).get(schema.toString());
    }

    public Set getTable(TableObject table) {
        if (table == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(SCHEMA_TABLE).get(table.getQualifiedSchemaName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public TableObject getTable(ColumnObject column) {
        if (column == null) {
            return null;
        }
        return (TableObject)this.getStore(TABLE).get(column.getQualifiedTableName());
    }

    public boolean containsColumn(ColumnObject column) {
        if (column == null) {
            return this.getColumn().containsKey(null);
        }
        return this.getColumn().containsKey(column.toString());
    }

    public void addColumn(ColumnObject column) {
        if (column != null) {
            this.add(COLUMN, column.toString(), column);
            this.addMultiple(TABLE_COLUMN, (Object)column.getQualifiedTableName(), column);
        }
    }

    public Map getColumn() {
        return this.getStore(COLUMN);
    }

    public Set getColumn(TableObject table) {
        if (table == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(TABLE_COLUMN).get(table.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getColumn(ColumnObject column) {
        if (column == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(TABLE_COLUMN).get(column.getQualifiedTableName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public boolean containsDataType(DataTypeObject dataType) {
        if (dataType == null) {
            return this.getDataType().containsKey(null);
        }
        return this.getDataType().containsKey(dataType.toString());
    }

    public void addDataType(DataTypeObject dataType) {
        if (dataType != null) {
            this.add(DATATYPE, dataType.toString(), dataType);
            this.add(COLUMN_DATATYPE, dataType.getQualifiedColumnName(), dataType);
        }
    }

    public Map getDataType() {
        return this.getStore(DATATYPE);
    }

    public DataTypeObject getDataType(ColumnObject column) {
        if (column == null) {
            return null;
        }
        return (DataTypeObject)this.getStore(COLUMN_DATATYPE).get(column.toString());
    }
}

