/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.IBIRelationalObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.BIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionDetails;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalObjectFinder;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQuery;
import com.sap.ip.bi.sdk.exception.BICapabilityNotSupportedException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BILogonLanguage;
import com.sap.ip.bi.sdk.util.impl.BIMonitor;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sapportals.connector.connection.INative;
import com.sapportals.connector.metadata.CapabilityNotSupportedException;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.Table;

public abstract class CommonConnection
extends BIRelational
implements IBIRelational,
IBIConnectionDetails,
IBIQueryExecute {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection = CommonConnection.class$("com.sap.ip.bi.sdk.dac.connector.relational.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    protected IBIMonitor monitorConnection = null;
    protected IBIMonitor monitorMetadata = null;
    protected IBIMonitor monitorQuery = null;
    public static final List QUALIFIED_TABLE_NAME = Collections.unmodifiableList(Utilities.getUtilities().decodeQualifiedName("org.omg.cwm.resource.relational.Table"));
    private Attributes attributes = null;
    protected RelationalMDRConnection mdr = null;
    protected RefPackage outerMost = null;
    protected LocalTransaction trans = null;
    protected Properties properties = new Properties();
    private IBIRelationalObjectFinder objectFinder = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection;

    protected CommonConnection() {
        this.connectionInfo = new ConnectionInfo();
        this.setupMonitor();
    }

    protected CommonConnection(Properties properties) {
        this.properties = properties;
        this.connectionInfo = new ConnectionInfo();
        this.setupMonitor();
    }

    public IBIConnectionInfo getConnectionInfo() throws ResourceException {
        if (this.connectionInfo == IBIConnectionInfo.DEFAULT) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
        return this.connectionInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws ResourceException {
        String method = "close()";
        loggingLoc.entering("close()");
        try {
            this.connectionInfo = IBIConnectionInfo.DEFAULT;
            try {
                this.closeDB();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (this.mdr == null) throw throwable;
                    if (this.trans != null) {
                        this.trans.rollback();
                        this.trans = null;
                    }
                    this.mdr.close();
                    this.mdr = null;
                    throw throwable;
                }
                catch (ResourceException ex) {
                    throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_2003", ex);
                }
            }
            try {}
            catch (ResourceException ex) {
                throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector_2003", ex);
            }
            if (this.mdr != null) {
                if (this.trans != null) {
                    this.trans.rollback();
                    this.trans = null;
                }
                this.mdr.close();
                this.mdr = null;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getProperty(String key) {
        String string;
        String method = "getProperty(String)";
        loggingLoc.entering("getProperty(String)");
        try {
            string = this.properties.getProperty(key);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setProperty(String key, String value) {
        String method = "setProperty(String, String)";
        loggingLoc.entering("setProperty(String, String)");
        try {
            this.properties.setProperty(key, value);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Properties getProperties() {
        Properties properties;
        String method = "getProperties()";
        loggingLoc.entering("getProperties()");
        try {
            properties = this.properties;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return properties;
    }

    public INative retrieveNative() throws CapabilityNotSupportedException {
        throw new BICapabilityNotSupportedException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public ResultSet getResultSet(IBIQuery query) throws BIResourceException {
        ResultSet resultSet;
        block4: {
            String method = "getResultSet(IBIQuery)";
            loggingLoc.entering("getResultSet(IBIQuery)", new Object[]{query});
            boolean isInRequest = this.monitorQuery.getCurrentRequest() != null;
            try {
                if (!isInRequest) {
                    this.monitorQuery.startRequest(IBIMonitor.Request.QUERY);
                }
                this.monitorQuery.startComponent(this.getClass(), "getResultSet(IBIQuery)");
                resultSet = this.execute(query);
                Object var6_5 = null;
                this.monitorQuery.endComponent(this.getClass(), "getResultSet(IBIQuery)");
                if (isInRequest) break block4;
                this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.monitorQuery.endComponent(this.getClass(), "getResultSet(IBIQuery)");
                if (!isInRequest) {
                    this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
                }
                loggingLoc.exiting();
                throw throwable;
            }
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public abstract ResultSet execute(IBIQuery var1) throws BIResourceException;

    public ResultSet getResultSet(Object nativeQuery) throws BIResourceException {
        ResultSet resultSet;
        block4: {
            String method = "getResultSet(Object)";
            loggingLoc.entering("getResultSet(Object)", new Object[]{nativeQuery});
            boolean isInRequest = this.monitorQuery.getCurrentRequest() != null;
            try {
                if (!isInRequest) {
                    this.monitorQuery.startRequest(IBIMonitor.Request.QUERY);
                }
                this.monitorQuery.startComponent(this.getClass(), "getResultSet(Object)");
                resultSet = this.execute(nativeQuery);
                Object var6_5 = null;
                this.monitorQuery.endComponent(this.getClass(), "getResultSet(Object)");
                if (isInRequest) break block4;
                this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.monitorQuery.endComponent(this.getClass(), "getResultSet(Object)");
                if (!isInRequest) {
                    this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
                }
                loggingLoc.exiting();
                throw throwable;
            }
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public abstract ResultSet execute(Object var1) throws BIResourceException;

    public abstract Object getNativeRepresentation(IBIQuery var1) throws BIResourceException;

    public abstract Boolean supports(IBIRelational.Supports var1);

    public abstract boolean isAlive() throws BIResourceException;

    public Attributes getAttributes() {
        Attributes attributes;
        String method = "getAttributes()";
        loggingLoc.entering("getAttributes()");
        try {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            attributes = this.attributes;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return attributes;
    }

    public List getCatalog() throws BIResourceException {
        List list;
        block4: {
            String method = "getCatalog()";
            loggingLoc.entering("getCatalog()");
            boolean isInRequest = this.monitorMetadata.getCurrentRequest() != null;
            try {
                if (!isInRequest) {
                    this.monitorMetadata.startRequest(IBIMonitor.Request.METADATA);
                }
                this.monitorMetadata.startComponent(this.getClass(), "getCatalog()");
                this.assertConnectedToMDR();
                list = this.mdr.getCatalog();
                Object var5_4 = null;
                this.monitorMetadata.endComponent(this.getClass(), "getCatalog()");
                if (isInRequest) break block4;
                this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.monitorMetadata.endComponent(this.getClass(), "getCatalog()");
                if (!isInRequest) {
                    this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
                }
                loggingLoc.exiting();
                throw throwable;
            }
        }
        loggingLoc.exiting();
        return list;
    }

    public void setCurrentCatalog(Catalog current) throws BIResourceException {
        String method = "setCurrentCatalog(Catalog)";
        loggingLoc.entering("setCurrentCatalog(Catalog)");
        try {
            this.assertConnectedToMDR();
            this.mdr.setCurrentCatalog(current);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Catalog getCurrentCatalog() throws BIResourceException {
        Catalog catalog;
        String method = "getCurrentCatalog()";
        loggingLoc.entering("getCurrentCatalog()");
        try {
            this.assertConnectedToMDR();
            catalog = this.mdr.getCurrentCatalog();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return catalog;
    }

    public List getSchema() throws BIResourceException {
        List list;
        block4: {
            String method = "getSchema()";
            loggingLoc.entering("getSchema()");
            boolean isInRequest = this.monitorMetadata.getCurrentRequest() != null;
            try {
                if (!isInRequest) {
                    this.monitorMetadata.startRequest(IBIMonitor.Request.METADATA);
                }
                this.monitorMetadata.startComponent(this.getClass(), "getSchema()");
                this.assertConnectedToMDR();
                list = this.mdr.getSchema();
                Object var5_4 = null;
                this.monitorMetadata.endComponent(this.getClass(), "getSchema()");
                if (isInRequest) break block4;
                this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.monitorMetadata.endComponent(this.getClass(), "getSchema()");
                if (!isInRequest) {
                    this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
                }
                loggingLoc.exiting();
                throw throwable;
            }
        }
        loggingLoc.exiting();
        return list;
    }

    public void setCurrentSchema(Schema current) throws BIResourceException {
        String method = "setCurrentSchema(Schema)";
        loggingLoc.entering("setCurrentSchema(Schema)");
        try {
            this.assertConnectedToMDR();
            this.mdr.setCurrentSchema(current);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Schema getCurrentSchema() throws BIResourceException {
        Schema schema;
        String method = "getCurrentSchema()";
        loggingLoc.entering("getCurrentSchema()");
        try {
            this.assertConnectedToMDR();
            schema = this.mdr.getCurrentSchema();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return schema;
    }

    public List getTable() throws BIResourceException {
        List list;
        block4: {
            String method = "getTable()";
            loggingLoc.entering("getTable()");
            boolean isInRequest = this.monitorMetadata.getCurrentRequest() != null;
            try {
                if (!isInRequest) {
                    this.monitorMetadata.startRequest(IBIMonitor.Request.METADATA);
                }
                this.monitorMetadata.startComponent(this.getClass(), "getTable()");
                this.assertConnectedToMDR();
                list = this.mdr.getTable();
                Object var5_4 = null;
                this.monitorMetadata.endComponent(this.getClass(), "getTable()");
                if (isInRequest) break block4;
                this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.monitorMetadata.endComponent(this.getClass(), "getTable()");
                if (!isInRequest) {
                    this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
                }
                loggingLoc.exiting();
                throw throwable;
            }
        }
        loggingLoc.exiting();
        return list;
    }

    public List getTableTypes() throws BIResourceException {
        List list;
        String method = "getTableTypes()";
        loggingLoc.entering("getTableTypes()");
        try {
            this.assertConnectedToMDR();
            list = this.mdr.getTableTypes();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    private List findTableInternal(List qualifiedName, QueryFilters filters) throws BIResourceException {
        String method = "findTableInternal(List, QueryFilters)";
        boolean isInRequest = this.monitorMetadata.getCurrentRequest() != null;
        try {
            if (!isInRequest) {
                this.monitorMetadata.startRequest(IBIMonitor.Request.METADATA);
            }
            this.monitorMetadata.startComponent(this.getClass(), "findTableInternal(List, QueryFilters)");
            this.assertConnectedToMDR();
            IConnection c = this.mdr.getConnection();
            if (c != null) {
                try {
                    List list = c.queryM1(qualifiedName, filters, false);
                    Object var8_8 = null;
                    this.monitorMetadata.endComponent(this.getClass(), "findTableInternal(List, QueryFilters)");
                    if (!isInRequest) {
                        this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
                    }
                    return list;
                }
                catch (ResourceException ex) {
                    throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2000", ex);
                }
            }
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_1001");
        }
        catch (Throwable throwable) {
            block7: {
                Object var8_9 = null;
                this.monitorMetadata.endComponent(this.getClass(), "findTableInternal(List, QueryFilters)");
                if (isInRequest) break block7;
                this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
            }
            throw throwable;
        }
    }

    public IBIRelationalObjectFinder getObjectFinder() throws BIResourceException {
        IBIRelationalObjectFinder iBIRelationalObjectFinder;
        String method = "getObjectFinder()";
        loggingLoc.entering("getObjectFinder()");
        try {
            if (this.objectFinder == null) {
                this.objectFinder = new ObjectFinder();
            }
            iBIRelationalObjectFinder = this.objectFinder;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return iBIRelationalObjectFinder;
    }

    public IBIQuery createQuery() throws BIResourceException {
        BIQuery bIQuery;
        String method = "createQuery()";
        loggingLoc.entering("createQuery()");
        try {
            bIQuery = new BIQuery((IBIQueryExecute)this, this.connectionInfo);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bIQuery;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getColumn(Table table) throws BIResourceException {
        List list;
        boolean isInRequest;
        block8: {
            List list2;
            block7: {
                String method = "getColumn(Table)";
                loggingLoc.entering("getColumn(Table)");
                isInRequest = this.monitorMetadata.getCurrentRequest() != null;
                try {
                    if (!isInRequest) {
                        this.monitorMetadata.startRequest(IBIMonitor.Request.METADATA);
                    }
                    this.monitorMetadata.startComponent(this.getClass(), "getColumn(Table)");
                    if (table == null) {
                        list2 = Collections.EMPTY_LIST;
                        Object var6_6 = null;
                        this.monitorMetadata.endComponent(this.getClass(), "getColumn(Table)");
                        if (!isInRequest) {
                            this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
                        }
                        break block7;
                    }
                    list = table.getFeature();
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.monitorMetadata.endComponent(this.getClass(), "getColumn(Table)");
                    if (!isInRequest) {
                        this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
                    }
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return list2;
        }
        Object var6_7 = null;
        this.monitorMetadata.endComponent(this.getClass(), "getColumn(Table)");
        if (!isInRequest) {
            this.monitorMetadata.endRequest(IBIMonitor.Request.METADATA);
        }
        loggingLoc.exiting();
        return list;
    }

    public RefPackage getRefPackage() throws BIResourceException {
        RefPackage refPackage;
        String method = "getRefPackage()";
        loggingLoc.entering("getRefPackage()");
        try {
            this.assertConnectedToMDR();
            refPackage = this.outerMost;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return refPackage;
    }

    private void setupMonitor() {
        this.monitorConnection = BIMonitor.createMonitor(this.connectionInfo);
        this.monitorMetadata = BIMonitor.createMonitor(this.connectionInfo);
        this.monitorQuery = BIMonitor.createMonitor(this.connectionInfo);
    }

    protected void assertConnectedToMDR() throws BIResourceException {
        if (this.mdr == null) {
            this.connectMDR();
        }
    }

    protected abstract void connectMDR() throws BIResourceException;

    protected abstract void connectDB() throws BIResourceException;

    protected abstract void closeDB() throws BIResourceException;

    protected abstract boolean isAliveDB();

    protected abstract String getAttributeEISProductName();

    protected abstract String getAttributeEISProductVersion();

    protected abstract String getAttributeUserName();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Attributes {
        private String EISProductName;
        private String EISProductVersion;
        private String userName;

        protected Attributes() {
        }

        public String getEISProductName() {
            return CommonConnection.this.getAttributeEISProductName();
        }

        public String getEISProductVersion() {
            return CommonConnection.this.getAttributeEISProductVersion();
        }

        public String getUserName() {
            return CommonConnection.this.getAttributeUserName();
        }
    }

    private class ObjectFinder
    extends RelationalObjectFinder
    implements IBIRelationalObjectFinder {
        private ObjectFinder() {
            String method = "ObjectFinder()";
            try {
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }

        protected List findTable(List qualifiedName, QueryFilters filters) throws BIResourceException {
            List list;
            String method = "findTable(List, QueryFilters)";
            loggingLoc.entering("findTable(List, QueryFilters)");
            try {
                list = CommonConnection.this.findTableInternal(qualifiedName, filters);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                loggingLoc.exiting();
                throw throwable;
            }
            loggingLoc.exiting();
            return list;
        }
    }

    protected class ConnectionInfo
    implements IBIConnectionInfo {
        Locale locale = null;
        String user = null;

        protected ConnectionInfo() {
            this.user = CommonConnection.this.properties.getProperty(BIConnectionConstants.USERNAME.toString());
            this.locale = BILogonLanguage.getLocale(CommonConnection.this.properties.getProperty(BIConnectionConstants.LANGUAGE.toString()));
        }

        public String getUser() {
            if (CommonConnection.this.isAliveDB()) {
                return this.user;
            }
            return "";
        }

        public Locale getLocale() {
            if (CommonConnection.this.isAliveDB()) {
                return this.locale;
            }
            return Locale.getDefault();
        }
    }
}

