/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.olap.schema.AttributeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.BISAPVariableObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.CubeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.DimensionObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelBasedHierarchyObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.MeasureObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.MemberObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.OlapSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.SchemaObject;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.MultiHash;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OlapMetaStore
extends MultiHash {
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection = OlapMetaStore.class$("com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor;
    public static final String OBJECT = "OBJECT";
    public static final String INSTANCE = "INSTANCE";
    public static final String CATALOG = "CATALOG";
    public static final String CATALOG_SCHEMA = "CATALOG->SCHEMA";
    public static final String SCHEMA = "SCHEMA";
    public static final String SCHEMA_CUBE = "SCHEMA->CUBE";
    public static final String SCHEMA_DIMENSION = "SCHEMA->DIMENSION";
    public static final String CUBE = "CUBE";
    public static final String CUBE_MEASURE = "CUBE->MEASURE";
    public static final String CUBE_DIMENSION = "CUBE->DIMENSION";
    public static final String DIMENSION_HIERARCHY = "DIMENSION->HIERARCHY";
    public static final String DIMENSION = "DIMENSION";
    public static final String DIMENSION_LEVEL = "DIMENSION->LEVEL";
    public static final String DIMENSION_MEMBER = "DIMENSION->MEMBER";
    public static final String HIERARCHY = "HIERARCHY";
    public static final String HIERARCHY_LEVEL = "HIERARCHY->LEVEL";
    public static final String LEVEL = "LEVEL";
    public static final String LEVEL_MEMBER = "LEVEL->MEMBER";
    public static final String MEMBER = "MEMBER";
    public static final String MEASURE = "MEASURE";
    public static final String TAGGEDVALUE = "TAGGEDVALUE";
    public static final String DIMENSION_ATTRIBUTE = "DIMENSION->ATTRIBUTE";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String SAPVARIABLE = "SAPVARIABLE";
    public static final String CUBE_SAPVARIABLE = "CUBE->SAPVARIABLE";
    private Map store = new HashMap();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection;

    public void clear() {
        this.store.clear();
    }

    public OlapSchemaObject getObjectByMofId(String mofId) {
        return (OlapSchemaObject)this.getStore(OBJECT).get(mofId);
    }

    public OlapSchemaObject getObjectByName(String qualifiedName) {
        return (OlapSchemaObject)this.getStore(OBJECT).get(qualifiedName);
    }

    public Object getInstance(OlapSchemaObject obj) {
        return this.getStore(INSTANCE).get(obj.toString());
    }

    public Object getInstanceByName(String qualifiedName) {
        return this.getStore(INSTANCE).get(qualifiedName);
    }

    public Object getInstanceByMofId(String mofId) {
        return this.getStore(INSTANCE).get(mofId);
    }

    public void putInstance(OlapSchemaObject obj, Object instance) {
        this.add(OBJECT, obj.getMofId(), obj);
        this.add(OBJECT, obj.toString(), instance);
        this.add(INSTANCE, obj.getMofId(), instance);
        this.add(INSTANCE, obj.toString(), instance);
    }

    public void putInstanceByMofId(String mofId, Object instance) {
        this.add(INSTANCE, mofId, instance);
    }

    public boolean containsCatalog(CatalogObject catalog) {
        return this.getCatalog().containsKey(catalog.toString());
    }

    public void addCatalog(CatalogObject catalog) {
        if (catalog != null) {
            this.add(CATALOG, catalog.toString(), catalog);
        }
    }

    public Map getCatalog() {
        return this.getStore(CATALOG);
    }

    public CatalogObject getCatalog(SchemaObject schema) {
        if (schema == null) {
            return (CatalogObject)this.getStore(CATALOG).get(null);
        }
        return (CatalogObject)this.getStore(CATALOG).get(schema.getQualifiedCatalogName());
    }

    public void addSchema(SchemaObject schema) {
        if (schema != null) {
            this.add(SCHEMA, schema.toString(), schema);
        }
    }

    public boolean containsSchema(SchemaObject schema) {
        return this.getSchema().containsKey(schema.getQualifiedSchemaName());
    }

    public Map getSchema() {
        return this.getStore(SCHEMA);
    }

    public Set getSchema(SchemaObject schema) {
        if (schema == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(SCHEMA).get(schema.getQualifiedSchemaName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public SchemaObject getSchema(CubeObject cube) {
        if (cube == null) {
            return (SchemaObject)this.getStore(SCHEMA).get(null);
        }
        return (SchemaObject)this.getStore(SCHEMA).get(cube.getQualifiedSchemaName());
    }

    public SchemaObject getSchema(DimensionObject dimension) {
        if (dimension == null) {
            return (SchemaObject)this.getStore(SCHEMA).get(null);
        }
        return (SchemaObject)this.getStore(SCHEMA).get(dimension.getQualifiedSchemaName());
    }

    public boolean containsDimension(DimensionObject dimension) {
        return this.getDimension().containsKey(dimension.getQualifiedDimensionName());
    }

    public void addDimension(DimensionObject dimension) {
        if (dimension != null) {
            this.add(DIMENSION, dimension.toString(), dimension);
            this.addMultiple(SCHEMA_DIMENSION, (Object)dimension.getQualifiedSchemaName(), dimension);
            this.addMultiple(CUBE_DIMENSION, (Object)dimension.getQualifiedCubeName(), dimension);
        }
    }

    public Map getDimension() {
        return this.getStore(DIMENSION);
    }

    public Set getDimension(SchemaObject schema) {
        if (schema == null) {
            return null;
        }
        return (Set)this.getStore(SCHEMA_DIMENSION).get(schema.toString());
    }

    public Set getDimensionofSchema(DimensionObject dimension) {
        if (dimension == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(SCHEMA_DIMENSION).get(dimension.getQualifiedSchemaName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getDimension(CubeObject cube) {
        if (cube == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CUBE_DIMENSION).get(cube.getQualifiedCubeName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getDimensionofCube(DimensionObject dimension) {
        if (dimension == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CUBE_DIMENSION).get(dimension.getQualifiedCubeName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public DimensionObject getDimension(LevelObject level) {
        if (level == null) {
            return (DimensionObject)this.getStore(DIMENSION).get(null);
        }
        return (DimensionObject)this.getStore(DIMENSION).get(level.getQualifiedDimensionName());
    }

    public DimensionObject getDimension(MemberObject member) {
        if (member == null) {
            return (DimensionObject)this.getStore(DIMENSION).get(null);
        }
        return (DimensionObject)this.getStore(DIMENSION).get(member.getQualifiedDimensionName());
    }

    public DimensionObject getDimension(LevelBasedHierarchyObject hierarchy) {
        if (hierarchy == null) {
            return (DimensionObject)this.getStore(DIMENSION).get(null);
        }
        return (DimensionObject)this.getStore(DIMENSION).get(hierarchy.getQualifiedDimensionName());
    }

    public boolean containsCube(CubeObject cube) {
        if (cube == null) {
            return this.getCube().containsKey(null);
        }
        return this.getCube().containsKey(cube.getQualifiedCubeName());
    }

    public void addCube(CubeObject cube) {
        if (cube != null) {
            this.add(CUBE, cube.toString(), cube);
            this.addMultiple(SCHEMA_CUBE, (Object)cube.getQualifiedSchemaName(), cube);
        }
    }

    public Map getCube() {
        return this.getStore(CUBE);
    }

    public Set getCube(SchemaObject schema) {
        if (schema == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(SCHEMA_CUBE).get(schema.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getCube(CubeObject cube) {
        if (cube == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(SCHEMA_CUBE).get(cube.getQualifiedSchemaName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public CubeObject getCube(DimensionObject dimension) {
        if (dimension == null) {
            return (CubeObject)this.getStore(CUBE).get(null);
        }
        return (CubeObject)this.getStore(CUBE).get(dimension.getQualifiedCubeName());
    }

    public CubeObject getCube(MeasureObject measure) {
        if (measure == null) {
            return (CubeObject)this.getStore(CUBE).get(null);
        }
        return (CubeObject)this.getStore(CUBE).get(measure.getQualifiedCubeName());
    }

    public CubeObject getCube(BISAPVariableObject variable) {
        if (variable == null) {
            return (CubeObject)this.getStore(CUBE).get(null);
        }
        return (CubeObject)this.getStore(CUBE).get(variable.getQualifiedCubeName());
    }

    public boolean containsHierarchy(LevelBasedHierarchyObject hierarchy) {
        if (hierarchy == null) {
            return this.getHierarchy().containsKey(null);
        }
        return this.getHierarchy().containsKey(hierarchy.getQualifiedHierarchyName());
    }

    public void addHierarchy(LevelBasedHierarchyObject hierarchy) {
        if (hierarchy != null) {
            this.add(HIERARCHY, hierarchy.toString(), hierarchy);
            this.addMultiple(DIMENSION_HIERARCHY, (Object)hierarchy.getQualifiedDimensionName(), hierarchy);
        }
    }

    public Map getHierarchy() {
        return this.getStore(HIERARCHY);
    }

    public Set getHierarchy(DimensionObject dimension) {
        if (dimension == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_HIERARCHY).get(dimension.getQualifiedDimensionName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public LevelBasedHierarchyObject getHierarchy(LevelObject level) {
        if (level == null) {
            return (LevelBasedHierarchyObject)this.getStore(HIERARCHY).get(null);
        }
        return (LevelBasedHierarchyObject)this.getStore(HIERARCHY).get(level.getQualifiedHierarchyName());
    }

    public Set getHierarchy(LevelBasedHierarchyObject hierarchy) {
        if (hierarchy == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_HIERARCHY).get(hierarchy.getQualifiedDimensionName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public boolean containsLevel(LevelObject level) {
        if (level == null) {
            return this.getLevel().containsKey(null);
        }
        return this.getLevel().containsKey(level.getQualifiedLevelName());
    }

    public void addLevel(LevelObject level) {
        if (level != null) {
            this.add(LEVEL, level.toString(), level);
            this.addMultiple(DIMENSION_LEVEL, (Object)level.getQualifiedDimensionName(), level);
            this.addMultiple(HIERARCHY_LEVEL, (Object)level.getQualifiedHierarchyName(), level);
        }
    }

    public Map getLevel() {
        return this.getStore(LEVEL);
    }

    public Set getLevel(DimensionObject dimension) {
        if (dimension == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_LEVEL).get(dimension.getQualifiedDimensionName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getLevel(LevelBasedHierarchyObject hierarchy) {
        if (hierarchy == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(HIERARCHY_LEVEL).get(hierarchy.getQualifiedHierarchyName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getLevelofDimension(LevelObject level) {
        if (level == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_LEVEL).get(level.getQualifiedDimensionName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getLevelofHierarchy(LevelObject level) {
        if (level == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(HIERARCHY_LEVEL).get(level.getQualifiedHierarchyName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public LevelObject getLevel(MemberObject member) {
        if (member == null) {
            return (LevelObject)this.getStore(LEVEL).get(null);
        }
        return (LevelObject)this.getStore(LEVEL).get(member.getQualifiedLevelName());
    }

    public void addMember(MemberObject member) {
        if (member != null) {
            this.add(MEMBER, member.toString(), member);
            this.addMultiple(DIMENSION_MEMBER, (Object)member.getQualifiedDimensionName(), member);
        }
    }

    public boolean containsMember(MemberObject member) {
        return this.getMember().containsKey(member.toString());
    }

    public Map getMember() {
        return this.getStore(MEMBER);
    }

    public Set getMember(DimensionObject dimension) {
        if (dimension == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_MEMBER).get(dimension.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getMember(MemberObject member) {
        if (member == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_MEMBER).get(member.getQualifiedDimensionName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public void addMeasure(MeasureObject measure) {
        if (measure != null) {
            this.add(MEASURE, measure.toString(), measure);
            this.addMultiple(CUBE_MEASURE, (Object)measure.getQualifiedCubeName(), measure);
        }
    }

    public boolean containsMeasure(MeasureObject measure) {
        return this.getMeasure().containsKey(measure.toString());
    }

    public Map getMeasure() {
        return this.getStore(MEASURE);
    }

    public Set getMeasure(CubeObject cube) {
        if (cube == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CUBE_MEASURE).get(cube.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getMeasure(MeasureObject measure) {
        if (measure == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CUBE_MEASURE).get(measure.getQualifiedCubeName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getAttribute(DimensionObject dimension) {
        if (dimension == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(DIMENSION_ATTRIBUTE).get(dimension.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Map getAttribute() {
        return this.getStore(ATTRIBUTE);
    }

    public boolean containsAttribute(AttributeObject attribute) {
        return this.getAttribute().containsKey(attribute.toString());
    }

    public void addAttribute(AttributeObject attribute, OlapSchemaObject schemaObject) {
        if (attribute != null) {
            this.add(ATTRIBUTE, attribute.toString(), attribute);
            if (schemaObject instanceof DimensionObject) {
                this.addMultiple(DIMENSION_ATTRIBUTE, (Object)attribute.getQualifiedDimensionName(), attribute);
            }
        }
    }

    public void AddTaggedValue(String mofId, Object taggedValue) {
        this.addMultiple(TAGGEDVALUE, (Object)mofId, new ComparableWrap(taggedValue));
    }

    public List getTaggedValue(String mofId) {
        if (mofId == null) {
            return Collections.EMPTY_LIST;
        }
        Set set = (Set)this.getStore(TAGGEDVALUE).get(mofId);
        if (set == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> alist = new ArrayList<Object>();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            alist.add(((ComparableWrap)i.next()).getObject());
        }
        return alist;
    }

    public void addSAPVariable(BISAPVariableObject variable) {
        if (variable != null) {
            this.add(SAPVARIABLE, variable.toString(), variable);
            this.addMultiple(CUBE_SAPVARIABLE, (Object)variable.getQualifiedCubeName(), variable);
        }
    }

    public boolean containsSAPVariable(BISAPVariableObject variable) {
        return this.getSAPVariable().containsKey(variable.toString());
    }

    public Set getSAPVariable(CubeObject cube) {
        if (cube == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.getStore(CUBE_SAPVARIABLE).get(cube.toString());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public Map getSAPVariable() {
        return this.getStore(SAPVARIABLE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ComparableWrap
    implements Comparable {
        private Object obj = null;

        public ComparableWrap(Object obj) {
            this.obj = obj;
        }

        public Object getObject() {
            return this.obj;
        }

        public int compareTo(Object o) {
            return 1;
        }
    }
}

