/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.relational.MetaStore;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalPersistenceMetaData;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.ColumnObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.impl.BISqlOdboType;
import com.sap.ip.bi.sdk.util.impl.BISqlSchemaNameMatcher;
import com.sap.ip.bi.sdk.util.impl.BISqlTypeName;
import com.sap.ip.bi.sdk.util.impl.BIStringMatcher;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public abstract class OlapMDRConnectionRelational
extends RelationalMDRConnection
implements RelationalPersistenceMetaData {
    protected MetaStore metaStore = new MetaStore();
    private DatabaseMetaData jdbcMeta = null;
    protected CommonConnection connection = null;
    protected static final TableType TABLE_TYPE_VIEW = TableType.VIEW;
    protected static final String OLAP_TYPE = "OLAP_TYPE";
    protected static final String OLAP_TYPE_MEASURE = "MEASURE";
    protected static final String OLAP_TYPE_DIMENSION = "DIMENSION";
    protected final short DIMTYPE_MEASURE = (short)2;

    public OlapMDRConnectionRelational(CommonConnection connection, IBIConnectionInfo connectionInfo) throws BIResourceException {
        super(connectionInfo);
        this.connection = connection;
    }

    public void assertMetaDataLoaded() throws BIResourceException {
        if (this.connection == null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3000");
        }
    }

    public void assertCatalogsLoaded() throws BIResourceException {
        this.assertMetaDataLoaded();
        if (this.metaStore.getCatalog().isEmpty()) {
            RemappedRecordSet catalogs = this.getCatalogRecordSet();
            catalogs.first();
            while (catalogs.hasNext()) {
                TableObject table = this.tableObjectFromCube(catalogs);
                new TableObject(catalogs.getString("CATALOG_NAME"), catalogs.getString("SCHEMA_NAME"), catalogs.getString("CUBE_NAME"), TABLE_TYPE_VIEW);
                CatalogObject catalog = new CatalogObject(table.getCatalogName());
                SchemaObject schema = new SchemaObject(table.getCatalogName(), table.getSchemaName());
                if (!this.metaStore.containsCatalog(catalog)) {
                    this.metaStore.addCatalog(catalog);
                }
                if (!this.metaStore.containsSchema(schema)) {
                    this.metaStore.addSchema(schema);
                }
                if (!this.metaStore.containsTable(table)) {
                    this.metaStore.addTable(table);
                }
                catalogs.next();
            }
        }
    }

    protected abstract RemappedRecordSet getCatalogRecordSet() throws BIResourceException;

    public void assertSchemasLoaded() throws BIResourceException {
        this.assertCatalogsLoaded();
    }

    public void assertSchemasLoaded(CatalogObject catalog) throws BIResourceException {
        this.assertCatalogsLoaded();
    }

    public void assertTablesLoaded() throws BIResourceException {
        this.assertCatalogsLoaded();
    }

    public void assertTablesLoaded(SchemaObject schema) throws BIResourceException {
        this.assertCatalogsLoaded();
    }

    public void assertColumnsLoaded(TableObject table) throws BIResourceException {
        this.assertTableColumnAssocLoaded(table);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertTableColumnAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        this.assertCatalogsLoaded();
        String catalogName = null;
        String schemaName = null;
        String tableName = null;
        String columnNamePattern = null;
        if (obj != null) {
            if (obj instanceof ColumnObject) {
                TableObject tableObj = this.metaStore.getTable((ColumnObject)obj);
                if (!this.metaStore.getColumn(tableObj).isEmpty()) {
                    return;
                }
                catalogName = ((ColumnObject)obj).getCatalogName();
                schemaName = ((ColumnObject)obj).getSchemaName();
                tableName = ((ColumnObject)obj).getTableName();
                columnNamePattern = ((ColumnObject)obj).getColumnName();
            } else {
                if (!(obj instanceof TableObject)) throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1021");
                if (!this.metaStore.getColumn((TableObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((TableObject)obj).getCatalogName();
                schemaName = ((TableObject)obj).getSchemaName();
                tableName = ((TableObject)obj).getTableName();
            }
        } else if (!this.metaStore.getColumn().isEmpty()) {
            return;
        }
        RemappedRecordSet dimensions = this.getDimensionRecordSet(catalogName, schemaName, tableName);
        RemappedRecordSet levels = this.getLevelRecordSet(catalogName, schemaName, tableName);
        Properties levelNames = new Properties();
        String prevLvlUnam = "";
        levels.first();
        String prevHryUnam = levels.getString("HIERARCHY_UNIQUE_NAME");
        while (levels.hasNext()) {
            String hryUnam = levels.getString("HIERARCHY_UNIQUE_NAME");
            String lvlUnam = levels.getString("LEVEL_UNIQUE_NAME");
            if (!hryUnam.equalsIgnoreCase(prevHryUnam)) {
                ((Hashtable)levelNames).put(prevHryUnam, prevLvlUnam);
            }
            prevHryUnam = hryUnam;
            prevLvlUnam = lvlUnam;
            levels.next();
        }
        ((Hashtable)levelNames).put(prevHryUnam, prevLvlUnam);
        String measuresDimUNam = "";
        dimensions.first();
        while (dimensions.hasNext()) {
            ColumnObject column = new ColumnObject(dimensions.getString("CATALOG_NAME"), dimensions.getString("CUBE_NAME"), dimensions.getString("CUBE_NAME"), dimensions.getString("DIMENSION_NAME"));
            column.setDataType((short)12);
            column.setDescription(dimensions.getString("DESCRIPTION"));
            column.setTypeName("String");
            column.setColumnSize(100);
            String dimtype = String.valueOf(dimensions.getShort("DIMENSION_TYPE")).toString();
            if (!"2".equalsIgnoreCase(dimtype)) {
                this.metaStore.addColumn(column);
                this.metaStore.putTaggedValue(column, OLAP_TYPE, OLAP_TYPE_DIMENSION);
                this.metaStore.putTaggedValue(column, "LEVEL_UNIQUE_NAME", levelNames.getProperty(dimensions.getString("DEFAULT_HIERARCHY")));
                this.metaStore.putTaggedValue(column, "DIMENSION_UNIQUE_NAME", dimensions.getString("DIMENSION_UNIQUE_NAME"));
            } else {
                measuresDimUNam = dimensions.getString("DIMENSION_UNIQUE_NAME");
            }
            dimensions.next();
        }
        RemappedRecordSet measures = this.getMeasureRecordSet(catalogName, schemaName, tableName);
        measures.first();
        while (measures.hasNext()) {
            ColumnObject column = new ColumnObject(measures.getString("CATALOG_NAME"), measures.getString("CUBE_NAME"), measures.getString("CUBE_NAME"), measures.getString("MEASURE_NAME"));
            column.setDescription(measures.getString("DESCRIPTION"));
            column.setDecimalDigits(measures.getInt("NUMERIC_SCALE"));
            int datatype = measures.getInt("DATA_TYPE");
            int sqlType = BISqlOdboType.getSqlTypeFromOleDB(datatype);
            column.setDataType((short)sqlType);
            column.setTypeName(BISqlTypeName.getSqlTypeName(sqlType));
            column.setNumPrecRadix(measures.getInt("NUMERIC_PRECISION"));
            this.metaStore.addColumn(column);
            this.metaStore.putTaggedValue(column, OLAP_TYPE, OLAP_TYPE_MEASURE);
            this.metaStore.putTaggedValue(column, "MEASURE_UNIQUE_NAME", measures.getString("MEASURE_UNIQUE_NAME"));
            this.metaStore.putTaggedValue(column, "DIMENSION_UNIQUE_NAME", measuresDimUNam);
            measures.next();
        }
    }

    protected abstract RemappedRecordSet getDimensionRecordSet(String var1, String var2, String var3) throws BIResourceException;

    protected abstract RemappedRecordSet getLevelRecordSet(String var1, String var2, String var3) throws BIResourceException;

    protected abstract RemappedRecordSet getMeasureRecordSet(String var1, String var2, String var3) throws BIResourceException;

    public void assertCatalogSchemaAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        this.assertCatalogsLoaded();
    }

    public void assertSchemaTableAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        this.assertCatalogsLoaded();
    }

    public List assertFindTable(String catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        this.assertCatalogsLoaded();
        ArrayList<TableObject> matchingTables = new ArrayList<TableObject>();
        try {
            BISqlSchemaNameMatcher matchTableName = new BISqlSchemaNameMatcher(tableNamePattern, false);
            RemappedRecordSet tables = this.getTableRecordSet(catalog, schemaPattern, this.preprocessTableNamePattern(tableNamePattern), type);
            tables.first();
            while (tables.hasNext()) {
                TableObject table = this.tableObjectFromCube(tables);
                if (this.matchTableName(matchTableName, tables.getString("CUBE_NAME"))) {
                    if (this.metaStore.containsTable(table)) {
                        matchingTables.add((TableObject)this.metaStore.getTable().get(table.toString()));
                    } else {
                        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2000");
                    }
                }
                tables.next();
            }
        }
        catch (Exception ex) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_3000", ex);
        }
        return matchingTables;
    }

    protected abstract RemappedRecordSet getTableRecordSet(String var1, String var2, String var3, TableType[] var4) throws BIResourceException;

    protected boolean matchTableName(BIStringMatcher matcher, String tableName) {
        return matcher.match(tableName);
    }

    protected String preprocessTableNamePattern(String tableNamePattern) {
        return null;
    }

    public MetaStore getMetaStore() {
        return this.metaStore;
    }

    private TableObject tableObjectFromCube(RemappedRecordSet rs) throws BIResourceException {
        TableObject table = new TableObject(rs.getString("CATALOG_NAME"), rs.getString("CUBE_NAME"), rs.getString("CUBE_NAME"), TABLE_TYPE_VIEW);
        return table;
    }

    public static interface RemappedRecordSet {
        public boolean hasNext() throws BIResourceException;

        public void first() throws BIResourceException;

        public void next() throws BIResourceException;

        public int getInt(String var1) throws BIResourceException;

        public String getString(String var1) throws BIResourceException;

        public short getShort(String var1) throws BIResourceException;
    }
}

