/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.IBIRelationalObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMDRConnectionRelational;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.relational.query.mdx.impl.BIParseQueryExpression;
import com.sap.ip.bi.sdk.dac.result.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIDimensionCursor;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.filter.BIRemappingResultSetFilter;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.search.QueryFilters;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.Table;

public abstract class CommonRelationalConnection
extends CommonConnection
implements IBIQueryExecute {
    protected OlapMDRConnectionRelational mdrRelational = null;
    protected RefPackage outerMostRelational = null;
    protected IBIRelationalObjectFinder relationalObjectFinder = null;

    protected abstract void connectMDRRelational() throws BIResourceException;

    protected void assertConnectedToMDRRelational() throws BIResourceException {
        if (this.mdrRelational == null) {
            this.connectMDRRelational();
        }
    }

    public List getCatalogRelational() throws BIResourceException {
        this.assertConnectedToMDRRelational();
        return this.mdrRelational.getCatalog();
    }

    public void setCurrentCatalogRelational(Catalog current) throws BIResourceException {
        this.mdrRelational.setCurrentCatalog(current);
    }

    public Catalog getCurrentCatalogRelational() throws BIResourceException {
        return this.mdrRelational.getCurrentCatalog();
    }

    public List getSchemaRelational() throws BIResourceException {
        this.assertConnectedToMDRRelational();
        return this.mdrRelational.getSchema();
    }

    public void setCurrentSchemaRelational(Schema current) throws BIResourceException {
        this.mdrRelational.setCurrentSchema(current);
    }

    public Schema getCurrentSchemaRelational() throws BIResourceException {
        return this.mdrRelational.getCurrentSchema();
    }

    public List getTableRelational() throws BIResourceException {
        this.assertConnectedToMDRRelational();
        return this.mdrRelational.getTable();
    }

    public List getColumnRelational(Table table) throws BIResourceException {
        return table.getFeature();
    }

    public RefPackage getRefPackageRelational() throws BIResourceException {
        this.assertConnectedToMDRRelational();
        return this.outerMostRelational;
    }

    public IBIRelationalObjectFinder getObjectFinderRelational() throws BIResourceException {
        if (this.relationalObjectFinder == null) {
            this.relationalObjectFinder = new RelationalObjectFinder();
        }
        return this.relationalObjectFinder;
    }

    protected abstract IBIDataSet getDataSet(String var1) throws BIResourceException;

    public ResultSet executeRelational(Object nativeQuery) throws BIResourceException {
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Object getNativeRepresentationRelational(IBIQuery query) throws BIResourceException {
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Boolean supportsRelational(IBIRelational.Supports feature) {
        return Boolean.FALSE;
    }

    public ResultSet executeRelational(IBIQuery query) throws BIResourceException {
        BIParseQueryExpression p = new BIParseQueryExpression(query, this.connectionInfo);
        BIColumnMetaData[] metaData = p.getColumnMetaData();
        int[] indexMap = p.getRemappingIndex(metaData);
        IBIDataSet dataSet = this.getDataSet(p.getCommandText());
        IBIAxisCursor rows = null;
        IBIAxisCursor cols = null;
        List dims = null;
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        BIResultSet rs = null;
        try {
            rows = dataSet.getAxisCursor(1);
            cols = dataSet.getAxisCursor(0);
            dims = rows.getDimensionCursor();
            rows.beforeFirst();
            while (rows.next()) {
                Object[] row = new Object[metaData.length];
                int j = 0;
                while (j < dims.size()) {
                    IBIDimensionCursor dc = (IBIDimensionCursor)dims.get(j);
                    row[j] = this.parseUniqueName(dc.getString(1));
                    ++j;
                }
                cols.beforeFirst();
                while (j < metaData.length) {
                    cols.next();
                    row[j] = dataSet.getString(1);
                    ++j;
                }
                data.add(row);
            }
            rs = new BIResultSet(this.connectionInfo, (IBIResultSetData)new BIResultSetData(this.connectionInfo, data), (IBIColumnMetaData[])metaData, IBIResultSet.Type.UNRESTRICTED, false);
            return new BIRemappingResultSetFilter(this.connectionInfo, (IBIResultSet)rs, "", indexMap);
        }
        catch (SQLException ex) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", ex);
        }
    }

    protected String parseUniqueName(String unam) {
        return unam.substring(unam.lastIndexOf("[") + 1, unam.length() - 1);
    }

    public ResultSet execute(IBIQuery query) throws BIResourceException {
        return this.executeRelational(query);
    }

    public Object getNativeRepresentation(IBIQuery query) throws BIResourceException {
        return this.getNativeRepresentationRelational(query);
    }

    public RefPackage getRefPackage() throws BIResourceException {
        return this.getRefPackageRelational();
    }

    public Boolean supports(IBIRelational.Supports feature) {
        return this.supportsRelational(feature);
    }

    final class RelationalObjectFinder
    extends com.sap.ip.bi.sdk.dac.connector.relational.RelationalObjectFinder
    implements IBIRelationalObjectFinder {
        RelationalObjectFinder() {
        }

        protected List findTable(List qualifiedTableName, QueryFilters filter) throws BIResourceException {
            CommonRelationalConnection.this.assertConnectedToMDRRelational();
            IConnection c = CommonRelationalConnection.this.mdrRelational.getConnection();
            if (c != null) {
                try {
                    return c.queryM1(qualifiedTableName, filter, false);
                }
                catch (ResourceException ex) {
                    throw new BIResourceException(CommonRelationalConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.rel_2000", ex);
                }
            }
            throw new BIRuntimeException(CommonRelationalConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.mmr_1001");
        }
    }
}

