/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.olap.BISAPVariableConstants;
import com.sap.ip.bi.sdk.dac.connector.olap.BITreeOperator;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMDRConnection;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable;
import com.sap.ip.bi.sdk.dac.result.IBIResultSet;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BIMonitor;
import com.sap.ip.bi.sdk.util.impl.CPUMonitor;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;
import org.omg.cwm.analysis.olap.Measure;
import org.omg.cwm.analysis.olap.Schema;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedValue;

public abstract class CommonConnection {
    private CPUMonitor cpuMonitor = CPUMonitor.getInstance();
    protected IBIConnectionInfo connectionInfo = null;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection = CommonConnection.class$("com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = BIMonitor.createMonitor();
    protected OlapMDRConnection mdr = null;
    protected IBIOlapObjectFinder objectFinder = null;
    protected static final List QUALIFIED_SCHEMA_NAME = Arrays.asList("org.omg.cwm.analysis.olap.Schema");
    protected static final List QUALIFIED_CUBE_NAME = Arrays.asList("org.omg.cwm.analysis.olap.Cube");
    protected static final List QUALIFIED_DIMENSION_NAME = Arrays.asList("org.omg.cwm.analysis.olap.Dimension");
    protected static final List QUALIFIED_HIERARCHY_NAME = Arrays.asList("org.omg.cwm.analysis.olap.LevelBasedHierarchy");
    protected static final List QUALIFIED_LEVEL_NAME = Arrays.asList("org.omg.cwm.analysis.olap.Level");
    protected static final List QUALIFIED_MEMBER_NAME = Arrays.asList("com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember");
    protected static final List QUALIFIED_MEASURE_NAME = Arrays.asList("org.omg.cwm.analysis.olap.Measure");
    protected static final List QUALIFIED_SAPVARIABLE_NAME = Arrays.asList("com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable");
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection;

    public List getSchema() throws BIResourceException {
        this.assertConnectedToMDR();
        return this.mdr.getSchema();
    }

    public List getCube() throws BIResourceException {
        this.cpuMonitor.addMonitor("CommonConnection:start getCube");
        this.assertConnectedToMDR();
        this.cpuMonitor.addMonitor("CommonConnection:getCube:After assertConnectedToMDR");
        return this.mdr.getCube();
    }

    public RefPackage getTopLevelPackage() throws BIResourceException {
        this.assertConnectedToMDR();
        return this.mdr.getOuterMostPackage();
    }

    protected void assertConnectedToMDR() throws BIResourceException {
        if (this.mdr == null) {
            this.connectMdr();
        }
    }

    public abstract void connectMdr() throws BIResourceException;

    protected String getSchemaAttribute(String schemaKey, Collection tags) {
        Iterator tIter = tags.iterator();
        while (tIter.hasNext()) {
            TaggedValue t = (TaggedValue)tIter.next();
            if (t == null || !t.getTag().equals(schemaKey)) continue;
            return t.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract class AbstractObjectFinder
    implements IBIOlapObjectFinder {
        private List findSchemaInternal(String schemaName) throws BIResourceException {
            loc.entering("findSchemaInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_SCHEMA_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Schema"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Schema"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        public List findCube(String schemaName, String cubeName) throws BIResourceException {
            CommonConnection.this.assertConnectedToMDR();
            return this.findCubeInternal(schemaName, cubeName);
        }

        private List findCubeInternal(String schemaName, String cubeName) throws BIResourceException {
            loc.entering("findCubeInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    if (cubeName != null) {
                        filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_CUBE_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Cube"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Cube"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        private List findDimensionInternal(String schemaName, String cubeName, String dimensionName) throws BIResourceException {
            loc.entering("findDimensionInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    if (cubeName != null) {
                        filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                    }
                    if (dimensionName != null) {
                        filters.add(new QueryFilter("DIMENSION_NAME", 0, dimensionName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_DIMENSION_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Dimension"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Dimension"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        private List findMeasureInternal(String schemaName, String cubeName, String measureName) throws BIResourceException {
            loc.entering("findMeasureInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    if (cubeName != null) {
                        filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                    }
                    if (measureName != null) {
                        filters.add(new QueryFilter("MEASURE_NAME", 0, measureName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_MEASURE_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Measure"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Measure"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        private List findHierarchyInternal(String schemaName, String cubeName, String dimensionName, String hierarchyName) throws BIResourceException {
            loc.entering("findHierarchyInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    if (cubeName != null) {
                        filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                    }
                    if (dimensionName != null) {
                        filters.add(new QueryFilter("DIMENSION_NAME", 0, dimensionName));
                    }
                    if (hierarchyName != null) {
                        filters.add(new QueryFilter("HIERARCHY_NAME", 0, hierarchyName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_HIERARCHY_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Hierarchy"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Hierarchy"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        private List findLevelInternal(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName) throws BIResourceException {
            loc.entering("findLevelInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    if (cubeName != null) {
                        filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                    }
                    if (dimensionName != null) {
                        filters.add(new QueryFilter("DIMENSION_NAME", 0, dimensionName));
                    }
                    if (hierarchyName != null) {
                        filters.add(new QueryFilter("HIERARCHY_NAME", 0, hierarchyName));
                    }
                    if (levelName != null) {
                        filters.add(new QueryFilter("LEVEL_NAME", 0, levelName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_LEVEL_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Level"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Level"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        public abstract List findMember(String var1, String var2, String var3, String var4, String var5, String var6, BITreeOperator var7) throws BIResourceException;

        public abstract IBIMember findMemberFirst(String var1, String var2, String var3, String var4, String var5, String var6, BITreeOperator var7) throws BIResourceException;

        public List findCube(Schema schema, String cubeName) throws BIResourceException {
            return this.findCube(schema == null ? null : schema.getName(), cubeName);
        }

        public Cube findCubeFirst(Schema schema, String cubeName) throws BIResourceException {
            List cubes = this.findCube(schema, cubeName);
            if (cubes != null & cubes.size() > 0) {
                return (Cube)cubes.get(0);
            }
            return null;
        }

        public List findDimension(Cube cube, String dimensionName) throws BIResourceException {
            Collection tvs = CommonConnection.this.mdr.getTaggedValue((ModelElement)cube);
            return this.findDimension(this.getSchemaName(tvs), cube.getName(), dimensionName);
        }

        public Dimension findDimensionFirst(Cube cube, String dimensionName) throws BIResourceException {
            List dimensions = this.findDimension(cube, dimensionName);
            if (dimensions != null & dimensions.size() > 0) {
                return (Dimension)dimensions.get(0);
            }
            return null;
        }

        private String getSchemaName(Collection tvs) {
            String catalog = CommonConnection.this.getSchemaAttribute("CATALOG_NAME", tvs);
            String schema = CommonConnection.this.getSchemaAttribute("SCHEMA_NAME", tvs);
            return catalog == null ? "" : catalog;
        }

        public List findHierarchy(Dimension dimension, String hierarchyName) throws BIResourceException {
            Collection tvs = CommonConnection.this.mdr.getTaggedValue((ModelElement)dimension);
            return this.findHierarchy(this.getSchemaName(tvs), CommonConnection.this.getSchemaAttribute("CUBE_NAME", tvs), dimension.getName(), hierarchyName);
        }

        public LevelBasedHierarchy findHierarchyFirst(Dimension dimension, String hierarchyName) throws BIResourceException {
            List hierarchies = this.findHierarchy(dimension, hierarchyName);
            if (hierarchies != null & hierarchies.size() > 0) {
                return (LevelBasedHierarchy)hierarchies.get(0);
            }
            return null;
        }

        public List findLevel(LevelBasedHierarchy hierarchy, String levelName) throws BIResourceException {
            Collection tvs = CommonConnection.this.mdr.getTaggedValue((ModelElement)hierarchy);
            return this.findLevel(this.getSchemaName(tvs), CommonConnection.this.getSchemaAttribute("CUBE_NAME", tvs), MetadataNameConverter.dimensionUniqueNametoDimensionName(CommonConnection.this.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tvs)), CommonConnection.this.getSchemaAttribute("HIERARCHY_NAME", tvs), levelName);
        }

        public Level findLevelFirst(LevelBasedHierarchy hierarchy, String levelName) throws BIResourceException {
            List levels = this.findLevel(hierarchy, levelName);
            if (levels != null & levels.size() > 0) {
                return (Level)levels.get(0);
            }
            return null;
        }

        public abstract List findMember(Level var1, String var2, BITreeOperator var3) throws BIResourceException;

        public abstract IBIMember findMemberFirst(Level var1, String var2, BITreeOperator var3) throws BIResourceException;

        public List findMeasure(Cube cube, String measureName) throws BIResourceException {
            Collection tvs = CommonConnection.this.mdr.getTaggedValue((ModelElement)cube);
            return this.findMeasure(this.getSchemaName(tvs), cube.getName(), measureName);
        }

        public Measure findMeasureFirst(Cube cube, String measureName) throws BIResourceException {
            List measures = this.findMeasure(cube, measureName);
            if (measures != null & measures.size() > 0) {
                return (Measure)measures.get(0);
            }
            return null;
        }

        public List findSchema(String schemaName) throws BIResourceException {
            CommonConnection.this.assertConnectedToMDR();
            return this.findSchemaInternal(schemaName);
        }

        public Schema findSchemaFirst(String schemaName) throws BIResourceException {
            List schemas = this.findSchema(schemaName);
            if (schemas != null & schemas.size() > 0) {
                return (Schema)schemas.get(0);
            }
            return null;
        }

        public Cube findCubeFirst(String schemaName, String cubeName) throws BIResourceException {
            List cubes = this.findCube(schemaName, cubeName);
            if (cubes != null & cubes.size() > 0) {
                return (Cube)cubes.get(0);
            }
            return null;
        }

        public List findDimension(String schemaName, String cubeName, String dimensionName) throws BIResourceException {
            return this.findDimensionInternal(schemaName, cubeName, dimensionName);
        }

        public Dimension findDimensionFirst(String schemaName, String cubeName, String dimensionName) throws BIResourceException {
            List dimensions = this.findDimension(schemaName, cubeName, dimensionName);
            if (dimensions != null & dimensions.size() > 0) {
                return (Dimension)dimensions.get(0);
            }
            return null;
        }

        public List findHierarchy(String schemaName, String cubeName, String dimensionName, String hierarchyName) throws BIResourceException {
            return this.findHierarchyInternal(schemaName, cubeName, dimensionName, hierarchyName);
        }

        public LevelBasedHierarchy findHierarchyFirst(String schemaName, String cubeName, String dimensionName, String hierarchyName) throws BIResourceException {
            List hierarchies = this.findHierarchy(schemaName, cubeName, dimensionName, hierarchyName);
            if (hierarchies != null && hierarchies.size() > 0) {
                return (LevelBasedHierarchy)hierarchies.get(0);
            }
            return null;
        }

        public List findLevel(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName) throws BIResourceException {
            return this.findLevelInternal(schemaName, cubeName, dimensionName, hierarchyName, levelName);
        }

        public Level findLevelFirst(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName) throws BIResourceException {
            List levels = this.findLevel(schemaName, cubeName, dimensionName, hierarchyName, levelName);
            if (levels != null & levels.size() > 0) {
                return (Level)levels.get(0);
            }
            return null;
        }

        public List findMeasure(String schemaName, String cubeName, String measureName) throws BIResourceException {
            return this.findMeasureInternal(schemaName, cubeName, measureName);
        }

        public Measure findMeasureFirst(String schemaName, String cubeName, String measureName) throws BIResourceException {
            List measures = this.findMeasure(schemaName, cubeName, measureName);
            if (measures != null & measures.size() > 0) {
                return (Measure)measures.get(0);
            }
            return null;
        }

        public List findSAPVariable(Cube cube, String variableName) throws BIResourceException {
            Collection tvs = CommonConnection.this.mdr.getTaggedValue((ModelElement)cube);
            return this.findSAPVariable(this.getSchemaName(tvs), cube.getName(), variableName);
        }

        public IBISapVariable findSAPVariableFirst(Cube cube, String variableName) throws BIResourceException {
            List variables = this.findSAPVariable(cube, variableName);
            if (variables != null & variables.size() > 0) {
                return (IBISapVariable)variables.get(0);
            }
            return null;
        }

        public List findSAPVariable(String schemaName, String cubeName, String variableName) throws BIResourceException {
            return this.findSAPVariableInternal(schemaName, cubeName, variableName);
        }

        public IBISapVariable findSAPVariableFirst(String schemaName, String cubeName, String variableName) throws BIResourceException {
            List variables = this.findSAPVariable(schemaName, cubeName, variableName);
            if (variables != null & variables.size() > 0) {
                return (IBISapVariable)variables.get(0);
            }
            return null;
        }

        private List findSAPVariableInternal(String schemaName, String cubeName, String variableName) throws BIResourceException {
            loc.entering("findSAPVariableInternal()");
            CommonConnection.this.monitor.startRequest(IBIMonitor.Request.METADATA);
            CommonConnection.this.assertConnectedToMDR();
            IConnection c = CommonConnection.this.mdr.getConnection();
            if (c != null) {
                try {
                    QueryFilters filters = new QueryFilters();
                    if (schemaName != null) {
                        filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                    }
                    if (cubeName != null) {
                        filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                    }
                    if (variableName != null) {
                        filters.add(new QueryFilter(BISAPVariableConstants.VARIABLE_NAME, 0, variableName));
                    }
                    CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
                    loc.exiting();
                    return c.queryM1(QUALIFIED_SAPVARIABLE_NAME, filters, false);
                }
                catch (ResourceException ex) {
                    loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"SAPVariable"});
                    throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"SAPVariable"}, ex);
                }
            }
            CommonConnection.this.monitor.endRequest(IBIMonitor.Request.METADATA);
            loc.exiting();
            throw new BIResourceException(CommonConnection.this.connectionInfo == null ? Locale.getDefault() : CommonConnection.this.connectionInfo.getLocale());
        }

        public abstract IBIResultSet findMemberData(List var1, List var2) throws BIResourceException;
    }
}

