/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ear.wizard.internal;

import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.wizard.AbstractJ2eeProjectWizardPage;
import com.tssap.j2ee.util.wizard.WizardMsg;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EarProjectRefPage
extends AbstractJ2eeProjectWizardPage {
    private CheckboxTableViewer ctv;
    private IJ2eeProject[] modules;

    public EarProjectRefPage(String pageName, IStartCreateProjectWizard componentWizard, IJ2eeProject[] modules) {
        super(pageName, componentWizard);
        this.setTitle(WizardMsg.getString((String)"NewEarProject.title"));
        this.setDescription(WizardMsg.getString((String)"NewEarProject.refDescription"));
        this.modules = modules;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setText("Referenced Projects");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.ctv = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.ctv.getTable().setLayoutData((Object)data);
        this.ctv.setLabelProvider((IBaseLabelProvider)new J2eeModelLabelProvider());
        this.ctv.setContentProvider((IContentProvider)new InnerRefPageCP(this.modules));
        this.ctv.setInput((Object)"");
        if (this.modules.length == 0) {
            this.ctv.getTable().setEnabled(false);
        }
        this.setControl((Control)composite);
    }

    public IJ2eeProject[] getReferencedProjects() {
        Object[] elements = this.ctv.getCheckedElements();
        IJ2eeProject[] projects = new IJ2eeProject[elements.length];
        System.arraycopy(elements, 0, projects, 0, elements.length);
        return projects;
    }

    private class InnerRefPageCP
    implements IStructuredContentProvider {
        private IJ2eeProject[] modules;

        public InnerRefPageCP(IJ2eeProject[] modules) {
            this.modules = modules;
        }

        public Object[] getElements(Object inputElement) {
            return this.modules;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

