/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ear.editor.internal.ui;

import com.tssap.dii.component.DCProjectInfo;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ear.dd.IAltDd;
import com.tssap.j2ee.model.ear.dd.IModule;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.j2ee.util.portal.ICRDialogCaller;
import com.tssap.j2ee.util.portal.PortalFactory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.FileChooser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public class EarModuleEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ear$editor$internal$ui$EarModuleEditorComponent == null ? (class$com$tssap$j2ee$ui$ear$editor$internal$ui$EarModuleEditorComponent = EarModuleEditorComponent.class$("com.tssap.j2ee.ui.ear.editor.internal.ui.EarModuleEditorComponent")) : class$com$tssap$j2ee$ui$ear$editor$internal$ui$EarModuleEditorComponent));
    private static final String DISPLAYTXT_CONNECTOR_URI = "Connector URI: ";
    private static final String DISPLAYTXT_EJB_URI = "EJB URI: ";
    private static final String DISPLAYTXT_JAVA_URI = "Java URI: ";
    private static final String DISPLAYTXT_WEB_URI = "Web URI: ";
    private static final String DISPLAYTXT_CONTEXTROOT = "Context Root: ";
    private static final String DISPLAYTXT_ALTDD = "Alternative Deployment Descriptor: ";
    private static final String TEXT_CONTEXT_ROOT_BUTTON = "Get context root...";
    private static final String DISPLAYTXT_EMPTY = "";
    private static final String DISPLAYTXT_SPACE = "  ";
    private static final int UNKNOWN = -1;
    private static final int CONNECTOR_DDS = 0;
    private static final int EJB_DDS = 1;
    private static final int JAVA_DDS = 2;
    private static final int WEB_URL_DDS = 3;
    private static final int WEB_CONTEXT_ROOT_DDS = 4;
    private static final int TYPEDDS_COUNT = 5;
    private static final int ALT_DD_DDS = 100;
    private static final int CONNECTOR_RADIO = 0;
    private static final int EJB_RADIO = 1;
    private static final int JAVA_RADIO = 2;
    private static final int WEB_RADIO = 3;
    private static final int RADIOBUTTON_COUNT = 4;
    private DropDownSelector alt_dd_DDS;
    private DropDownSelector[] type_DDS = null;
    private Button[] radios = null;
    private Button contextRootButton;
    private int currentRadioSelection = -1;
    private Boolean dcProject = null;
    private IFile underlyingFile = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ear$editor$internal$ui$EarModuleEditorComponent;

    public EarModuleEditorComponent(String title) {
        super(title);
    }

    public EarModuleEditorComponent(IFile file, IModifiedCallback modifiedCallback) {
        this.underlyingFile = file;
        this.setModifiedCallback(modifiedCallback);
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.createDDS();
        this.alt_dd_DDS.createPartControl(userArea, true, false);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        IGridLayoutData gridData = userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1);
        this.radios = new Button[4];
        int radioGridColCount = this.getUserGridNumOfColumns() + this.type_DDS[0].getUserGridNumOfColumns();
        IGridLayoutPane radioPane = userArea.addGridLayoutPane("Module Type", radioGridColCount, gridData);
        this.radios[0] = radioPane.addRadioButton(DISPLAYTXT_SPACE);
        this.type_DDS[0].createPartControl(radioPane, true, false);
        radioPane.addPlaceholder(radioGridColCount, 1);
        this.radios[1] = radioPane.addRadioButton(DISPLAYTXT_SPACE);
        this.type_DDS[1].createPartControl(radioPane, true, false);
        radioPane.addPlaceholder(radioGridColCount, 1);
        this.radios[2] = radioPane.addRadioButton(DISPLAYTXT_SPACE);
        this.type_DDS[2].createPartControl(radioPane, true, false);
        radioPane.addPlaceholder(radioGridColCount, 1);
        if (this.isDCProject()) {
            this.radios[3] = radioPane.addRadioButton(DISPLAYTXT_SPACE);
            this.type_DDS[3].createPartControl(radioPane, true, false);
            radioPane.addPlaceholder(radioGridColCount, 1);
            this.type_DDS[4].createPartControl(radioPane, true, false);
            this.contextRootButton = radioPane.addPushButton(TEXT_CONTEXT_ROOT_BUTTON, radioPane.createGridLayoutData(1, 4, false, false));
            this.contextRootButton.addSelectionListener((SelectionListener)new ContextRootSelectionListener());
        } else {
            this.radios[3] = radioPane.addRadioButton(DISPLAYTXT_SPACE);
            this.type_DDS[3].createPartControl(radioPane, true, false);
            radioPane.addPlaceholder(1, 1);
            radioPane.addPlaceholder(1, 1);
            this.type_DDS[4].createPartControl(radioPane, true, false);
        }
        int i = 0;
        while (i < 4) {
            this.radios[i].setEnabled(false);
            ++i;
        }
        this.radios[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(0);
            }
        });
        this.radios[1].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(1);
            }
        });
        this.radios[2].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(2);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(2);
            }
        });
        this.radios[3].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EarModuleEditorComponent.this.handleSelection(3);
            }
        });
    }

    private void handleSelection(int selection) {
        if (this.currentRadioSelection == selection) {
            return;
        }
        this.currentRadioSelection = selection;
        this.updateSelection();
    }

    private void handleTextModified(int ddsId) {
        if (!this.isRefreshingUI()) {
            this.dataModified(true);
        }
    }

    private void updateSelection() {
        if (this.type_DDS != null) {
            int i = 0;
            while (i < this.type_DDS.length) {
                this.type_DDS[i].setReadOnly(true);
                ++i;
            }
            if (this.contextRootButton != null && this.currentRadioSelection != 3 && this.currentRadioSelection != -1) {
                this.contextRootButton.setEnabled(false);
            }
            switch (this.currentRadioSelection) {
                case 0: {
                    this.type_DDS[0].setReadOnly(true);
                    break;
                }
                case 1: {
                    this.type_DDS[1].setReadOnly(true);
                    break;
                }
                case 2: {
                    this.type_DDS[2].setReadOnly(true);
                    break;
                }
                case 3: {
                    this.type_DDS[3].setReadOnly(true);
                    if (this.isDCProject()) {
                        this.type_DDS[4].setReadOnly(true);
                        break;
                    }
                    this.type_DDS[4].setReadOnly(!this.isEditable());
                    break;
                }
            }
        }
    }

    private void createDDS() {
        this.alt_dd_DDS = new DropDownSelector(0);
        this.alt_dd_DDS.setSelectorDescription(DISPLAYTXT_ALTDD);
        this.alt_dd_DDS.setDescriptionPositionLeft(false);
        this.alt_dd_DDS.setReadOnly(false);
        this.alt_dd_DDS.setButtonText("...");
        this.alt_dd_DDS.setHasPushButton(false);
        this.alt_dd_DDS.setPushButtonChooser((IChooser)new FileChooser(0));
        this.alt_dd_DDS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EarModuleEditorComponent.this.handleTextModified(100);
            }
        });
        this.type_DDS = new DropDownSelector[5];
        int i = 0;
        while (i < this.type_DDS.length) {
            this.type_DDS[i] = new DropDownSelector(0);
            this.type_DDS[i].setSelectorDescription(DISPLAYTXT_EMPTY);
            this.type_DDS[i].setDescriptionPositionLeft(true);
            this.type_DDS[i].setReadOnly(false);
            this.type_DDS[i].setButtonText("...");
            this.type_DDS[i].setHasPushButton(false);
            this.type_DDS[i].setPushButtonChooser((IChooser)new FileChooser(0));
            this.type_DDS[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EarModuleEditorComponent.this.handleTextModified(-1);
                }
            });
            ++i;
        }
        this.type_DDS[0].setSelectorDescription(DISPLAYTXT_CONNECTOR_URI);
        this.type_DDS[1].setSelectorDescription(DISPLAYTXT_EJB_URI);
        this.type_DDS[2].setSelectorDescription(DISPLAYTXT_JAVA_URI);
        this.type_DDS[3].setSelectorDescription(DISPLAYTXT_WEB_URI);
        this.type_DDS[4].setSelectorDescription(DISPLAYTXT_CONTEXTROOT);
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + DISPLAYTXT_SPACE + e.getMessage());
    }

    private boolean isDCProject() {
        if (this.dcProject == null) {
            this.dcProject = new Boolean(false);
            try {
                boolean isDC = DCProjectInfo.isDCProject((IProject)this.getUnderlyingFile().getProject());
                this.dcProject = new Boolean(isDC);
            }
            catch (CoreException e) {
                tracer.error(((Object)((Object)this)).getClass(), "isDCProject()", "Problems with DCProjectInfo.isDCProject(..) occured.", (Throwable)e);
            }
        }
        return this.dcProject;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        if (this.getData() instanceof IModule) {
            IModule module = (IModule)this.getData();
            if (module == null) {
                return;
            }
            String alt_dd_value = this.alt_dd_DDS.getText();
            if (alt_dd_value != null && alt_dd_value.length() > 0) {
                IAltDd altdd = module.getAltDd();
                if (altdd == null) {
                    try {
                        altdd = module.createAltDd(null);
                        altdd.setValue(alt_dd_value);
                    }
                    catch (J2eeCreateException e) {
                        tracer.error("Unable to create AltDd", (Throwable)e);
                    }
                } else {
                    altdd.setValue(alt_dd_value);
                }
            } else {
                module.removeAltDd();
            }
            module.removeConnector();
            module.removeEjb();
            module.removeJava();
            module.removeWeb();
            switch (this.currentRadioSelection) {
                case 0: {
                    try {
                        module.createConnector(null).setValue(this.type_DDS[0].getText());
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("Unable to create Connector", e);
                    }
                    break;
                }
                case 1: {
                    try {
                        module.createEjb(null).setValue(this.type_DDS[1].getText());
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("Unable to create EJB", e);
                    }
                    break;
                }
                case 2: {
                    try {
                        module.createJava(null).setValue(this.type_DDS[2].getText());
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("Unable to create Java", e);
                    }
                    break;
                }
                case 3: {
                    try {
                        module.createWeb(null).createContextRoot(null).setValue(this.type_DDS[4].getText());
                        module.getWeb().createWebUri(null).setValue(this.type_DDS[3].getText());
                    }
                    catch (J2eeCreateException e) {
                        tracer.error("Unable to create Web", (Throwable)e);
                    }
                    break;
                }
            }
        }
    }

    private int getModuleType(IModule myModule) {
        int ret = -1;
        if (myModule != null) {
            if (myModule.getConnector() != null) {
                ret = 0;
            } else if (myModule.getEjb() != null) {
                ret = 1;
            } else if (myModule.getJava() != null) {
                ret = 2;
            } else if (myModule.getWeb() != null) {
                ret = 3;
            }
        }
        return ret;
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        int i = 0;
        while (i < 4) {
            this.radios[i].setSelection(false);
            ++i;
        }
        if (this.getData() instanceof IModule) {
            IModule module = (IModule)this.getData();
            if (module != null) {
                if (module.getAltDd() != null) {
                    this.alt_dd_DDS.setText(module.getAltDd().getValue());
                }
                this.currentRadioSelection = -1;
                int type = this.getModuleType(module);
                switch (type) {
                    case 0: {
                        this.radios[0].setSelection(true);
                        this.currentRadioSelection = 0;
                        this.type_DDS[0].setText(module.getConnector().getValue());
                        break;
                    }
                    case 1: {
                        this.radios[1].setSelection(true);
                        this.currentRadioSelection = 1;
                        this.type_DDS[1].setText(module.getEjb().getValue());
                        break;
                    }
                    case 2: {
                        this.radios[2].setSelection(true);
                        this.currentRadioSelection = 2;
                        this.type_DDS[2].setText(module.getJava().getValue());
                        break;
                    }
                    case 3: {
                        this.radios[3].setSelection(true);
                        this.currentRadioSelection = 3;
                        this.type_DDS[4].setText(module.getWeb().getContextRoot().getValue());
                        this.type_DDS[3].setText(module.getWeb().getWebUri().getValue());
                        break;
                    }
                    default: {
                        tracer.error(((Object)((Object)this)).getClass(), "refreshUIFromData()", " Error: Illegal Argument provided (type). ");
                    }
                }
            }
            this.updateSelection();
        }
        this.stopRefreshingUI();
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        if (this.radios != null) {
            int i = 0;
            while (i < this.radios.length) {
                this.radios[i].setEnabled(false);
                ++i;
            }
        }
        if (this.alt_dd_DDS != null) {
            this.alt_dd_DDS.setEditable(editable);
        }
        if (this.contextRootButton != null) {
            this.contextRootButton.setEnabled(editable);
        }
        this.updateSelection();
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        return status;
    }

    public IFile getUnderlyingFile() {
        return this.underlyingFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ContextRootSelectionListener
    implements SelectionListener {
        private ContextRootSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ICRDialogCaller dialogCaller = PortalFactory.getCRDialogCaller();
            if (dialogCaller != null) {
                String oldContextRoot = EarModuleEditorComponent.this.type_DDS[4].getText();
                IFile applicationXml = EarModuleEditorComponent.this.getUnderlyingFile();
                String newContextRoot = dialogCaller.getNewContextRoot(applicationXml, oldContextRoot);
                if (newContextRoot != null) {
                    EarModuleEditorComponent.this.type_DDS[4].setText(newContextRoot);
                }
            }
        }
    }
}

