/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ear.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.model.ear.dd.IDescription;
import com.tssap.j2ee.model.ear.dd.ISecurityRole;
import com.tssap.j2ee.ui.ParentHolder;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class UISecurityRoles
extends RefreshObjectEditorComponent {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ear$editor$internal$UISecurityRoles == null ? (class$com$tssap$j2ee$ui$ear$editor$internal$UISecurityRoles = UISecurityRoles.class$("com.tssap.j2ee.ui.ear.editor.internal.UISecurityRoles")) : class$com$tssap$j2ee$ui$ear$editor$internal$UISecurityRoles));
    private Text descriptionTextPane;
    private Text roleNameTextField;
    private IApplication application;
    private boolean modifyCallbackActive = true;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ear$editor$internal$UISecurityRoles;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Role name");
        this.roleNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new NameModifyAdapter());
        this.getRoleNameTextField().addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String secRoleName = this.roleNameTextField.getText();
        if (secRoleName.equals("") || secRoleName.equals("<fill in security-role-name>")) {
            status.setError("Please enter a security role name.");
        }
        return status;
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getSecurityRole() != null) {
            this.refreshSecurityRoleFromUI();
        }
    }

    private void refreshSecurityRoleFromUI() {
        String METHOD = "refreshSecurityRoleFromUI";
        try {
            this.modifyCallbackActive = false;
            if (this.getSecurityRole() != null) {
                this.modifyCallbackActive = false;
                String value = this.roleNameTextField.getText();
                if (value.equals("<fill in security-role-name>")) {
                    value = "";
                }
                if (this.getSecurityRole().getRoleName() != null) {
                    this.getSecurityRole().getRoleName().setValue(value);
                }
                this.setTitle(value);
                String descrValue = this.descriptionTextPane.getText();
                if (descrValue != null && descrValue.trim().length() != 0) {
                    IDescription descr = this.getSecurityRole().getDescription();
                    try {
                        if (descr == null) {
                            descr = this.getSecurityRole().createDescription(null);
                        }
                        descr.setValue(descrValue);
                    }
                    catch (J2eeCreateException e) {
                        TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                    }
                } else {
                    this.getSecurityRole().removeDescription();
                }
            }
            Object var7_6 = null;
            this.modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.modifyCallbackActive = true;
            throw throwable;
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this.modifyCallbackActive = false;
            if (this.getSecurityRole() != null) {
                if (this.getSecurityRole().getRoleName() != null) {
                    String name = this.getSecurityRole().getRoleName().getValue();
                    if (name.trim().length() == 0) {
                        name = "<fill in security-role-name>";
                    }
                    this.roleNameTextField.setText(name);
                    this.setTitle(name);
                }
                if (this.getSecurityRole().getDescription() != null) {
                    String description = this.getSecurityRole().getDescription().getValue();
                    this.descriptionTextPane.setText(description);
                } else {
                    this.descriptionTextPane.setText("");
                }
            }
            Object var4_3 = null;
            this.modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    private ISecurityRole getSecurityRole() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        ISecurityRole result = null;
        if (value instanceof ISecurityRole) {
            result = (ISecurityRole)value;
        }
        return result;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getRoleNameTextField() {
        return this.roleNameTextField;
    }

    private void setRoleNameTextField(Text roleNameTextField) {
        this.roleNameTextField = roleNameTextField;
    }

    protected void handleSecurityModifyEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        this.refreshSecurityRoleFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UISecurityRoles.this.handleSecurityModifyEvent();
        }
    }
}

