/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ear.editor.internal;

import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.ui.ear.editor.IEarEditor;
import com.tssap.j2ee.ui.ear.editor.internal.EarEditorPage;
import com.tssap.j2ee.ui.ear.editor.internal.SecurityRolesAddRemoveCallback;
import com.tssap.j2ee.ui.ear.editor.internal.SecurityRolesContentProvider;
import com.tssap.j2ee.ui.ear.editor.internal.SecurityRolesLabelProvider;
import com.tssap.j2ee.ui.ear.editor.internal.SecurityRolesReusableManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class EarSecurityPage
extends EarEditorPage
implements IModifiedCallback {
    private static final int NUM_OF_COLS = 2;
    private static final String PAGE_NAME = "Security";
    IApplication application;
    private TreeSelectorEditorComponent treeEditor;
    private boolean isModListenerActive = false;
    private SecurityRolesAddRemoveCallback callback;

    public EarSecurityPage(Composite parent, IEarEditor editor) {
        super(parent, editor, 1);
    }

    public Control createControls(IGridLayoutPane grid) {
        grid.addTextLabel("");
        TreeSelector treeSelector = new TreeSelector();
        treeSelector.setSplitterWeight(2);
        this.treeEditor = new TreeSelectorEditorComponent(treeSelector);
        this.callback = new SecurityRolesAddRemoveCallback();
        treeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.treeEditor.setTreeContentProvider((ITreeContentProvider)new SecurityRolesContentProvider());
        this.treeEditor.setTreeLabelProvider((ILabelProvider)new SecurityRolesLabelProvider());
        this.treeEditor.setAddRemoveCallback((IAddRemoveCallback)this.callback);
        SecurityRolesReusableManager reusableManager = new SecurityRolesReusableManager();
        this.treeEditor.setReusableManager((IReuseableManager)reusableManager);
        this.treeEditor.setModifiedCallback((IModifiedCallback)this);
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected void initControlsWithApplication(IApplication application) {
        this.callback.setApplication(application);
        try {
            this.isModListenerActive = false;
            this.treeEditor.setTreeInput((Object)application);
            Object var3_2 = null;
            this.isModListenerActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.isModListenerActive = true;
            throw throwable;
        }
    }

    protected void updateApplicationFromControls(IApplication application) {
        String METHOD = "updateDataFromControls()";
        this.treeEditor.aboutToLeave();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.treeEditor != null) {
            this.treeEditor.setEditable(editable);
        }
        if (this.getTreeSelector() != null) {
            this.getTreeSelector().setEditable(editable);
        }
    }

    public void dataModified(boolean modified) {
        if (this.isModListenerActive) {
            this.getEditor().setDirtyFlag(modified);
        }
        TreeItem[] selectedItems = this.getTreeSelector().getTreeViewer().getTree().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            TreeItem selectedItem = selectedItems[i];
            this.getTreeSelector().getTreeViewer().refresh(selectedItem.getData(), true);
            ++i;
        }
    }

    private TreeSelector getTreeSelector() {
        TreeSelector result = null;
        if (this.treeEditor != null) {
            result = this.treeEditor.getTreeSelector();
        }
        return result;
    }
}

