/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ear.editor.internal;

import com.tssap.j2ee.model.DCProjectFilter;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.model.ear.dd.IModule;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.ear.editor.IEarEditor;
import com.tssap.j2ee.ui.ear.editor.internal.EarEditorPage;
import com.tssap.j2ee.ui.ear.editor.internal.ModulesReuseableManager;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EarModulePage
extends EarEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ear$editor$internal$EarModulePage == null ? (class$com$tssap$j2ee$ui$ear$editor$internal$EarModulePage = EarModulePage.class$("com.tssap.j2ee.ui.ear.editor.internal.EarModulePage")) : class$com$tssap$j2ee$ui$ear$editor$internal$EarModulePage));
    private static final int UNKNOWN = -1;
    private static final int CONNECTOR_RADIO = 0;
    private static final int EJB_RADIO = 1;
    private static final int JAVA_RADIO = 2;
    private static final int WEB_RADIO = 3;
    private static final int NUM_OF_COLS = 1;
    private static final String PAGE_NAME = "Modules";
    private IApplication myApplication;
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private ModulesPageTreeCP myTreeContentProvider;
    private ILabelProvider myTreeLabelProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ear$editor$internal$EarModulePage;

    public EarModulePage(Composite parent, IEarEditor editor) {
        super(parent, editor, 1);
    }

    public Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector(false);
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(2);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeContentProvider = new ModulesPageTreeCP();
        this.myTreeLabelProvider = new ModuleLabelProvider();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider(this.myTreeLabelProvider);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
        this.myTreeEditor.setReusableManager((IReuseableManager)new ModulesReuseableManager(this.getUnderlyingFile(), this));
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected void initControlsWithApplication(IApplication application) {
        this.myApplication = application;
        this.myTreeSelector.setTreeInput((Object)this.myApplication);
    }

    protected void updateApplicationFromControls(IApplication application) {
        this.myTreeEditor.aboutToLeave();
    }

    private Object[] getModuleSources() {
        ArrayList<Object> moduleSources = new ArrayList<Object>();
        IEjbModule[] ejbAssPrj = J2eeProjectManager.getEjbModules((IJ2eeProjectFilter)new DCProjectFilter(this.isDCProject()));
        IWebModule[] webAssPrj = J2eeProjectManager.getWebModules((IJ2eeProjectFilter)new DCProjectFilter(this.isDCProject()));
        int i = 0;
        while (i < ejbAssPrj.length) {
            if (!this.isArchiveContainedInList(ejbAssPrj[i].getArchiveName())) {
                moduleSources.add(ejbAssPrj[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < webAssPrj.length) {
            if (!this.isArchiveContainedInList(webAssPrj[i2].getArchiveName())) {
                moduleSources.add(webAssPrj[i2]);
            }
            ++i2;
        }
        return moduleSources.toArray(new Object[moduleSources.size()]);
    }

    private boolean isArchiveContainedInList(String archiveName) {
        boolean ret = false;
        Object[] elements = this.myTreeContentProvider.getElements(null);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IModule) {
                ret = this.getModuleDisplayNameFromModule((IModule)elements[i], true).equals(archiveName);
            }
            ++i;
        }
        return ret;
    }

    private IProject getProjectFromSource(Object sourceObj) {
        return ((IJ2eeProject)sourceObj).getProject();
    }

    private void fillModuleFromSource(IModule module, Object object) {
        module.removeConnector();
        module.removeEjb();
        module.removeJava();
        module.removeWeb();
        if (object instanceof IEjbAssemblyProject) {
            String jarName = ((IEjbAssemblyProject)object).getArchiveName();
            try {
                module.createEjb(null).setValue(jarName);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("Unable to create EJB", e);
            }
        } else if (object instanceof IWebAssemblyProject) {
            String jarName = ((IWebAssemblyProject)object).getArchiveName();
            try {
                module.createWeb(null).createWebUri(null).setValue(jarName);
                module.getWeb().createContextRoot(null).setValue("");
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("Unable to create Web/WebUri", e);
            }
        } else {
            throw new IllegalArgumentException("Unknown Module Source: class=" + object.getClass() + "  source:" + object.toString());
        }
    }

    private String getModuleDisplayNameFromModule(IModule iModule, boolean withFileExtension) {
        int dotPos;
        String ret;
        int type = this.getModuleType(iModule);
        switch (type) {
            case 0: {
                ret = iModule.getConnector().getValue();
                break;
            }
            case 1: {
                ret = iModule.getEjb().getValue();
                break;
            }
            case 2: {
                ret = iModule.getJava().getValue();
                break;
            }
            case 3: {
                ret = iModule.getWeb().getWebUri().getValue();
                break;
            }
            default: {
                ret = "Unkown Module";
            }
        }
        if (!withFileExtension && (dotPos = ret.lastIndexOf(".")) > 0) {
            ret = ret.substring(0, dotPos);
        }
        return ret;
    }

    private int getModuleType(IModule myModule) {
        int ret = -1;
        if (myModule != null) {
            if (myModule.getConnector() != null) {
                ret = 0;
            } else if (myModule.getEjb() != null) {
                ret = 1;
            } else if (myModule.getJava() != null) {
                ret = 2;
            } else if (myModule.getWeb() != null) {
                ret = 3;
            }
        }
        return ret;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        this.myTreeSelector.setEditable(editable);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddRemoveCallback
    implements IAddRemoveCallback {
        private AddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            return null;
        }

        public boolean canAddElement(Object currentSelection) {
            return false;
        }

        public boolean canRemoveElement(Object currentSelection) {
            return false;
        }

        public boolean removeElement(Object currentSelection) {
            return false;
        }
    }

    private class ModulesPageTreeCP
    implements ITreeContentProvider {
        private final Object[] EMPTY_OBJ_AR = new Object[0];

        private ModulesPageTreeCP() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.EMPTY_OBJ_AR;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList modulesWithoutAltDD = new ArrayList();
            if (EarModulePage.this.myApplication != null && EarModulePage.this.myApplication.getModules() != null) {
                return EarModulePage.this.myApplication.getModules();
            }
            return this.EMPTY_OBJ_AR;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ModuleLabelProvider
    extends J2eeModelLabelProvider {
        private ModuleLabelProvider() {
        }

        public Image getImage(Object element) {
            Image retImage = super.getImage(element);
            if (element != null && element instanceof IModule) {
                if (((IModule)element).getConnector() != null) {
                    retImage = UIPlugin.getImage((String)"dummy");
                } else if (((IModule)element).getEjb() != null) {
                    retImage = UIPlugin.getImage((String)"ejbAssemblyProject");
                } else if (((IModule)element).getJava() != null) {
                    retImage = UIPlugin.getImage((String)"JavaFile");
                } else if (((IModule)element).getWeb() != null) {
                    retImage = UIPlugin.getImage((String)"webApplicationProject");
                }
            }
            return retImage;
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if (element instanceof IModule) {
                if (((IModule)element).getConnector() != null) {
                    text = ((IModule)element).getConnector().getValue();
                } else if (((IModule)element).getEjb() != null) {
                    text = ((IModule)element).getEjb().getValue();
                } else if (((IModule)element).getJava() != null) {
                    text = ((IModule)element).getJava().getValue();
                } else if (((IModule)element).getWeb() != null) {
                    text = ((IModule)element).getWeb().getWebUri().getValue();
                }
            }
            return text;
        }
    }
}

