/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime.cool.examples;

import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdField;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.IField;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.IUnitService;
import com.sap.dictionary.runtime.cool.DataProvider;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class Test02 {
    private static IBroker mBroker;
    private static final String COOL_DDIC = "COOL_DDIC";
    private static final String CLIENT = "000";
    private static final String USER = "cooluser";
    private static final String PASSWORD = "dwim";
    private static final String LANGUAGE = "DE";
    private static final String APPL_SERVER = "ld0020";
    private static final String SYSTEM_NUMBER = "21";
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$com$sap$dictionary$runtime$cool$examples$Test02;

    public static void main(String[] args) {
        mBroker = Test02.instantiateDictionary();
        if (mBroker == null) {
            System.out.println("*** Could not create broker");
            return;
        }
        Test02.getSampleStructures();
    }

    private static void getSampleDataElements() {
        String simpleTypeName = null;
        ITextServices textServices = null;
        ISimpleValueServices simpleValueServices = null;
        HashSet<String> dataElements = new HashSet<String>();
        dataElements.add("ALV_UNIT");
        dataElements.add("ALV_CUKY");
        dataElements.add("AU_ERROR");
        dataElements.add("TEXT80");
        dataElements.add("TABKAT");
        dataElements.add("XFELD");
        dataElements.add("UBTEST_DTEL16");
        dataElements.add("UBTEST_DTEL11");
        Iterator iter = dataElements.iterator();
        while (iter.hasNext()) {
            ISimpleType simpleType;
            try {
                simpleTypeName = (String)iter.next();
                simpleType = (ISimpleType)mBroker.getDataType(COOL_DDIC, simpleTypeName);
            }
            catch (DdException e) {
                System.out.println("Could not get data element " + simpleTypeName);
                continue;
            }
            System.out.println("*** SimpleType:" + simpleType.getName());
            System.out.println("  getAttributeClass() = " + simpleType.getAttributeClass());
            System.out.println("  getBuiltInType() = " + simpleType.getBuiltInType());
            System.out.println("  getFormat() = " + simpleType.getFormat());
            System.out.println("  getLength() = " + simpleType.getLength());
            System.out.println("  getMaxLength() = " + simpleType.getMaxLength());
            System.out.println("  getMaxExternalLength() = " + simpleType.getMaxExternalLength());
            System.out.println("  getTotalDigits() = " + simpleType.getTotalDigits());
            System.out.println("  getFractionDigits() = " + simpleType.getFractionDigits());
            System.out.println("ITextServices:");
            textServices = simpleType.getTextServices();
            if (textServices != null) {
                try {
                    System.out.println("  getFieldLabel() = " + textServices.getFieldLabel());
                    System.out.println("  getColumnLabel() = " + textServices.getColumnLabel());
                    System.out.println("  getQuickInfo() = " + textServices.getQuickInfo());
                    System.out.println("  getDescription() = " + textServices.getDescription());
                    System.out.println("  getLocale() = " + textServices.getLocale());
                }
                catch (Exception e) {
                    System.out.println("!!! Exception in text services: ");
                    e.printStackTrace();
                }
            }
            System.out.println("ISimpleValueServices:");
            simpleValueServices = simpleType.getSVServices();
            if (simpleValueServices != null) {
                try {
                    System.out.println("  getValues() = " + simpleValueServices.getValues());
                    System.out.println("  validate(\"AA\") = " + simpleValueServices.validate("AA"));
                    System.out.println("  validate(\"3\") " + simpleValueServices.validate("3"));
                }
                catch (Exception e) {
                    System.out.println("!!! Exception in simple value services: ");
                    e.printStackTrace();
                }
            } else {
                System.out.println(" No SimpleValueServices");
            }
            System.out.println("");
        }
        try {
            IDataType abapType = mBroker.getDataType(COOL_DDIC, "STRING");
            System.out.println("ABAP type: " + abapType.getName());
            System.out.println(abapType.toString());
        }
        catch (DdException e) {
            System.out.println("*** EXCEPTION: Could not get abapType");
            e.printStackTrace();
        }
    }

    private static void getSampleStructures() {
        String structureName = null;
        HashSet<String> structures = new HashSet<String>();
        structures.add("UBTEST_STRUC16");
        Iterator iter = structures.iterator();
        while (iter.hasNext()) {
            IStructure structure;
            try {
                structureName = (String)iter.next();
                structure = (IStructure)mBroker.getDataType(COOL_DDIC, structureName);
            }
            catch (DdException e) {
                System.out.println("Could not get structure " + structureName);
                continue;
            }
            String name = structure.getName();
            System.out.println("Structure:");
            System.out.println("**** Structure:" + structure.getName());
            System.out.println("  Structure: toString() = " + structure.toString());
            System.out.println("  getNumberOfFields() = " + structure.getNumberOfFields());
            System.out.println("****************************************");
            System.out.println("Fields:");
            int j = 1;
            Iterator i = structure.fieldIterator();
            while (i.hasNext()) {
                DdField ddField = (DdField)i.next();
                System.out.println("  Field(" + j + "): toString() = " + ddField);
                System.out.println("    getName() = " + ddField.getName());
                System.out.println("    getNameOfType() = " + ddField.getNameOfType());
                System.out.println("    getEmbeddedType() = " + ddField.getEmbeddedType());
                System.out.println("    belongsToAppend: = " + ddField.belongsToAppend());
                String typeName = ddField.getBackendNameOfType();
                if (typeName != null && !typeName.trim().equals("")) {
                    try {
                        IDataType dataType = mBroker.getDataType(COOL_DDIC, typeName);
                        System.out.println("    DataType of field = " + dataType);
                    }
                    catch (DdException e1) {
                        System.out.println("Could not get data Type " + typeName);
                        e1.printStackTrace();
                    }
                }
                try {
                    IUnitService unitService = mBroker.getUnitService((IField)ddField);
                    System.out.println("Unit Service: " + unitService.toString());
                    System.out.println("Unit Service Kind: " + ddField.getUnitServiceKind().toString());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                System.out.println("");
                ++j;
            }
        }
    }

    private static IBroker instantiateDictionary() {
        IBroker broker = null;
        ClassLoader classloader = (class$com$sap$dictionary$runtime$cool$examples$Test02 == null ? (class$com$sap$dictionary$runtime$cool$examples$Test02 = Test02.class$("com.sap.dictionary.runtime.cool.examples.Test02")) : class$com$sap$dictionary$runtime$cool$examples$Test02).getClassLoader();
        Locale locale = Locale.GERMAN;
        IDataProvider dataProvider = Test02.getCoolProvider(locale);
        if (dataProvider == null) {
            return null;
        }
        try {
            DdDictionaryPool pool = DdDictionaryPool.getInstance();
            broker = pool.createBroker(classloader, locale);
            broker.putDictionary(COOL_DDIC, dataProvider);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return broker;
    }

    private static IDataProvider getCoolProvider(Locale locale) {
        DataProvider dataProvider = null;
        try {
            dataProvider = new DataProvider(CLIENT, USER, PASSWORD, LANGUAGE, APPL_SERVER, SYSTEM_NUMBER, false, locale);
        }
        catch (DdException e) {
            System.out.println("DdException: " + e.getMessage());
            return null;
        }
        return dataProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

