/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime.cool.examples;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdField;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.cool.DataProvider;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class Test {
    private static DataProvider mDataProvider;
    private static Locale mLocale;
    private static final String CLIENT = "000";
    private static final String USER = "cooluser";
    private static final String PASSWORD = "dwim";
    private static final String LANGUAGE = "DE";
    private static final String APPL_SERVER = "ld0020";
    private static final String SYSTEM_NUMBER = "21";
    private static final boolean DEBUG = false;

    public static void main(String[] args) {
        mLocale = Locale.GERMAN;
        try {
            mDataProvider = new DataProvider(CLIENT, USER, PASSWORD, LANGUAGE, APPL_SERVER, SYSTEM_NUMBER, false, mLocale);
        }
        catch (DdException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("DataProvider created");
        Test.getSampleDataElements();
    }

    private static void getSampleDataElements() {
        ISimpleType currency;
        String simpleTypeName = null;
        ITextServices textServices = null;
        ISimpleValueServices simpleValueServices = null;
        HashSet<String> dataElements = new HashSet<String>();
        dataElements.add("ALV_UNIT");
        dataElements.add("ALV_CUKY");
        dataElements.add("AU_ERROR");
        dataElements.add("TEXT80");
        dataElements.add("TABKAT");
        dataElements.add("XFELD");
        Iterator iter = dataElements.iterator();
        while (iter.hasNext()) {
            ISimpleType simpleType;
            try {
                simpleTypeName = (String)iter.next();
                simpleType = (ISimpleType)mDataProvider.getDataType(simpleTypeName, mLocale);
            }
            catch (DdException e) {
                System.out.println("Could not get data element " + simpleTypeName);
                continue;
            }
            System.out.println("*** SimpleType:" + simpleType.getName());
            System.out.println("  getAttributeClass() = " + simpleType.getAttributeClass());
            System.out.println("  getBuiltInType() = " + simpleType.getBuiltInType());
            System.out.println("  getLength() = " + simpleType.getLength());
            System.out.println("  getMaxLength() = " + simpleType.getMaxLength());
            System.out.println("  getTotalDigits() = " + simpleType.getTotalDigits());
            System.out.println("  getFractionDigits() = " + simpleType.getFractionDigits());
            System.out.println("ITextServices:");
            try {
                textServices = mDataProvider.getTextService(simpleType);
            }
            catch (DdException e1) {
                e1.printStackTrace();
            }
            if (textServices != null) {
                try {
                    System.out.println("  getFieldLabel() = " + textServices.getFieldLabel());
                    System.out.println("  getColumnLabel() = " + textServices.getColumnLabel());
                    System.out.println("  getQuickInfo() = " + textServices.getQuickInfo());
                    System.out.println("  getDescription() = " + textServices.getDescription());
                    System.out.println("  getLocale() = " + textServices.getLocale());
                }
                catch (Exception e) {
                    System.out.println("!!! Exception in text services: ");
                    e.printStackTrace();
                }
            }
            System.out.println("ISimpleValueServices:");
            try {
                simpleValueServices = mDataProvider.getValueService(simpleType);
            }
            catch (DdException e2) {
                e2.printStackTrace();
            }
            if (simpleValueServices != null) {
                try {
                    System.out.println("  getValues() = " + simpleValueServices.getValues());
                    System.out.println("  validate(\"AA\") = " + simpleValueServices.validate("AA"));
                    System.out.println("  validate(\"3\") " + simpleValueServices.validate("3"));
                }
                catch (Exception e) {
                    System.out.println("!!! Exception in simple value services: ");
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println(" No SimpleValueServices");
        }
        try {
            IDataType abapType = mDataProvider.getDataType("STRING", mLocale);
            System.out.println("ABAP type: " + abapType.getName());
            System.out.println(abapType.toString());
        }
        catch (DdException e) {
            System.out.println("*** EXCEPTION: Could not get abapType");
            e.printStackTrace();
        }
        try {
            currency = mDataProvider.getCurrencyUnitType("EUR", mLocale);
            System.out.println("Currency: " + currency.getName());
            System.out.println(currency.toString());
        }
        catch (DdException e) {
            System.out.println("*** EXCEPTION: Could not get currency");
            e.printStackTrace();
        }
        try {
            currency = mDataProvider.getCurrencyUnitType("DEM3", mLocale);
            System.out.println("Currency: " + currency.getName());
            System.out.println(currency.toString());
        }
        catch (DdException e) {
            System.out.println("*** EXCEPTION: Could not get currency");
            e.printStackTrace();
        }
        try {
            currency = mDataProvider.getCurrencyUnitType("HUGO", mLocale);
            System.out.println("Currency: " + currency.getName());
            System.out.println(currency.toString());
        }
        catch (DdException e) {
            System.out.println("*** EXCEPTION: Could not get currency");
            e.printStackTrace();
        }
        try {
            ISimpleType unit = mDataProvider.getUnitOfMeasureType("KG", mLocale);
            System.out.println("Unit: " + unit.getName());
            System.out.println(unit.toString());
        }
        catch (DdException e) {
            System.out.println("*** EXCEPTION: Could not get unit");
            e.printStackTrace();
        }
    }

    private static void getSampleStructures() {
        String structureName = null;
        HashSet<String> structures = new HashSet<String>();
        structures.add("UBTEST_STRUC11");
        structures.add("UBTEST_STRUC12");
        Iterator iter = structures.iterator();
        while (iter.hasNext()) {
            IStructure structure;
            try {
                structureName = (String)iter.next();
                structure = (IStructure)mDataProvider.getDataType(structureName, mLocale);
            }
            catch (DdException e) {
                System.out.println("Could not get structure " + structureName);
                continue;
            }
            String name = structure.getName();
            System.out.println("Structure:");
            System.out.println("**** Structure:" + structure.getName());
            System.out.println("  Structure: toString() = " + structure.toString());
            System.out.println("  getNumberOfFields() = " + structure.getNumberOfFields());
            System.out.println("****************************************");
            System.out.println("Fields:");
            int j = 1;
            Iterator i = structure.fieldIterator();
            while (i.hasNext()) {
                DdField field = (DdField)i.next();
                System.out.println("");
                System.out.println("  Field(" + j + "): toString() = " + field);
                System.out.println("    getName() = " + field.getName());
                System.out.println("    getNameOfType() = " + field.getNameOfType());
                System.out.println("    getEmbeddedType() = " + field.getEmbeddedType());
                System.out.println("    belongsToAppend: = " + field.belongsToAppend());
                if (field.hasEmbeddedType()) {
                    IDataType embeddedType = field.getEmbeddedType();
                    System.out.println("    embeddded type = " + embeddedType);
                    if (embeddedType.isSimpleType()) {
                        try {
                            System.out.println("     TextServices = " + ((ISimpleType)embeddedType).getTextServices());
                        }
                        catch (Exception e2) {
                            System.out.println("no TextServices");
                        }
                        try {
                            System.out.println("     ValueServices = " + ((ISimpleType)embeddedType).getSVServices());
                        }
                        catch (Exception e1) {
                            System.out.println("no SVServices");
                        }
                    }
                }
                ++j;
            }
        }
    }
}

