/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime.cool;

import com.sap.dictionary.types.mdi.conversions.TypeConversionService;
import com.sap.typeservices.IModifiableSimpleValueSet;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ISimpleValueSet;
import com.sap.typeservices.ModifiableSimpleValueSet;
import com.sap.typeservices.SimpleValueSet;
import java.util.Locale;

public class SimpleValueServices
implements ISimpleValueServices {
    private String[][] mFixedValues;
    private String mJavaBuiltInType;
    private Locale mLocale;
    private SimpleValueSet mSimpleValueSet;
    private ModifiableSimpleValueSet mModifiableSimpleValueSet;

    public SimpleValueServices(String[][] fixedValues, String javaBuiltInType, Locale locale) {
        this.mFixedValues = fixedValues;
        this.mJavaBuiltInType = javaBuiltInType;
        this.mLocale = locale;
        this.createSimpleValueSets();
    }

    public ISimpleValueSet getValues(Locale locale) {
        if (locale.equals(this.mLocale)) {
            return this.getValues();
        }
        return null;
    }

    public ISimpleValueSet getValues() {
        if (this.mSimpleValueSet == null || this.mSimpleValueSet.isEmpty()) {
            return null;
        }
        return this.mSimpleValueSet;
    }

    public boolean validate(String value) {
        if (this.mSimpleValueSet != null) {
            return this.mSimpleValueSet.containsKey(value);
        }
        return true;
    }

    public boolean validate(Object value) {
        String stringValue = value.toString();
        if (this.mSimpleValueSet != null) {
            return this.mSimpleValueSet.containsKey(stringValue);
        }
        return true;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public IModifiableSimpleValueSet getModifiableSimpleValueSet() {
        return this.mModifiableSimpleValueSet;
    }

    private void createSimpleValueSets() {
        Object javaBuiltInType = null;
        this.mSimpleValueSet = null;
        this.mModifiableSimpleValueSet = null;
        if (this.mFixedValues == null || this.mFixedValues.length == 0) {
            return;
        }
        if (!TypeConversionService.hasEnumerationValues((String)this.mJavaBuiltInType)) {
            return;
        }
        this.mSimpleValueSet = new SimpleValueSet(this.mLocale);
        this.mModifiableSimpleValueSet = new ModifiableSimpleValueSet(this.mLocale);
        int i = 0;
        while (i < this.mFixedValues.length) {
            this.mSimpleValueSet.put((Object)this.mFixedValues[i][0], (Object)this.mFixedValues[i][1]);
            this.mModifiableSimpleValueSet.put((Object)this.mFixedValues[i][0], this.mFixedValues[i][1]);
            ++i;
        }
        if (this.mSimpleValueSet.isEmpty()) {
            this.mSimpleValueSet = null;
        }
        if (this.mModifiableSimpleValueSet.isEmpty()) {
            this.mModifiableSimpleValueSet = null;
        }
    }
}

