/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime.cool;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdJavaProvider;
import com.sap.dictionary.runtime.DdList;
import com.sap.dictionary.runtime.DdNameTranslator;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.DdStructure;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.runtime.cool.SimpleValueServices;
import com.sap.dictionary.runtime.cool.TextServices;
import com.sap.dictionary.runtime.cool.util.CoolUtil;
import com.sap.dictionary.types.mdi.conversions.TypeConversionService;
import com.sap.dictionary.types.mdi.util.DataTypeMapping;
import com.sap.dictionary.types.mdi.util.MessagePool;
import com.sap.dictionary.types.mdi.util.ProviderUtil;
import com.sap.dictionary.types.services.IBackendConversionRule;
import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataAppServer;
import com.sap.tc.col.cds.ConnectionDataServiceFactory;
import com.sap.tc.col.cds.IConnectionDataService;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.ServiceFacadeFactory;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class DataProvider
implements IDataProvider {
    private IServiceFacade mServiceFacade;
    private IServiceModule mDictionaryServiceModule;
    private IServiceModule mUnitsServiceModule;
    private IQuery mDictionaryQuery;
    private IQuery mUnitsQuery;
    private com.sap.tc.col.client.generic.api.IStructure mDictionaryQueryParameter;
    private com.sap.tc.col.client.generic.api.IStructure mUnitsQueryParameter;
    private Map mDataTypes;
    private Map mCurrencyTypes;
    private Map mUnitTypes;
    private Map mDataElements;
    private Map mCoolDataTypes;
    boolean mDebug;

    public DataProvider(IServiceFacade serviceFacade, boolean debug) throws DdException {
        if (serviceFacade == null) {
            throw new DdException("Constructor DataProvider: ServiceFactory is null");
        }
        this.mServiceFacade = serviceFacade;
        this.mDictionaryServiceModule = this.mServiceFacade.getServiceModule("DICTIONARY");
        if (this.mDictionaryServiceModule == null) {
            throw new DdException(MessagePool.getMessage((String)"Service module & does not exist", (String)"DICTIONARY"));
        }
        this.mDictionaryQuery = this.mDictionaryServiceModule.createQuery("DD_DATATYPES");
        if (this.mDictionaryQuery == null) {
            throw new DdException(MessagePool.getMessage((String)"Query & does not exist", (String)"DD_DATATYPES"));
        }
        this.mDictionaryQueryParameter = this.mDictionaryQuery.getInputParameterStructure();
        if (this.mDictionaryQueryParameter == null) {
            throw new DdException("Constructor DataProvider: query parameter structure is null");
        }
        this.mDictionaryServiceModule.setDebug(debug, null);
        this.mDebug = debug;
        this.mDataTypes = Collections.synchronizedMap(new WeakHashMap());
        this.mCurrencyTypes = Collections.synchronizedMap(new WeakHashMap());
        this.mUnitTypes = Collections.synchronizedMap(new WeakHashMap());
        this.mDataElements = Collections.synchronizedMap(new WeakHashMap());
        this.mCoolDataTypes = Collections.synchronizedMap(new WeakHashMap());
    }

    public DataProvider(String client, String user, String password, String language, String applicationServer, String systemNumber, boolean debug, Locale locale) throws DdException {
        this(DataProvider.createServiceFacade(client, user, password, language, applicationServer, systemNumber, locale), debug);
    }

    public IDataType getDataType(String name, Locale locale) throws DdException {
        return this.getDataType(name, locale, null);
    }

    public IDataType getDataType(String name, Locale locale, Object providerInfo) throws DdException {
        IDataType dataType = null;
        if (name == null || locale == null || providerInfo != null && !(providerInfo instanceof DdNameTranslator)) {
            throw new DdException(MessagePool.getMessage((String)"Invalid call of method &", (String)"getDataType(String, Locale, Object)"));
        }
        dataType = this.getDataTypeFromCache(name, locale);
        if (dataType != null) {
            return dataType;
        }
        DdNameTranslator ddNameTranslator = null;
        ddNameTranslator = providerInfo != null ? (DdNameTranslator)providerInfo : DdNameTranslator.getDummyInstance();
        String r3Name = ddNameTranslator.typeNameToBackendInternal(name);
        IAspectRow coolDataType = this.getCoolDataType(r3Name);
        String typeKind = null;
        if (coolDataType != null) {
            typeKind = coolDataType.getAttributeAsString("TYPEKIND");
        }
        if (coolDataType == null) {
            return this.createSimpleTypeFromAbapType(r3Name, locale, ddNameTranslator, name);
        }
        if (typeKind.equalsIgnoreCase("DTEL")) {
            return this.createSimpleType(coolDataType, r3Name, locale, ddNameTranslator, name);
        }
        if (typeKind.equalsIgnoreCase("TABL")) {
            return this.createStructure(coolDataType, r3Name, locale, ddNameTranslator, name);
        }
        if (typeKind.equalsIgnoreCase("TTYP")) {
            return new DdList(name);
        }
        throw new DdException(MessagePool.getMessage((String)"Type & is not supported", (String)name));
    }

    public ISimpleValueServices getValueService(ISimpleType simpleType) throws DdException {
        return null;
    }

    public ITextServices getTextService(ISimpleType simpleType) throws DdException {
        return null;
    }

    public ISimpleType getCurrencyUnitType(String unitKey, Locale locale) throws DdException {
        IDataType dataType;
        if (this.mUnitsServiceModule == null) {
            this.createUnitsService();
        }
        if ((dataType = ProviderUtil.getFromCache((Map)this.getCache('C'), (String)unitKey, (Locale)locale)) != null) {
            return (ISimpleType)dataType;
        }
        IAspectRow unit = this.getCoolUnit(unitKey, "C");
        if (unit != null) {
            return this.createUnitType(unit, locale, unitKey);
        }
        try {
            return DdJavaProvider.THIS_PROJECT_JAVA_PROVIDER.getCurrencyUnitType("DEFAULT", locale);
        }
        catch (DdException e) {
            throw new DdException(MessagePool.getMessage((String)"Currency & does not exist", (String)unitKey));
        }
    }

    public ISimpleType getUnitOfMeasureType(String unitKey, Locale locale) throws DdException {
        IDataType dataType;
        if (this.mUnitsServiceModule == null) {
            this.createUnitsService();
        }
        if ((dataType = ProviderUtil.getFromCache((Map)this.getCache('U'), (String)unitKey, (Locale)locale)) != null) {
            return (ISimpleType)dataType;
        }
        IAspectRow unit = this.getCoolUnit(unitKey, "M");
        if (unit != null) {
            return this.createUnitType(unit, locale, unitKey);
        }
        throw new DdException(MessagePool.getMessage((String)"Unit of measurement & does not exist", (String)unitKey));
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public boolean needsTranslator() {
        return false;
    }

    private Map getCache(char cacheType) {
        switch (cacheType) {
            case 'D': {
                return this.mDataTypes;
            }
            case 'C': {
                return this.mCurrencyTypes;
            }
            case 'U': {
                return this.mUnitTypes;
            }
        }
        return null;
    }

    private String getTypeKind(IAspect dataType) {
        return this.getTypeKind(dataType, 0);
    }

    private String getTypeKind(IAspect dataType, int index) {
        return dataType.getAspectRow(index).getAttributeAsString("TYPEKIND");
    }

    private IAspect getCoolDataTypeQuery(String typeName) {
        this.mDictionaryQueryParameter.setAttributeValue("TYPENAME", (Object)typeName);
        this.mDictionaryQuery.execute();
        IAspect dataType = this.mDictionaryQuery.getResultAspect();
        this.mServiceFacade.flush();
        if (dataType == null || dataType != null && dataType.isEmpty() || dataType.size() == 0) {
            return null;
        }
        return dataType;
    }

    private IAspectRow getCoolDataType(String typeName) {
        if (this.mCoolDataTypes.containsKey(typeName)) {
            IAspectRow coolDataType = (IAspectRow)this.mCoolDataTypes.get(typeName);
            this.mCoolDataTypes.remove(typeName);
            return coolDataType;
        }
        IKeyList keyList = this.mDictionaryServiceModule.createKeyList("DD_DATATYPE_KEY");
        String[] keyElements = new String[]{typeName};
        IKey key = this.mDictionaryServiceModule.createKey("DD_DATATYPE_KEY", keyElements);
        keyList.add(key);
        IAspect dataType = this.mDictionaryServiceModule.getAspect("DD_DATATYPE", keyList);
        this.mServiceFacade.flush();
        if (dataType == null || dataType != null && dataType.isEmpty() || dataType.size() == 0) {
            return null;
        }
        return dataType.getAspectRow(0);
    }

    private IAspectRow getCoolUnit(String unitName, String unitType) {
        this.mUnitsQueryParameter.setAttributeValue("UNITNAME", (Object)unitName);
        this.mUnitsQueryParameter.setAttributeValue("UNITTYPE", (Object)unitType);
        this.mUnitsQuery.execute();
        IAspect unit = this.mUnitsQuery.getResultAspect();
        this.mServiceFacade.flush();
        if (unit == null || unit != null && unit.isEmpty() || unit.size() == 0) {
            return null;
        }
        return unit.getAspectRow(0);
    }

    private ISimpleType createSimpleType(IAspectRow dataType, String typeName, Locale locale, DdNameTranslator ddNameTranslator, String cacheName) throws DdException {
        XmlMap xmlMap = this.createSimpleTypeXmlMap(dataType, typeName, locale, ddNameTranslator);
        ISimpleType simpleType = DdSimpleType.makeNew((IDataProvider)this, (Locale)locale, (XmlMap)xmlMap);
        ProviderUtil.putIntoCache((Map)this.getCache('D'), (String)cacheName, (IDataType)simpleType, (Locale)locale);
        return simpleType;
    }

    private ISimpleType createSimpleTypeFromAbapType(String abapTypeName, Locale locale, DdNameTranslator ddNameTranslator, String cacheName) throws DdException {
        XmlMap simpleTypeXmlMap = ProviderUtil.createAbapTypeXmlMap((String)abapTypeName, (Locale)locale, (DdNameTranslator)ddNameTranslator, (String)cacheName);
        ISimpleType simpleType = DdSimpleType.makeNew((IDataProvider)this, (Locale)locale, (XmlMap)simpleTypeXmlMap);
        ProviderUtil.putIntoCache((Map)this.getCache('D'), (String)cacheName, (IDataType)simpleType, (Locale)locale);
        return simpleType;
    }

    private IStructure createStructure(IAspectRow dataType, String typeName, Locale locale, DdNameTranslator ddNameTranslator, String cacheName) throws DdException {
        XmlMap xmlMap = this.createStructureXmlMap(dataType, typeName, ddNameTranslator);
        DdStructure structure = new DdStructure((IDataProvider)this, locale, xmlMap);
        ProviderUtil.putIntoCache((Map)this.getCache('D'), (String)cacheName, (IDataType)structure, (Locale)locale);
        return structure;
    }

    private XmlMap createSimpleTypeXmlMap(IAspectRow dataType, String r3Name, Locale locale, DdNameTranslator ddNameTranslator) throws DdException {
        String conversionExit;
        String refKind;
        XmlMap schemaType = null;
        XmlMap externalRepresentation = null;
        XmlMap enumerationValues = null;
        TextServices textServices = null;
        SimpleValueServices simpleValueServices = null;
        String r3BuiltInType = null;
        String javaBuiltInType = null;
        String format = null;
        String[][] fixedValues = null;
        IAspectRow dataElement = null;
        Boolean uppercase = null;
        String typeName = dataType.getAttributeAsString("TYPENAME");
        dataElement = (IAspectRow)this.mDataElements.get(typeName);
        if (dataElement != null) {
            this.mDataElements.remove(typeName);
        } else {
            dataElement = this.getRelatedAspectRow(dataType, r3Name, "DD_DATATYPE_DATAELEMENT");
        }
        String javaName = ddNameTranslator.typeNameToFrontend(r3Name);
        if (javaName == null) {
            javaName = "";
        }
        if ((refKind = dataElement.getAttributeAsString("REFKIND")) == null) {
            refKind = "";
        }
        if (!ProviderUtil.stringIsEmpty((String)refKind) && !refKind.equalsIgnoreCase("D")) {
            throw new DdException(MessagePool.getMessage((String)"Type & is not supported", (String)javaName));
        }
        r3BuiltInType = dataElement.getAttributeAsString("DATATYPE");
        if (!ProviderUtil.stringIsEmpty((String)dataElement.getAttributeAsString("DOMNAME"))) {
            fixedValues = CoolUtil.getFixedValues(dataElement, this.mServiceFacade);
        }
        int r3Length = this.getIntegerAttribute(dataElement, "LENG");
        int r3OutLength = this.getIntegerAttribute(dataElement, "OUTPUTLEN");
        int r3Decimals = this.getIntegerAttribute(dataElement, "DECIMALS");
        javaBuiltInType = fixedValues == null ? DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType) : TypeConversionService.convertDataElementWithDomainToJavaCool((String)r3Name, (String)r3BuiltInType, (int)r3Length, (int)r3Decimals, (String[][])fixedValues);
        if (javaBuiltInType == null) {
            javaBuiltInType = "";
        }
        if ((conversionExit = dataElement.getAttributeAsString("CONVEXIT")) != null && conversionExit.equalsIgnoreCase("ALPHA")) {
            format = "ALPHA";
        }
        if (TypeConversionService.hasSchemaType((String)javaBuiltInType)) {
            schemaType = ProviderUtil.createSchemaTypeXmlMap((String)r3BuiltInType, (int)r3Length, (int)r3Decimals);
        }
        uppercase = null;
        if (javaBuiltInType.equals("string")) {
            uppercase = ProviderUtil.stringIsEmpty((String)dataElement.getAttributeAsString("LOWERCASE")) ? new Boolean(true) : new Boolean(false);
        }
        if (TypeConversionService.hasExternalRepresentation((String)javaBuiltInType)) {
            externalRepresentation = ProviderUtil.createExternalRepresentationXmlMap((int)r3OutLength, (String)format, uppercase);
        }
        IBackendConversionRule conversionRule = TypeConversionService.getConversionRuleCool((String)r3Name);
        if (TypeConversionService.hasEnumerationValues((String)javaBuiltInType) && fixedValues != null) {
            enumerationValues = ProviderUtil.createEnumerationValuesXmlMap((String[][])fixedValues);
        }
        try {
            textServices = new TextServices(dataElement, locale);
        }
        catch (DdException e) {
            // empty catch block
        }
        simpleValueServices = new SimpleValueServices(fixedValues, javaBuiltInType, locale);
        return ProviderUtil.createSimpleTypeXmlMap((String)r3Name, (String)r3BuiltInType, (String)javaBuiltInType, (IBackendConversionRule)conversionRule, (XmlMap)schemaType, (XmlMap)externalRepresentation, (XmlMap)enumerationValues, (ITextServices)textServices, (ISimpleValueServices)simpleValueServices, (Locale)locale, (DdNameTranslator)ddNameTranslator);
    }

    private XmlMap createStructureXmlMap(IAspectRow dataType, String r3Name, DdNameTranslator ddNameTranslator) throws DdException {
        XmlMap columns = this.createColumnsXmlMap(dataType, r3Name, ddNameTranslator);
        return ProviderUtil.createStructureXmlMap((String)r3Name, (XmlMap)columns, (DdNameTranslator)ddNameTranslator);
    }

    private XmlMap createColumnsXmlMap(IAspectRow dataType, String r3Name, DdNameTranslator ddNameTranslator) throws DdException {
        XmlMap columns = new XmlMap();
        XmlMap column = null;
        IAspectRow structure = this.getRelatedAspectRow(dataType, r3Name, "DD_DATATYPE_STRUCTURE");
        IAspect fields = structure.getRelatedAspect("DD_STRUCTURE_FIELD");
        this.mServiceFacade.flush();
        if (fields == null) {
            throw new DdException(MessagePool.getMessage((String)"Relation & does not exist for aspect &", (String)"DD_STRUCTURE_FIELD", (String)structure.toString()));
        }
        this.cacheDataElements(fields);
        this.mServiceFacade.flush();
        int i = 0;
        while (i < fields.size()) {
            IAspectRow field = fields.getAspectRow(i);
            if (field == null) {
                throw new DdException(MessagePool.getMessage((String)"Field & of structure & does not exist", (String)Integer.toString(i + 1)));
            }
            column = this.createColumnXmlMap(field, ddNameTranslator);
            columns.put("column" + (i == 0 ? "" : "" + i), column);
            ++i;
        }
        if (columns.isEmpty()) {
            return null;
        }
        return columns;
    }

    private XmlMap createColumnXmlMap(IAspectRow field, DdNameTranslator ddNameTranslator) {
        String dataType;
        String r3TypeName;
        XmlMap embeddedType = null;
        String fieldName = field.getAttributeAsString("FIELDNAME");
        if (fieldName == null) {
            fieldName = "";
        }
        String position = field.getAttributeAsString("POSITION");
        String compType = field.getAttributeAsString("COMPTYPE");
        if (compType == null) {
            compType = "";
        }
        if ((r3TypeName = field.getAttributeAsString("ROLLNAME")) == null) {
            r3TypeName = "";
        }
        if (ProviderUtil.stringIsEmpty((String)compType) && ProviderUtil.stringIsEmpty((String)r3TypeName)) {
            r3TypeName = "Embedded";
        }
        boolean belongsToAppend = !ProviderUtil.stringIsEmpty((String)field.getAttributeAsString("BELONGSTOAPPEND"));
        boolean isScalar = ProviderUtil.stringIsEmpty((String)compType) || compType.equalsIgnoreCase("E") && ProviderUtil.stringIsEmpty((String)field.getAttributeAsString("REFTYPE"));
        Boolean hasCurrencyKey = null;
        if (isScalar && !ProviderUtil.stringIsEmpty((String)(dataType = field.getAttributeAsString("DATATYPE")))) {
            if (dataType.equalsIgnoreCase("CUKY")) {
                hasCurrencyKey = Boolean.TRUE;
            } else if (dataType.equalsIgnoreCase("UNIT")) {
                hasCurrencyKey = Boolean.FALSE;
            }
        }
        String referenceField = field.getAttributeAsString("REFFIELD");
        String referenceTable = field.getAttributeAsString("REFTABLE");
        if (ProviderUtil.stringIsEmpty((String)compType)) {
            embeddedType = ProviderUtil.createBuiltInTypeXmlMap((String)field.getAttributeAsString("DATATYPE"), (int)this.getIntegerAttribute(field, "LENG"), (int)this.getIntegerAttribute(field, "DECIMALS"));
        }
        return ProviderUtil.createColumnXmlMap((String)fieldName, (String)position, (String)r3TypeName, (boolean)isScalar, (boolean)belongsToAppend, (Boolean)hasCurrencyKey, (String)referenceTable, (String)referenceField, embeddedType, (DdNameTranslator)ddNameTranslator);
    }

    private IAspectRow getRelatedAspectRow(IAspectRow dataType, String typeName, String relationName) throws DdException {
        IAspect dataTypeAspect = dataType.getRelatedAspect(relationName);
        this.mServiceFacade.flush();
        if (dataTypeAspect == null) {
            throw new DdException(MessagePool.getMessage((String)"Type & does not exist", (String)typeName));
        }
        IAspectRow dataTypeAspectRow = dataTypeAspect.getAspectRow(0);
        if (dataTypeAspectRow == null || dataTypeAspectRow.size() <= 0) {
            throw new DdException(MessagePool.getMessage((String)"Type & does not exist", (String)typeName));
        }
        return dataTypeAspectRow;
    }

    private HashMap getDataTypeInfo2(IAspectRow dataTypeAspectRow) {
        HashMap<String, String> dataType = new HashMap<String, String>();
        int size = dataTypeAspectRow.getDescriptor().size();
        int i = 0;
        while (i < size) {
            String columnName = dataTypeAspectRow.getDescriptor().getFieldDescriptor(i).getName();
            if (!ProviderUtil.stringIsEmpty((String)columnName)) {
                dataType.put(columnName, dataTypeAspectRow.getAttributeAsString(i));
            }
            ++i;
        }
        return dataType;
    }

    private int getIntegerAttribute(IAspectRow aspectRow, String attributeName) {
        String string = aspectRow.getAttributeAsString(attributeName);
        if (ProviderUtil.stringIsEmpty((String)string)) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    private void createUnitsService() throws DdException {
        if (this.mUnitsServiceModule != null) {
            return;
        }
        this.mUnitsServiceModule = this.mServiceFacade.getServiceModule("UNITS");
        if (this.mUnitsServiceModule == null) {
            throw new DdException(MessagePool.getMessage((String)"Service module & does not exist", (String)"UNITS"));
        }
        this.mUnitsServiceModule.setDebug(this.mDebug, null);
        this.mUnitsQuery = this.mUnitsServiceModule.createQuery("DD_UNITS");
        if (this.mUnitsQuery == null) {
            throw new DdException(MessagePool.getMessage((String)"Query & does not exist", (String)"DD_UNITS"));
        }
        this.mUnitsQueryParameter = this.mUnitsQuery.getInputParameterStructure();
        if (this.mUnitsQueryParameter == null) {
            throw new DdException("Constructor DataProvider: query parameter structure is null");
        }
    }

    private ISimpleType createUnitType(IAspectRow unit, Locale locale, String cacheName) throws DdException {
        XmlMap schemaType = null;
        if (unit == null || locale == null) {
            throw new DdException(MessagePool.getMessage((String)"Invalid call of method &", (String)"createUnitType(IAspectRow, Locale, String)"));
        }
        DdNameTranslator ddNameTranslator = DdNameTranslator.getDummyInstance();
        String unitType = unit.getAttributeAsString("UNITTYPE");
        String r3Name = unit.getAttributeAsString("UNITNAME");
        if (ProviderUtil.stringIsEmpty((String)r3Name)) {
            if (unitType.equalsIgnoreCase("C")) {
                throw new DdException(MessagePool.getMessage((String)"Currency & does not exist", (String)cacheName));
            }
            throw new DdException(MessagePool.getMessage((String)"Unit of measurement & does not exist", (String)cacheName));
        }
        String javaName = ddNameTranslator.typeNameToFrontend(r3Name);
        if (javaName == null) {
            javaName = "";
        }
        String r3BuiltInType = unit.getAttributeAsString("DATATYPE");
        int r3Length = this.getIntegerAttribute(unit, "LENGTH");
        int r3Decimals = this.getIntegerAttribute(unit, "DECIMALS");
        String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
        if (javaBuiltInType == null) {
            javaBuiltInType = "";
        }
        if (TypeConversionService.hasSchemaType((String)javaBuiltInType)) {
            schemaType = ProviderUtil.createSchemaTypeXmlMap((String)r3BuiltInType, (int)r3Length, (int)r3Length);
        }
        XmlMap xmlMap = null;
        if (unitType.equalsIgnoreCase("C")) {
            // empty if block
        }
        ISimpleType simpleType = DdSimpleType.makeNew((IDataProvider)this, (Locale)locale, xmlMap);
        char cache = unitType.equalsIgnoreCase("C") ? (char)'C' : 'U';
        ProviderUtil.putIntoCache((Map)this.getCache(cache), (String)cacheName, (IDataType)simpleType, (Locale)locale);
        return simpleType;
    }

    private void cacheDataElements(IAspect fields) {
        IAspect dataTypes = fields.getRelatedAspect("DD_FIELD_DATATYPE");
        if (dataTypes != null && !dataTypes.isEmpty()) {
            int i = 0;
            while (i < dataTypes.size()) {
                String typeName;
                String typeKind = this.getTypeKind(dataTypes, i);
                IAspectRow dataType = dataTypes.getAspectRow(i);
                if (typeKind.equalsIgnoreCase("DTEL") && !this.mDataElements.containsKey(typeName = dataType.getAttributeAsString("TYPENAME"))) {
                    IAspect dataElement = dataType.getRelatedAspect("DD_DATATYPE_DATAELEMENT");
                    this.mCoolDataTypes.put(typeName, dataType);
                    this.mDataElements.put(typeName, dataElement.getAspectRow(0));
                }
                ++i;
            }
        }
    }

    public IDataType[] getDataTypes(String[] names, Locale locale, Object providerInfo) throws DdException {
        Object dataType = null;
        if (names == null || names.length == 0 || locale == null || providerInfo != null && !(providerInfo instanceof DdNameTranslator)) {
            throw new DdException(MessagePool.getMessage((String)"Invalid call of method &", (String)"getDataType(String, Locale, Object)"));
        }
        DdNameTranslator ddNameTranslator = null;
        ddNameTranslator = providerInfo != null ? (DdNameTranslator)providerInfo : DdNameTranslator.getDummyInstance();
        String[] r3Names = new String[names.length];
        int i = 0;
        while (i < names.length) {
            r3Names[i] = ddNameTranslator.typeNameToBackendInternal(names[i]);
            ++i;
        }
        IKeyList keyList = this.mDictionaryServiceModule.createKeyList("DD_DATATYPE_KEY");
        int i2 = 0;
        while (i2 < r3Names.length) {
            String[] keyElements = new String[]{r3Names[i2]};
            IKey key = this.mDictionaryServiceModule.createKey("DD_DATATYPE_KEY", keyElements);
            keyList.add(key);
            ++i2;
        }
        IAspect dataTypes = this.mDictionaryServiceModule.getAspect("DD_DATATYPE", keyList);
        System.out.println("Data types......");
        int i3 = 0;
        while (i3 < dataTypes.size()) {
            int nsize = dataTypes.getAspectRow(i3).getDescriptor().size();
            System.out.println("------->");
            int j = 0;
            while (j < nsize) {
                System.out.println(dataTypes.getAspectRow(i3).getDescriptor().getFieldDescriptor(j).getName() + ": " + dataTypes.getAspectRow(i3).getAttributeAsString(j));
                ++j;
            }
            ++i3;
        }
        return null;
    }

    private static IServiceFacade createServiceFacade(String client, String user, String password, String language, String applicationServer, String systemNumber, Locale locale) {
        IConnectionDataService connectionDataService = ConnectionDataServiceFactory.getConnectionDataService();
        ConnectionDataAppServer connectionDataAppServer = (ConnectionDataAppServer)connectionDataService.getConnectionData("JCO", "0");
        connectionDataAppServer.setAppServer(applicationServer);
        connectionDataAppServer.setSystemNumber(systemNumber);
        connectionDataAppServer.setClient(client);
        connectionDataAppServer.setUser(user);
        connectionDataAppServer.setPassword(password);
        connectionDataAppServer.setLanguage(language);
        return ServiceFacadeFactory.createServiceFacade((ConnectionData)connectionDataAppServer, (Locale)locale);
    }

    public IDataType getDataTypeFromCache(String name, Locale locale) {
        return ProviderUtil.getFromCache((Map)this.getCache('D'), (String)name, (Locale)locale);
    }
}

