/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.wsproxy.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.wsproxy.implementation.AbstractFileState;
import com.sap.ide.metamodel.wsproxy.implementation.ImportMapState;
import com.sap.ide.metamodel.wsproxy.implementation.SchemaFileState;
import com.sap.ide.metamodel.wsproxy.implementation.WsdlFileState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class WsdlState
extends AbstractFileState {
    private ImportMapState mImportMap = null;
    private HashMap mSchemaFiles = new HashMap();
    private HashMap mWsdlFiles = new HashMap();

    WsdlState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        WsdlState lState = (WsdlState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        WsdlState lState = (WsdlState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        WsdlState lState = (WsdlState)((Object)super.clone());
        if (this.mImportMap != null) {
            lState.mImportMap = (ImportMapState)((Object)this.mImportMap.clone());
        }
        lState.mSchemaFiles = new HashMap();
        Iterator it = this.mSchemaFiles.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mSchemaFiles.put(lKey, ((SchemaFileState)((Object)this.mSchemaFiles.get(lKey))).clone());
        }
        lState.mWsdlFiles = new HashMap();
        Iterator it2 = this.mWsdlFiles.keySet().iterator();
        while (it2.hasNext()) {
            String lKey = (String)it2.next();
            lState.mWsdlFiles.put(lKey, ((WsdlFileState)((Object)this.mWsdlFiles.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mImportMap != null) {
            this.mImportMap.removeExternalReferences(innerObjectKeys);
        }
        Iterator it = this.mSchemaFiles.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mWsdlFiles.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mImportMap != null) {
            if (clipboardService.isExcluded((Reference)this.mImportMap.getProxyReference())) {
                this.mImportMap = null;
            } else {
                this.mImportMap.refactor(clipboardService);
            }
        }
        Iterator it = this.mSchemaFiles.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mWsdlFiles.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mImportMap != null) {
            this.mImportMap.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it = this.mSchemaFiles.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mWsdlFiles.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setImportMap(ImportMapState state) {
        this.mImportMap = state;
    }

    ImportMapState getImportMap() {
        return this.mImportMap;
    }

    void addgetSchemaFile(SchemaFileState state) {
        this.mSchemaFiles.put(state.getName().toLowerCase(), state);
    }

    int getgetSchemaFileCount() {
        return this.mSchemaFiles.size();
    }

    SchemaFileState getgetSchemaFile(String name) {
        return (SchemaFileState)((Object)this.mSchemaFiles.get(name.toLowerCase()));
    }

    Vector getSchemaFiles() {
        return new Vector(this.mSchemaFiles.values());
    }

    void removegetSchemaFile(String aggregationKey) {
        this.mSchemaFiles.remove(aggregationKey.toLowerCase());
    }

    void removegetSchemaFile(SchemaFileState state) {
        this.mSchemaFiles.remove(state.getName().toLowerCase());
    }

    void removeAllSchemaFiles() {
        this.mSchemaFiles.clear();
    }

    void addWsdlFile(WsdlFileState state) {
        this.mWsdlFiles.put(state.getName().toLowerCase(), state);
    }

    int getWsdlFileCount() {
        return this.mWsdlFiles.size();
    }

    WsdlFileState getWsdlFile(String name) {
        return (WsdlFileState)((Object)this.mWsdlFiles.get(name.toLowerCase()));
    }

    Vector getWsdlFiles() {
        return new Vector(this.mWsdlFiles.values());
    }

    void removeWsdlFile(String aggregationKey) {
        this.mWsdlFiles.remove(aggregationKey.toLowerCase());
    }

    void removeWsdlFile(WsdlFileState state) {
        this.mWsdlFiles.remove(state.getName().toLowerCase());
    }

    void removeAllWsdlFiles() {
        this.mWsdlFiles.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ImportMap")) {
            this.setImportMap((ImportMapState)((Object)data));
        } else if (roleName.equals("SchemaFiles")) {
            this.addgetSchemaFile((SchemaFileState)((Object)data));
        } else if (roleName.equals("WsdlFiles")) {
            this.addWsdlFile((WsdlFileState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

