/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.wsproxy.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.wsproxy.implementation.ImportPathMappingState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ImportMapState
extends DevelopmentObjectState {
    private HashMap mImportPathMappings = new HashMap();

    ImportMapState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ImportMapState lState = (ImportMapState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ImportMapState lState = (ImportMapState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        ImportMapState lState = (ImportMapState)((Object)super.clone());
        lState.mImportPathMappings = new HashMap();
        Iterator it = this.mImportPathMappings.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mImportPathMappings.put(lKey, ((ImportPathMappingState)((Object)this.mImportPathMappings.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        Iterator it = this.mImportPathMappings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.mProxyRef = null;
        }
        Iterator it = this.mImportPathMappings.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        Iterator it = this.mImportPathMappings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
    }

    void addImportPathMapping(ImportPathMappingState state) {
        this.mImportPathMappings.put(state.getName().toLowerCase(), state);
    }

    int getImportPathMappingCount() {
        return this.mImportPathMappings.size();
    }

    ImportPathMappingState getImportPathMapping(String name) {
        return (ImportPathMappingState)((Object)this.mImportPathMappings.get(name.toLowerCase()));
    }

    Vector getImportPathMappings() {
        return new Vector(this.mImportPathMappings.values());
    }

    void removeImportPathMapping(String aggregationKey) {
        this.mImportPathMappings.remove(aggregationKey.toLowerCase());
    }

    void removeImportPathMapping(ImportPathMappingState state) {
        this.mImportPathMappings.remove(state.getName().toLowerCase());
    }

    void removeAllImportPathMappings() {
        this.mImportPathMappings.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ImportPathMappings")) {
            this.addImportPathMapping((ImportPathMappingState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

