/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public final class ResourceDeltaDumper
implements IResourceDeltaVisitor {
    private static Map TYPES = new HashMap();

    public void dump(IResourceChangeEvent event, Object host) {
        this.dump("[-- resource delta --]");
        String type = (String)TYPES.get(new Integer(event.getType()));
        if (type == null) {
            type = "UNKNOWN";
        }
        this.dump("[ " + type + " in " + host + " ]");
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        this.dump("[-- xxxxxxxxxxxxxx --]");
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        String kind = "";
        if ((1 & delta.getKind()) != 0) {
            kind = kind + "+";
        }
        if ((2 & delta.getKind()) != 0) {
            kind = kind + "-";
        }
        if ((4 & delta.getKind()) != 0) {
            kind = kind + "*";
        }
        if ((8 & delta.getKind()) != 0) {
            kind = kind + "{+}";
        }
        if ((0x10 & delta.getKind()) != 0) {
            kind = kind + "{-}";
        }
        String flags = "";
        if ((0x100 & delta.getFlags()) != 0) {
            flags = flags + "CONTENT ";
        }
        if ((0x1000 & delta.getFlags()) != 0) {
            flags = flags + "MOVED_FROM ";
        }
        if ((0x2000 & delta.getFlags()) != 0) {
            flags = flags + "MOVED_TO ";
        }
        if ((0x4000 & delta.getFlags()) != 0) {
            flags = flags + "OPEN ";
        }
        if ((0x8000 & delta.getFlags()) != 0) {
            flags = flags + "TYPE ";
        }
        if ((0x10000 & delta.getFlags()) != 0) {
            flags = flags + "SYNC ";
        }
        if ((0x20000 & delta.getFlags()) != 0) {
            flags = flags + "MARKERS ";
        }
        if ((0x40000 & delta.getFlags()) != 0) {
            flags = flags + "REPLACED ";
        }
        if ((0x80000 & delta.getFlags()) != 0) {
            flags = flags + "DESCRIPTION ";
        }
        if (flags.length() != 0) {
            flags = "[" + flags.substring(0, flags.length() - 1) + "] ";
        }
        this.dump(kind + " " + flags + resource);
        return true;
    }

    protected void dump(String s) {
        System.err.println(s);
    }

    static {
        TYPES.put(new Integer(16), "POST_AUTO_BUILD");
        TYPES.put(new Integer(1), "POST_CHANGE");
        TYPES.put(new Integer(8), "PRE_AUTO_BUILD");
        TYPES.put(new Integer(2), "PRE_CLOSE");
        TYPES.put(new Integer(4), "PRE_DELETE");
    }
}

