/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.util;

import com.tssap.j2ee.core.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomUtils {
    private static final String ALL = "*";
    private static final String LF = "\n";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String ID = "id";
    private static List ourDocumentsInCdataMode = new ArrayList();

    private DomUtils() {
    }

    public static String getId(Element element) {
        return element.getAttribute(ID);
    }

    public static void setId(Element element, String id) {
        if (id == null || id.trim().length() == 0) {
            element.removeAttribute(ID);
        } else {
            element.setAttribute(ID, id);
        }
    }

    public static boolean hasChildElements(Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Element getChildElement(Element element, String childName) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals(childName) && child instanceof Element) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    public static Element[] getChildElements(Element element, String childName) {
        NodeList children = element.getChildNodes();
        ArrayList<Node> childNodes = new ArrayList<Node>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals(childName) && child instanceof Element) {
                childNodes.add(child);
            }
            ++i;
        }
        return childNodes.toArray(new Element[childNodes.size()]);
    }

    public static Element createChildElement(Element parent, String childName, Element before) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElement(childName);
        parent.insertBefore(element, before);
        DomUtils.addLineFeeds(element);
        return element;
    }

    public static Element createChildElement(Element parent, String[] childOrder, String childName) {
        Element before = DomUtils.getPlacement(parent, childOrder, childName);
        return DomUtils.createChildElement(parent, childName, before);
    }

    public static void removeElement(Element element) {
        element.getParentNode().removeChild(element);
    }

    public static void removeIfEmpty(Element element) {
        DomUtils.removeIfEmpty(element, null);
    }

    public static void removeIfEmpty(Element element, String stopAt) {
        NodeList children = element.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) {
                return;
            }
            String text = child.getNodeValue();
            if (text.trim().length() > 0) {
                return;
            }
            --i;
        }
        Node parent = element.getParentNode();
        if (parent == null) {
            return;
        }
        parent.removeChild(element);
    }

    public static void removeChildNodes(Element element, String childName) {
        NodeList children = element.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (childName.equals(child.getNodeName())) {
                element.removeChild(child);
            }
            --i;
        }
    }

    private static Element getPlacement(Element parent, String[] childOrder, String name) {
        int pos = ArrayUtils.indexOf((Object[])childOrder, (Object)name);
        if (pos < 0) {
            return null;
        }
        Element result = null;
        NodeList children = parent.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                int childPos = ArrayUtils.indexOf((Object[])childOrder, (Object)child.getNodeName());
                if (childPos <= pos) break;
                result = (Element)child;
            }
            --i;
        }
        return result;
    }

    private static Node createTextNode(Element element) {
        Document document = element.getOwnerDocument();
        Text node = document.createTextNode("");
        element.appendChild(node);
        return node;
    }

    private static Node createCdataNode(Element element) {
        Document document = element.getOwnerDocument();
        CDATASection node = document.createCDATASection("");
        element.appendChild(node);
        return node;
    }

    public static String getElementText(Element element) {
        String singleText = null;
        StringBuffer text = null;
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String childText = null;
            if (child.getNodeType() == 3) {
                childText = child.getNodeValue();
            } else if (child.getNodeType() == 4) {
                childText = child.getNodeValue();
            } else {
                return null;
            }
            if (childText != null) {
                if (singleText == null) {
                    singleText = childText;
                } else {
                    if (text == null) {
                        text = new StringBuffer(singleText);
                    }
                    text.append(childText);
                }
            }
            ++i;
        }
        if (text != null) {
            return text.toString();
        }
        return singleText;
    }

    public static String getTextNodeValue(Element element) {
        return DomUtils.getElementText(element);
    }

    public static String getChildTextNodeValue(Element element, String childName) {
        Element child = DomUtils.getChildElement(element, childName);
        if (child == null) {
            return null;
        }
        return DomUtils.getElementText(child);
    }

    private static boolean isChildElementTextCdata(Element element, String childName) {
        Element firstChild = DomUtils.getChildElement(element, childName);
        if (firstChild == null) {
            return false;
        }
        NodeList children = firstChild.getChildNodes();
        if (children.getLength() != 1) {
            return false;
        }
        Node firstChildChild = children.item(0);
        return firstChildChild.getNodeType() == 4;
    }

    private static void setChildElementText(Element element, String childName, String text, Element before) {
        DomUtils.removeChildNodes(element, childName);
        if (text != null) {
            Element child = DomUtils.createChildElement(element, childName, before);
            if (DomUtils.isDocumentInCdataMode(element.getOwnerDocument())) {
                Node childCdata = DomUtils.createCdataNode(child);
                childCdata.setNodeValue(text);
            } else {
                Node childText = DomUtils.createTextNode(child);
                childText.setNodeValue(text);
            }
        }
    }

    public static void setElementText(Element element, String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        NodeList children = element.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            element.removeChild(children.item(i));
            --i;
        }
        if (DomUtils.isDocumentInCdataMode(element.getOwnerDocument())) {
            Node childCdata = DomUtils.createCdataNode(element);
            childCdata.setNodeValue(text);
        } else {
            Node childText = DomUtils.createTextNode(element);
            childText.setNodeValue(text);
        }
    }

    public static void setChildTextNodeValue(Element element, String childName, String value, Element before) {
        DomUtils.setChildElementText(element, childName, value, before);
    }

    public static void setChildTextNodeValue(Element element, String[] childOrder, String childName, String value) {
        Element before = DomUtils.getPlacement(element, childOrder, childName);
        DomUtils.setChildTextNodeValue(element, childName, value, before);
    }

    public static Node createChildTextNode(Element parent, String childName, Element before) {
        Element element = DomUtils.createChildElement(parent, childName, before);
        Document document = parent.getOwnerDocument();
        Text contents = document.createTextNode("");
        element.appendChild(contents);
        return contents;
    }

    public static Node createChildTextNode(Element parent, String[] childOrder, String childName) {
        Element before = DomUtils.getPlacement(parent, childOrder, childName);
        return DomUtils.createChildTextNode(parent, childName, before);
    }

    private static Node getFirstChildTextNode(Element element, String childName) {
        Element child = DomUtils.getChildElement(element, childName);
        if (child == null) {
            return null;
        }
        return DomUtils.getFirstTextNode(child);
    }

    private static Node getFirstTextNode(Element element) {
        Node contents = element.getFirstChild();
        if (contents == null) {
            contents = element.getOwnerDocument().createTextNode("");
            element.appendChild(contents);
        } else if (contents.getNodeType() != 3) {
            return null;
        }
        return contents;
    }

    private static Node getLineFeed(Node node) {
        return node.getOwnerDocument().createTextNode(LF);
    }

    private static String getText(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 3) {
            return null;
        }
        return node.getNodeValue();
    }

    private static boolean endsWithLineFeed(Node node) {
        String text = DomUtils.getText(node);
        if (text == null || text.length() == 0) {
            return false;
        }
        return text.endsWith(LF);
    }

    private static boolean startsWithLineFeed(Node node) {
        String text = DomUtils.getText(node);
        if (text == null || text.length() == 0) {
            return false;
        }
        return text.startsWith(LF);
    }

    private static void addLineFeeds(Node node) {
        Node next;
        if (!DomUtils.endsWithLineFeed(node.getPreviousSibling())) {
            node.getParentNode().insertBefore(DomUtils.getLineFeed(node), node);
        }
        if (!DomUtils.startsWithLineFeed(next = node.getNextSibling())) {
            if (next == null) {
                node.getParentNode().appendChild(DomUtils.getLineFeed(node));
            } else {
                node.getParentNode().insertBefore(DomUtils.getLineFeed(node), next);
            }
        }
    }

    public static void registerDocumentInCdataMode(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        ourDocumentsInCdataMode.add(doc);
    }

    public static void unregisterDocumentInCdataMode(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        ourDocumentsInCdataMode.remove(doc);
    }

    private static boolean isDocumentInCdataMode(Document doc) {
        return ourDocumentsInCdataMode.contains(doc);
    }
}

