/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.DescriptorMetaInfo;
import com.tssap.j2ee.core.descriptor.ResourceRef;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.EnvironmentHost;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

public final class ResourceRefImpl
extends DescribedDescriptorEntityImpl
implements ResourceRef {
    public ResourceRefImpl(EnvironmentHost parent, Element element) {
        super((DescriptorEntityImpl)((Object)parent), element);
    }

    public String toString() {
        return "ResourceReference \"" + this.getName() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getName();
        this.modify(new Runnable(){

            public void run() {
                ResourceRefImpl.super.delete();
                ResourceRefImpl.this.getEnvironmentHost().updateResourceReference(oldName);
            }
        });
    }

    public String getName() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "res-ref-name");
    }

    public boolean canSetName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (DescriptorEntityImpl.equals(this.getName(), name)) {
            return true;
        }
        return this.getEnvironmentHost().getResourceReference(name) == null;
    }

    public void setName(String name) {
        if (!this.canSetName(name)) {
            throw new IllegalArgumentException(name);
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        String oldName = this.getName();
        DomUtils.setChildTextNodeValue(this.getElement(), this.getChildOrder(), "res-ref-name", name);
        this.getEnvironmentHost().updateResourceReference(oldName);
        this.changed(this);
    }

    public String getType() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "res-type");
    }

    public boolean canSetType(String type) {
        return type != null && type.length() != 0;
    }

    public void setType(String type) {
        if (!this.canSetType(type)) {
            throw new IllegalArgumentException(type);
        }
        if (DescriptorEntityImpl.equals(this.getType(), type)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue(this.getElement(), this.getChildOrder(), "res-type", type);
        this.changed(this);
    }

    public String getAuth() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "res-auth");
    }

    public boolean canSetAuth(String auth) {
        return DescriptorMetaInfo.isValidResAuth(auth);
    }

    public void setAuth(String auth) {
        if (!this.canSetAuth(auth)) {
            throw new IllegalArgumentException(auth);
        }
        if (DescriptorEntityImpl.equals(this.getAuth(), auth)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue(this.getElement(), this.getChildOrder(), "res-auth", auth);
        this.changed(this);
    }

    public String getSharingScope() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "res-sharing-scope");
    }

    public boolean canSetSharingScope(String scope) {
        return DescriptorMetaInfo.isValidResSharingScope(scope);
    }

    public void setSharingScope(String scope) {
        if (!this.canSetSharingScope(scope)) {
            throw new IllegalArgumentException(scope);
        }
        if (DescriptorEntityImpl.equals(this.getSharingScope(), scope)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue(this.getElement(), this.getChildOrder(), "res-sharing-scope", scope);
        this.changed(this);
    }

    protected String[] getChildOrder() {
        return this.getEnvironmentHost().getResourceReferenceOrder();
    }

    private EnvironmentHost getEnvironmentHost() {
        return (EnvironmentHost)this.getParent();
    }
}

