/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.AccessibleBean;
import com.tssap.j2ee.core.descriptor.DescriptorMetaInfo;
import com.tssap.j2ee.core.descriptor.EjbLocalRef;
import com.tssap.j2ee.core.descriptor.EjbRef;
import com.tssap.j2ee.core.descriptor.EnvEntry;
import com.tssap.j2ee.core.descriptor.ResourceEnvRef;
import com.tssap.j2ee.core.descriptor.ResourceRef;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.EjbLocalRefImpl;
import com.tssap.j2ee.internal.core.descriptor.EjbRefImpl;
import com.tssap.j2ee.internal.core.descriptor.EnvEntryImpl;
import com.tssap.j2ee.internal.core.descriptor.EnvironmentHost;
import com.tssap.j2ee.internal.core.descriptor.ResourceEnvRefImpl;
import com.tssap.j2ee.internal.core.descriptor.ResourceRefImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class EnvironmentImpl
extends DescriptorEntityImpl
implements EnvironmentHost {
    private Map myEjbLocalReferences;
    private Map myEjbReferences;
    private Map myEnvironment;
    private Map myResourceEnvironmentReferences;
    private Map myResourceReferences;

    public EnvironmentImpl(DescriptorEntityImpl parent, Element element) {
        super(parent, element);
    }

    protected void readEjbLocalReferences() {
        if (this.myEjbLocalReferences == null) {
            this.myEjbLocalReferences = new HashMap();
            Element[] nodes = DomUtils.getChildElements(this.getElement(), "ejb-local-ref");
            int i = 0;
            while (i < nodes.length) {
                EjbLocalRefImpl ref = new EjbLocalRefImpl(this, nodes[i]);
                String name = ref.getName();
                if (!DescriptorEntityImpl.isNull(name) && !this.myEjbLocalReferences.containsKey(name) && DescriptorMetaInfo.isValidEjbRefType(ref.getType())) {
                    this.myEjbLocalReferences.put(name, ref);
                }
                ++i;
            }
        }
    }

    public void updateEjbLocalReference(String name) {
        EjbLocalRef ref;
        if (this.myEjbLocalReferences != null && (ref = (EjbLocalRef)this.myEjbLocalReferences.remove(name)) != null && ref.isValid()) {
            this.myEjbLocalReferences.put(ref.getName(), ref);
        }
    }

    public EjbLocalRef[] getEjbLocalReferences() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readEjbLocalReferences();
        if (this.myEjbLocalReferences.isEmpty()) {
            return null;
        }
        Collection refs = this.myEjbLocalReferences.values();
        return refs.toArray(new EjbLocalRef[refs.size()]);
    }

    public EjbLocalRef getEjbLocalReference(String name) {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readEjbLocalReferences();
        return (EjbLocalRef)this.myEjbLocalReferences.get(name);
    }

    public boolean canCreateEjbLocalReference(String name, String type, String linkPath, String linkTarget, String localHomeInterface, String localInterface, String description) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        this.readEjbLocalReferences();
        if (DescriptorEntityImpl.isNull(name) || this.myEjbLocalReferences.containsKey(name)) {
            return false;
        }
        if (DescriptorEntityImpl.isNull(localHomeInterface) || DescriptorEntityImpl.isNull(localInterface)) {
            return false;
        }
        return this.canCreateEjbReferenceBase(name, type, linkPath, linkTarget, description);
    }

    public EjbLocalRef createEjbLocalReference(String name, String type, String linkPath, String linkTarget, String localHomeInterface, String localInterface, String description) {
        if (!this.canCreateEjbLocalReference(name, type, linkPath, linkTarget, localHomeInterface, localInterface, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element refElement = DomUtils.createChildElement(this.getElement(), this.getEnvironmentHostOrder(), "ejb-local-ref");
        if (description != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getEjbLocalReferenceOrder(), "description", description);
        }
        DomUtils.setChildTextNodeValue(refElement, this.getEjbLocalReferenceOrder(), "ejb-ref-name", name);
        DomUtils.setChildTextNodeValue(refElement, this.getEjbLocalReferenceOrder(), "ejb-ref-type", type);
        DomUtils.setChildTextNodeValue(refElement, this.getEjbLocalReferenceOrder(), "local-home", localHomeInterface);
        DomUtils.setChildTextNodeValue(refElement, this.getEjbLocalReferenceOrder(), "local", localInterface);
        String link = DescriptorMetaInfo.getEjbLink(linkPath, linkTarget);
        if (link != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getEjbLocalReferenceOrder(), "ejb-link", link);
        }
        EjbLocalRefImpl ref = new EjbLocalRefImpl(this, refElement);
        this.myEjbLocalReferences.put(ref.getName(), ref);
        this.added(ref);
        return ref;
    }

    protected void readEjbReferences() {
        if (this.myEjbReferences == null) {
            this.myEjbReferences = new HashMap();
            Element[] nodes = DomUtils.getChildElements(this.getElement(), "ejb-ref");
            int i = 0;
            while (i < nodes.length) {
                EjbRefImpl ref = new EjbRefImpl(this, nodes[i]);
                String name = ref.getName();
                if (!DescriptorEntityImpl.isNull(name) && !this.myEjbReferences.containsKey(name) && DescriptorMetaInfo.isValidEjbRefType(ref.getType())) {
                    this.myEjbReferences.put(name, ref);
                }
                ++i;
            }
        }
    }

    public void updateEjbReference(String name) {
        EjbRef ref;
        if (this.myEjbReferences != null && (ref = (EjbRef)this.myEjbReferences.remove(name)) != null && ref.isValid()) {
            this.myEjbReferences.put(ref.getName(), ref);
        }
    }

    public EjbRef[] getEjbReferences() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readEjbReferences();
        if (this.myEjbReferences.isEmpty()) {
            return null;
        }
        Collection refs = this.myEjbReferences.values();
        return refs.toArray(new EjbRef[refs.size()]);
    }

    public EjbRef getEjbReference(String name) {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readEjbReferences();
        return (EjbRef)this.myEjbReferences.get(name);
    }

    public boolean canCreateEjbReference(String name, String type, String linkPath, String linkTarget, String homeInterface, String remoteInterface, String description) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        this.readEjbReferences();
        if (DescriptorEntityImpl.isNull(name) || this.myEjbReferences.containsKey(name)) {
            return false;
        }
        if (DescriptorEntityImpl.isNull(homeInterface) || DescriptorEntityImpl.isNull(remoteInterface)) {
            return false;
        }
        return this.canCreateEjbReferenceBase(name, type, linkPath, linkTarget, description);
    }

    public EjbRef createEjbReference(String name, String type, String linkPath, String linkTarget, String homeInterface, String remoteInterface, String description) {
        if (!this.canCreateEjbReference(name, type, linkPath, linkTarget, homeInterface, remoteInterface, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element refElement = DomUtils.createChildElement(this.getElement(), this.getEnvironmentHostOrder(), "ejb-ref");
        if (description != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getEjbReferenceOrder(), "description", description);
        }
        DomUtils.setChildTextNodeValue(refElement, this.getEjbReferenceOrder(), "ejb-ref-name", name);
        DomUtils.setChildTextNodeValue(refElement, this.getEjbReferenceOrder(), "ejb-ref-type", type);
        DomUtils.setChildTextNodeValue(refElement, this.getEjbReferenceOrder(), "home", homeInterface);
        DomUtils.setChildTextNodeValue(refElement, this.getEjbReferenceOrder(), "remote", remoteInterface);
        String link = DescriptorMetaInfo.getEjbLink(linkPath, linkTarget);
        if (link != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getEjbReferenceOrder(), "ejb-link", link);
        }
        EjbRefImpl ref = new EjbRefImpl(this, refElement);
        this.myEjbReferences.put(ref.getName(), ref);
        this.added(ref);
        return ref;
    }

    protected void readEnvironment() {
        if (this.myEnvironment == null) {
            this.myEnvironment = new HashMap();
            Element[] nodes = DomUtils.getChildElements(this.getElement(), "env-entry");
            int i = 0;
            while (i < nodes.length) {
                EnvEntryImpl entry = new EnvEntryImpl(this, nodes[i]);
                String name = entry.getName();
                if (!DescriptorEntityImpl.isNull(name) && !this.myEnvironment.containsKey(name)) {
                    this.myEnvironment.put(name, entry);
                }
                ++i;
            }
        }
    }

    public void updateEnvironmentEntry(String name) {
        EnvEntry entry;
        if (this.myEnvironment != null && (entry = (EnvEntry)this.myEnvironment.remove(name)) != null && entry.isValid()) {
            this.myEnvironment.put(entry.getName(), entry);
        }
    }

    public EnvEntry[] getEnvironment() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readEnvironment();
        if (this.myEnvironment.isEmpty()) {
            return null;
        }
        Collection entries = this.myEnvironment.values();
        return entries.toArray(new EnvEntry[entries.size()]);
    }

    public EnvEntry getEnvironmentEntry(String name) {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readEnvironment();
        return (EnvEntry)this.myEnvironment.get(name);
    }

    public boolean canCreateEnvironmentEntry(String name, String type, String value, String description) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        this.readEnvironment();
        if (DescriptorEntityImpl.isNull(name) || this.myEnvironment.containsKey(name)) {
            return false;
        }
        return type != null && DescriptorMetaInfo.ENV_ENTRY_TYPES.contains(type);
    }

    public EnvEntry createEnvironmentEntry(String name, String type, String value, String description) {
        if (!this.canCreateEnvironmentEntry(name, type, value, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element entryElement = DomUtils.createChildElement(this.getElement(), this.getEnvironmentHostOrder(), "env-entry");
        if (description != null) {
            DomUtils.setChildTextNodeValue(entryElement, this.getEnvironmentEntryOrder(), "description", description);
        }
        DomUtils.setChildTextNodeValue(entryElement, this.getEnvironmentEntryOrder(), "env-entry-name", name);
        DomUtils.setChildTextNodeValue(entryElement, this.getEnvironmentEntryOrder(), "env-entry-type", type);
        if (value != null) {
            DomUtils.setChildTextNodeValue(entryElement, this.getEnvironmentEntryOrder(), "env-entry-value", value);
        }
        EnvEntryImpl entry = new EnvEntryImpl(this, entryElement);
        this.myEnvironment.put(entry.getName(), entry);
        this.added(entry);
        return entry;
    }

    protected void readResourceEnvironmentReferences() {
        if (this.myResourceEnvironmentReferences == null) {
            this.myResourceEnvironmentReferences = new HashMap();
            Element[] nodes = DomUtils.getChildElements(this.getElement(), "resource-env-ref");
            int i = 0;
            while (i < nodes.length) {
                ResourceEnvRefImpl ref = new ResourceEnvRefImpl(this, nodes[i]);
                String name = ref.getName();
                if (!DescriptorEntityImpl.isNull(name) && !this.myResourceEnvironmentReferences.containsKey(name)) {
                    this.myResourceEnvironmentReferences.put(name, ref);
                }
                ++i;
            }
        }
    }

    public void updateResourceEnvironmentReference(String name) {
        ResourceEnvRef ref;
        if (this.myResourceEnvironmentReferences != null && (ref = (ResourceEnvRef)this.myResourceEnvironmentReferences.remove(name)) != null && ref.isValid()) {
            this.myResourceEnvironmentReferences.put(ref.getName(), ref);
        }
    }

    public ResourceEnvRef[] getResourceEnvironmentReferences() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readResourceEnvironmentReferences();
        if (this.myResourceEnvironmentReferences.isEmpty()) {
            return null;
        }
        Collection refs = this.myResourceEnvironmentReferences.values();
        return refs.toArray(new ResourceEnvRef[refs.size()]);
    }

    public ResourceEnvRef getResourceEnvironmentReference(String name) {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readResourceEnvironmentReferences();
        return (ResourceEnvRef)this.myResourceEnvironmentReferences.get(name);
    }

    public boolean canCreateResourceEnvironmentReference(String name, String type, String description) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        this.readResourceEnvironmentReferences();
        return !DescriptorEntityImpl.isNull(name) && !this.myResourceEnvironmentReferences.containsKey(name);
    }

    public ResourceEnvRef createResourceEnvironmentReference(String name, String type, String description) {
        if (!this.canCreateResourceEnvironmentReference(name, type, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element refElement = DomUtils.createChildElement(this.getElement(), this.getEnvironmentHostOrder(), "resource-env-ref");
        if (description != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getResourceEnvironmentReferenceOrder(), "description", description);
        }
        DomUtils.setChildTextNodeValue(refElement, this.getResourceEnvironmentReferenceOrder(), "resource-env-ref-name", name);
        DomUtils.setChildTextNodeValue(refElement, this.getResourceEnvironmentReferenceOrder(), "resource-env-ref-type", type);
        ResourceEnvRefImpl ref = new ResourceEnvRefImpl(this, refElement);
        this.myResourceEnvironmentReferences.put(ref.getName(), ref);
        this.added(ref);
        return ref;
    }

    protected void readResourceReferences() {
        if (this.myResourceReferences == null) {
            this.myResourceReferences = new HashMap();
            Element[] nodes = DomUtils.getChildElements(this.getElement(), "resource-ref");
            int i = 0;
            while (i < nodes.length) {
                ResourceRefImpl ref = new ResourceRefImpl(this, nodes[i]);
                String name = ref.getName();
                if (!DescriptorEntityImpl.isNull(name) && !this.myResourceReferences.containsKey(name) && DescriptorMetaInfo.isValidResAuth(ref.getAuth()) && DescriptorMetaInfo.isValidResSharingScope(ref.getSharingScope())) {
                    this.myResourceReferences.put(name, ref);
                }
                ++i;
            }
        }
    }

    public void updateResourceReference(String name) {
        ResourceRef ref;
        if (this.myResourceReferences != null && (ref = (ResourceRef)this.myResourceReferences.remove(name)) != null && ref.isValid()) {
            this.myResourceReferences.put(ref.getName(), ref);
        }
    }

    public ResourceRef[] getResourceReferences() {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readResourceReferences();
        if (this.myResourceReferences.isEmpty()) {
            return null;
        }
        Collection refs = this.myResourceReferences.values();
        return refs.toArray(new ResourceRef[refs.size()]);
    }

    public ResourceRef getResourceReference(String name) {
        if (!this.getDocument().isRecognized()) {
            return null;
        }
        this.readResourceReferences();
        return (ResourceRef)this.myResourceReferences.get(name);
    }

    public boolean canCreateResourceReference(String name, String type, String auth, String scope, String description) {
        if (!this.getDocument().isRecognized()) {
            return false;
        }
        this.readResourceReferences();
        if (DescriptorEntityImpl.isNull(name) || this.myResourceReferences.containsKey(name)) {
            return false;
        }
        if (!DescriptorMetaInfo.isValidResAuth(auth)) {
            return false;
        }
        return DescriptorMetaInfo.isValidResSharingScope(scope);
    }

    public ResourceRef createResourceReference(String name, String type, String auth, String scope, String description) {
        if (!this.canCreateResourceReference(name, type, auth, scope, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element refElement = DomUtils.createChildElement(this.getElement(), this.getEnvironmentHostOrder(), "resource-ref");
        if (description != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getResourceReferenceOrder(), "description", description);
        }
        DomUtils.setChildTextNodeValue(refElement, this.getResourceReferenceOrder(), "res-ref-name", name);
        DomUtils.setChildTextNodeValue(refElement, this.getResourceReferenceOrder(), "res-type", type);
        DomUtils.setChildTextNodeValue(refElement, this.getResourceReferenceOrder(), "res-auth", auth);
        if (scope != null) {
            DomUtils.setChildTextNodeValue(refElement, this.getResourceReferenceOrder(), "res-sharing-scope", scope);
        }
        ResourceRefImpl ref = new ResourceRefImpl(this, refElement);
        this.myResourceReferences.put(ref.getName(), ref);
        this.added(ref);
        return ref;
    }

    private boolean canCreateEjbReferenceBase(String name, String type, String linkPath, String linkTarget, String description) {
        if (!DescriptorMetaInfo.isValidEjbRefType(type)) {
            return false;
        }
        if ((linkPath = DescriptorEntityImpl.nullify(linkPath)) != null && linkPath.indexOf(35) >= 0) {
            return false;
        }
        if ((linkTarget = DescriptorEntityImpl.nullify(linkTarget)) != null && linkTarget.indexOf(35) >= 0) {
            return false;
        }
        return linkTarget != null || linkPath == null;
    }

    public abstract String[] getEjbLocalReferenceOrder();

    public abstract String[] getEjbReferenceOrder();

    public abstract String[] getResourceEnvironmentReferenceOrder();

    public abstract String[] getResourceReferenceOrder();

    public abstract String[] getEnvironmentEntryOrder();

    public abstract AccessibleBean getAccessibleBean(String var1, String var2);

    public abstract String[] getEnvironmentHostOrder();
}

