/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.AccessibleBean;
import com.tssap.j2ee.core.descriptor.DescriptorMetaInfo;
import com.tssap.j2ee.core.descriptor.EjbRefBase;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.EnvironmentHost;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

public abstract class EjbRefBaseImpl
extends DescribedDescriptorEntityImpl
implements EjbRefBase {
    public EjbRefBaseImpl(EnvironmentHost parent, Element element) {
        super((DescriptorEntityImpl)((Object)parent), element);
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getName();
        this.modify(new Runnable(){

            public void run() {
                EjbRefBaseImpl.super.delete();
                EjbRefBaseImpl.this.update(oldName);
            }
        });
    }

    public String getName() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "ejb-ref-name");
    }

    public boolean canSetName(String name) {
        if (DescriptorEntityImpl.equals(this.getName(), name)) {
            return true;
        }
        if (DescriptorEntityImpl.isNull(name)) {
            return false;
        }
        return !this.exists(name);
    }

    public void setName(String name) {
        if (!this.canSetName(name)) {
            throw new IllegalArgumentException(name);
        }
        String oldName = this.getName();
        if (DescriptorEntityImpl.equals(oldName, name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue(this.getElement(), this.getChildOrder(), "ejb-ref-name", name);
        this.update(oldName);
        this.changed(this);
    }

    public String getType() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "ejb-ref-type");
    }

    public boolean canSetType(String type) {
        return DescriptorMetaInfo.isValidEjbRefType(type);
    }

    public void setType(String type) {
        if (!this.canSetType(type)) {
            throw new IllegalArgumentException(type);
        }
        if (DescriptorEntityImpl.equals(this.getType(), type)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue(this.getElement(), this.getChildOrder(), "ejb-ref-type", type);
        this.changed(this);
    }

    public String getLinkPath() {
        String link = this.getLink();
        if (link == null) {
            return null;
        }
        int spos = link.indexOf(35);
        if (spos < 0) {
            return null;
        }
        return link.substring(0, spos);
    }

    public boolean canSetLinkPath(String path) {
        AccessibleBean bean;
        if (path != null && path.indexOf(35) >= 0) {
            return false;
        }
        String target = this.getLinkTarget();
        return !DescriptorEntityImpl.isNull(path = this.getLinkPathExt(path)) || DescriptorEntityImpl.isNull(target) || (bean = this.getEnvironmentHost().getAccessibleBean(DescriptorEntityImpl.nullify(path), target)) != null;
    }

    public void setLinkPath(String path) {
        if (!this.canSetLinkPath(path)) {
            throw new IllegalArgumentException(path);
        }
        this.setLink(this.getLink(DescriptorEntityImpl.nullify(path), this.getLinkTarget()));
    }

    public String getLinkPathExt() {
        return this.getLinkPathExt(this.getLinkPath());
    }

    public String getLinkPathExt(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(this.getDocument().getUri())) {
            return null;
        }
        return path;
    }

    public String getLinkTarget() {
        String link = this.getLink();
        if (link == null) {
            return null;
        }
        int spos = link.indexOf(35);
        if (spos < 0) {
            return link;
        }
        return link.substring(spos + 1);
    }

    public boolean canSetLinkTarget(String target) {
        AccessibleBean bean;
        if (target != null && target.indexOf(35) >= 0) {
            return false;
        }
        String path = this.getLinkPathExt();
        return !DescriptorEntityImpl.isNull(path) || DescriptorEntityImpl.isNull(target) || (bean = this.getEnvironmentHost().getAccessibleBean(DescriptorEntityImpl.nullify(path), target)) != null;
    }

    public void setLinkTarget(String target) {
        if (!this.canSetLinkTarget(target)) {
            throw new IllegalArgumentException(target);
        }
        this.setLink(this.getLink(this.getLinkPath(), DescriptorEntityImpl.nullify(target)));
    }

    private String getLink(String path, String target) {
        if (target == null) {
            return null;
        }
        if (path == null) {
            return target;
        }
        return path + '#' + target;
    }

    private String getLink() {
        return DomUtils.getChildTextNodeValue(this.getElement(), "ejb-link");
    }

    private void setLink(final String link) {
        if (DescriptorEntityImpl.equals(this.getLink(), link)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                String oldName = EjbRefBaseImpl.this.getLinkTarget();
                DomUtils.setChildTextNodeValue(EjbRefBaseImpl.this.getElement(), EjbRefBaseImpl.this.getChildOrder(), "ejb-link", link);
                EjbRefBaseImpl.this.changed(EjbRefBaseImpl.this);
                EjbRefBaseImpl.this.syncInterfaces(oldName, EjbRefBaseImpl.this.getLinkTarget());
            }
        });
    }

    protected abstract boolean exists(String var1);

    protected abstract void update(String var1);

    protected abstract void syncInterfaces(String var1, String var2);

    protected EnvironmentHost getEnvironmentHost() {
        return (EnvironmentHost)this.getParent();
    }
}

