/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.UriResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class DescriptorPlugin
extends Plugin {
    public static final String URI_RESOLVER_EP = "uriResolver";
    public static final String IMPLEMENTATION_TAG = "implementation";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String PRIORITY_ATTRIBUTE = "priority";
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static DescriptorPlugin ourInstance;

    public DescriptorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = DescriptorPlugin.getTraceDebugOption(descriptor);
        this.myDebuggingDelta = DescriptorPlugin.getDeltaDebugOption(descriptor);
    }

    public static DescriptorPlugin getDefault() {
        return ourInstance;
    }

    public static UriResolver getUriResolver() {
        IExtensionPoint extPoint = DescriptorPlugin.getDefault().getDescriptor().getExtensionPoint(URI_RESOLVER_EP);
        IExtension[] extensions = extPoint.getExtensions();
        ArrayList<IConfigurationElement> configurations = null;
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String pluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (!IMPLEMENTATION_TAG.equals(element.getName())) {
                    DescriptorPlugin.logWarning("Uri resolver extension point in plugin [" + pluginId + "] contains unknown tag: " + element.getName());
                } else {
                    String name = element.getAttribute(CLASS_ATTRIBUTE);
                    if (name == null || name.trim().length() == 0) {
                        DescriptorPlugin.logWarning("Uri resolver extension point in plugin [" + pluginId + "] has no class");
                    } else {
                        if (configurations == null) {
                            configurations = new ArrayList<IConfigurationElement>();
                        }
                        configurations.add(element);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (configurations == null || configurations.isEmpty()) {
            DescriptorPlugin.logWarning("No valid uri resolver declarations found");
            return null;
        }
        Collections.sort(configurations, URCC.getInstance());
        int i2 = configurations.size() - 1;
        while (i2 >= 0) {
            IConfigurationElement element = (IConfigurationElement)configurations.get(i2);
            try {
                UriResolver resolver = (UriResolver)element.createExecutableExtension(CLASS_ATTRIBUTE);
                if (resolver != null) {
                    DescriptorPlugin.logInfo("Using uri resolver " + resolver);
                    return resolver;
                }
            }
            catch (Exception e) {
                DescriptorPlugin.logError("Unable to instantiate uri resolver " + element.getAttribute(CLASS_ATTRIBUTE));
            }
            --i2;
        }
        return null;
    }

    public static boolean getDebugOption(IPluginDescriptor descriptor, String name) {
        String key = descriptor.getUniqueIdentifier() + name;
        String value = Platform.getDebugOption((String)key);
        return Boolean.valueOf(value);
    }

    public static boolean getTraceDebugOption(IPluginDescriptor descriptor) {
        return DescriptorPlugin.getDebugOption(descriptor, "/debug/trace");
    }

    public static boolean getDeltaDebugOption(IPluginDescriptor descriptor) {
        return DescriptorPlugin.getDebugOption(descriptor, "/debug/delta");
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        DescriptorPlugin instance = DescriptorPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        DescriptorPlugin.log(1, text);
    }

    public static void logInfo(String text, Throwable cause) {
        DescriptorPlugin instance = DescriptorPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        DescriptorPlugin.log(1, text, cause);
    }

    public static void logError(String text) {
        DescriptorPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        DescriptorPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        DescriptorPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        DescriptorPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        DescriptorPlugin instance = DescriptorPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            DescriptorPlugin.log(type, text, new Throwable());
        } else {
            DescriptorPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        DescriptorPlugin instance = DescriptorPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }

    private static class URCC
    implements Comparator {
        private static URCC ourInstance;

        private URCC() {
        }

        public int compare(Object o1, Object o2) {
            IConfigurationElement ce1 = (IConfigurationElement)o1;
            IConfigurationElement ce2 = (IConfigurationElement)o2;
            int order = this.getPriority(ce1) - this.getPriority(ce2);
            if (order != 0) {
                return order;
            }
            return this.getName(ce1).compareTo(this.getName(ce2));
        }

        private int getPriority(IConfigurationElement ce) {
            String priority = ce.getAttribute(DescriptorPlugin.PRIORITY_ATTRIBUTE);
            try {
                return Integer.valueOf(priority);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        private String getName(IConfigurationElement ce) {
            String name = ce.getAttribute(DescriptorPlugin.CLASS_ATTRIBUTE);
            if (name != null) {
                return name;
            }
            return "";
        }

        public static URCC getInstance() {
            if (ourInstance == null) {
                ourInstance = new URCC();
            }
            return ourInstance;
        }
    }
}

