/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.IDescriptorPropertyManager;
import java.util.HashMap;

public abstract class DescriptorEntityPropertyService {
    private DescriptorEntityImpl myEntity;
    private HashMap myCachedStringProperties = new HashMap();
    private HashMap myCachedBooleanProperties = new HashMap();

    public DescriptorEntityPropertyService(DescriptorEntityImpl entity) {
        this.myEntity = entity;
    }

    public boolean getBooleanValue(String propertyName) {
        Boolean value = (Boolean)this.myCachedBooleanProperties.get(propertyName);
        if (value != null) {
            return value;
        }
        boolean result = this.getSafePropertyManager(propertyName).evaluateBoolean(this.getEntity());
        this.myCachedBooleanProperties.put(propertyName, new Boolean(result));
        return result;
    }

    public boolean canSetBooleanValue(String propertyName, boolean propertyValue) {
        return this.getSafePropertyManager(propertyName).canChangeBoolean(this.getEntity(), propertyValue);
    }

    public boolean setBooleanValue(String propertyName, boolean propertyValue) {
        this.dropCache();
        boolean result = this.getSafePropertyManager(propertyName).changeBoolean(this.getEntity(), propertyValue);
        return result;
    }

    public String getStringValue(String propertyName) {
        String value = (String)this.myCachedStringProperties.get(propertyName);
        if (value != null) {
            return value;
        }
        String result = this.getSafePropertyManager(propertyName).evaluateString(this.getEntity());
        this.myCachedStringProperties.put(propertyName, result);
        return result;
    }

    public boolean canSetStringValue(String propertyName, String propertyValue) {
        return this.getSafePropertyManager(propertyName).canChangeString(this.getEntity(), propertyValue);
    }

    public boolean setStringValue(String propertyName, String propertyValue) {
        this.dropCache();
        boolean result = this.getSafePropertyManager(propertyName).changeString(this.getEntity(), propertyValue);
        return result;
    }

    protected void dropCache() {
        this.myCachedBooleanProperties.clear();
        this.myCachedStringProperties.clear();
    }

    public abstract IDescriptorPropertyManager getPropertyManager(String var1);

    public IDescriptorPropertyManager getSafePropertyManager(String propertyName) {
        IDescriptorPropertyManager result = this.getPropertyManager(propertyName);
        return result == null ? IDescriptorPropertyManager.STUB : result;
    }

    protected DescriptorEntityImpl getEntity() {
        return this.myEntity;
    }
}

