/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.internal.core.descriptor.DescriptorDocumentImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DescriptorEntityImpl
implements DescriptorEntity {
    private DescriptorEntityImpl myParent;
    private DescriptorDocumentImpl myDocument;
    private Element myElement;
    private boolean myDeleted;
    private long myIncarnationNumber;

    protected DescriptorEntityImpl(DescriptorEntityImpl parent, Element element) {
        if (parent != null) {
            this.myDocument = parent.getDocumentImpl();
            if (this.myDocument != null) {
                this.myIncarnationNumber = this.myDocument.getIncarnationNumber();
            }
        }
        this.myParent = parent;
        this.myElement = element;
    }

    public final DescriptorDocument getDocument() {
        return this.getDocumentImpl();
    }

    protected DescriptorDocumentImpl getDocumentImpl() {
        if (this.myDocument != null && this.myDocument.getIncarnationNumber() != this.getIncarnationNumber()) {
            this.myParent = null;
            this.myDocument = null;
            this.myElement = null;
        }
        return this.myDocument;
    }

    public long getIncarnationNumber() {
        return this.myIncarnationNumber;
    }

    protected void reincarnate() {
        if (this.myIncarnationNumber == Long.MAX_VALUE) {
            throw new IllegalStateException();
        }
        ++this.myIncarnationNumber;
    }

    public final DescriptorEntity getParent() {
        return this.myParent;
    }

    public Element getElement() {
        return this.myElement;
    }

    public boolean isValid() {
        if (this.myDeleted) {
            return false;
        }
        if (this.getDocument() == null) {
            return false;
        }
        if (this.getElement() == null) {
            return false;
        }
        DescriptorEntity parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.isValid();
    }

    public boolean edit(Shell shell) {
        if (!this.isValid() || !this.getDocumentImpl().edit(shell)) {
            return false;
        }
        return this.isValid();
    }

    public void modify(Runnable operation) {
        this.getDocumentImpl().modify(operation);
    }

    protected void added(DescriptorEntity entity) {
        this.getDocumentImpl().added(entity);
    }

    protected void removed(DescriptorEntity entity) {
        this.getDocumentImpl().removed(entity);
    }

    protected void changed(DescriptorEntity entity) {
        this.getDocumentImpl().changed(entity);
    }

    protected void totallyChanged(DescriptorEntity entity) {
        this.getDocumentImpl().totallyChanged(entity);
    }

    public Object getUserData(Object user) {
        return this.getDocumentImpl().getUserData(this, user);
    }

    public void setUserData(Object user, Object data) {
        this.getDocumentImpl().setUserData(this, user, data);
    }

    public String getId() {
        return DomUtils.getId(this.getElement());
    }

    public boolean canSetId(String id) {
        if (DescriptorEntityImpl.isNull(id)) {
            return true;
        }
        if (id.equals(this.getId())) {
            return true;
        }
        return !this.getDocumentImpl().isIdBound(id);
    }

    public void setId(String id) {
        if (!this.canSetId(id)) {
            throw new IllegalArgumentException();
        }
        if (DescriptorEntityImpl.equals(this.getId(), id)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.getDocumentImpl().unbindId(this.getId());
        DomUtils.setId(this.getElement(), id);
        this.getDocumentImpl().bindId(this.getId());
        this.changed(this);
    }

    public boolean canDelete() {
        return true;
    }

    public void delete() {
        this.deleteHelper();
        this.removed(this);
    }

    protected void deleteHelper() {
        if (!this.edit(null)) {
            return;
        }
        Element element = this.getElement();
        Node parent = element.getParentNode();
        parent.removeChild(element);
        this.getDocumentImpl().readIds();
        this.myDeleted = true;
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static boolean equals(boolean b1, boolean b2) {
        return b1 ? b2 : !b2;
    }

    public static boolean isNull(String s) {
        if (s == null) {
            return true;
        }
        return (s = s.trim()).length() == 0;
    }

    public static String nullify(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public static String toUpperCase1(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

