/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.DescriptorStorage;
import com.tssap.j2ee.core.descriptor.UriResolver;
import com.tssap.j2ee.core.utils.EditorUtils;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DescriptorDocumentImpl
extends DescriptorEntityImpl
implements DescriptorDocument {
    private IFile myFile;
    private long myFileModificationStamp;
    private Document myDocument;
    private DescriptorDeltaListener myDeltaDispatcher;
    private int myCommandLevel;
    private int myCdataModeLevel;
    private boolean myContentsChanged;
    private Map myIds = new HashMap();
    private Map myUserData;
    private static Integer ONE = new Integer(1);

    protected DescriptorDocumentImpl(IFile file, DescriptorDeltaListener dispatcher) {
        super(null, null);
        this.myFile = file;
        this.myDeltaDispatcher = dispatcher;
        this.readDescriptor();
    }

    protected abstract String getPublicId();

    protected abstract String getSystemId();

    protected abstract String getDtd();

    public final IFile getFile() {
        return this.myFile;
    }

    public String getUri() {
        return UriResolver.getUri(this.getFile());
    }

    protected DescriptorDocumentImpl getDocumentImpl() {
        return this;
    }

    public Element getElement() {
        if (this.myDocument == null) {
            return null;
        }
        return this.myDocument.getDocumentElement();
    }

    public boolean isRecognized() {
        return this.myDocument != null;
    }

    public boolean isValid() {
        return this.myFile != null && this.myFile.isAccessible();
    }

    public boolean canDelete() {
        return false;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public boolean edit(Shell shell) {
        if (!this.ensureSaved(false)) {
            return false;
        }
        if (this.myFile.isReadOnly()) {
            if (shell == null) {
                shell = UtilsPlugin.getActiveShell();
            }
            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.myFile}, (Object)shell);
        }
        return !this.myFile.isReadOnly();
    }

    public boolean ensureSaved(boolean allowCancel) {
        if (EditorUtils.isModified((IFile)this.myFile)) {
            int style = 196;
            if (allowCancel) {
                style |= 0x100;
            }
            MessageBox dialog = new MessageBox(DescriptorDocumentImpl.getActiveShell(), style);
            dialog.setMessage("Would you like to save the editor first?");
            int result = dialog.open();
            if (result == 64) {
                EditorUtils.saveModified((IFile)this.myFile, (boolean)false);
                this.reload();
            } else {
                return result != 256;
            }
        }
        return true;
    }

    private static Shell getActiveShell() {
        Shell result = Display.getCurrent().getActiveShell();
        if (result != null) {
            return result;
        }
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w != null && w.getShell() != null) {
            return w.getShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    public void added(DescriptorEntity entity) {
        if (this.myDeltaDispatcher != null) {
            this.myDeltaDispatcher.descriptorEntityAdded(entity);
        }
        this.propagateChanges();
    }

    public void removed(DescriptorEntity entity) {
        if (this.myDeltaDispatcher != null) {
            this.myDeltaDispatcher.descriptorEntityRemoved(entity);
        }
        this.propagateChanges();
    }

    public void changed(DescriptorEntity entity) {
        if (this.myDeltaDispatcher != null) {
            this.myDeltaDispatcher.descriptorEntityChanged(entity);
        }
        this.propagateChanges();
    }

    public void totallyChanged(DescriptorEntity entity) {
        if (this.myDeltaDispatcher != null) {
            this.myDeltaDispatcher.descriptorEntityTotallyChanged(entity);
        }
        this.propagateChanges();
    }

    private void propagateChanges() {
        this.myContentsChanged = true;
        if (this.myCommandLevel > 0) {
            return;
        }
        this.commitChanges();
    }

    private void commitChanges() {
        if (this.myDeltaDispatcher != null) {
            this.myDeltaDispatcher.commitDescriptorChanges(this);
        }
        this.writeDescriptor();
        this.myContentsChanged = false;
    }

    public void modify(Runnable operation) {
        if (operation instanceof DescriptorEntity.CdataMode) {
            if (this.myCdataModeLevel == 0 && this.myDocument != null) {
                DomUtils.registerDocumentInCdataMode(this.myDocument);
            }
            ++this.myCdataModeLevel;
        }
        ++this.myCommandLevel;
        try {
            operation.run();
            Object var3_2 = null;
            --this.myCommandLevel;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.myCommandLevel;
            if (operation instanceof DescriptorEntity.CdataMode) {
                --this.myCdataModeLevel;
                if (this.myCdataModeLevel == 0 && this.myDocument != null) {
                    DomUtils.unregisterDocumentInCdataMode(this.myDocument);
                }
            }
            if (this.myCommandLevel == 0 && this.myContentsChanged) {
                this.commitChanges();
            }
            throw throwable;
        }
        if (operation instanceof DescriptorEntity.CdataMode) {
            --this.myCdataModeLevel;
            if (this.myCdataModeLevel == 0 && this.myDocument != null) {
                DomUtils.unregisterDocumentInCdataMode(this.myDocument);
            }
        }
        if (this.myCommandLevel == 0 && this.myContentsChanged) {
            this.commitChanges();
        }
    }

    public boolean isInCdataMode() {
        return this.myCdataModeLevel > 0;
    }

    public boolean isIdBound(String id) {
        return this.myIds.get(id) != null;
    }

    public void bindId(String id) {
        if (DescriptorEntityImpl.isNull(id)) {
            return;
        }
        Integer refCount = (Integer)this.myIds.get(id);
        if (refCount == null) {
            refCount = ONE;
        } else {
            refCount = new Integer(refCount + 1);
            UtilsPlugin.logWarning((String)("Duplicate id [" + id + "]"));
        }
        this.myIds.put(id, refCount);
    }

    public void unbindId(String id) {
        if (DescriptorEntityImpl.isNull(id)) {
            return;
        }
        Integer refCount = (Integer)this.myIds.remove(id);
        if (refCount == null || refCount == 1) {
            return;
        }
        refCount = refCount == 2 ? ONE : new Integer(refCount - 1);
        this.myIds.put(id, refCount);
    }

    public void readIds() {
        this.myIds.clear();
        if (this.myDocument == null) {
            return;
        }
        this.readIds(this.myDocument.getDocumentElement());
    }

    private void readIds(Element element) {
        this.bindId(DomUtils.getId(element));
        NodeList children = element.getChildNodes();
        int i = children.getLength();
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.readIds((Element)child);
            }
            --i;
        }
    }

    public String getId() {
        if (!this.isRecognized()) {
            return null;
        }
        return super.getId();
    }

    public boolean canSetId(String id) {
        if (!this.isRecognized()) {
            return false;
        }
        return super.canSetId(id);
    }

    protected Object getUserData(DescriptorEntityImpl key, Object user) {
        if (this.myUserData == null) {
            return null;
        }
        Map dataMap = (Map)this.myUserData.get(user);
        if (dataMap == null) {
            return null;
        }
        return dataMap.get(key);
    }

    protected void setUserData(DescriptorEntityImpl key, Object user, Object data) {
        WeakHashMap<DescriptorEntityImpl, Object> dataMap;
        if (this.myUserData == null) {
            if (data == null) {
                return;
            }
            this.myUserData = new HashMap();
        }
        if ((dataMap = (WeakHashMap<DescriptorEntityImpl, Object>)this.myUserData.get(user)) == null) {
            if (data == null) {
                return;
            }
            dataMap = new WeakHashMap<DescriptorEntityImpl, Object>();
            this.myUserData.put(user, dataMap);
        }
        if (data == null) {
            dataMap.remove(key);
        } else {
            dataMap.put(key, data);
        }
    }

    public void reload() {
        this.readDescriptor();
    }

    private void readDescriptor() {
        this.reincarnate();
        this.myDocument = DescriptorStorage.readDescriptor(this.getFile(), this.getSystemId(), this.getDtd());
        this.readIds();
        this.syncFileModificationStamp();
    }

    private void writeDescriptor() {
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                DescriptorStorage.writeDescriptor(DescriptorDocumentImpl.this.myDocument, DescriptorDocumentImpl.this.getFile(), DescriptorDocumentImpl.this.getPublicId(), DescriptorDocumentImpl.this.getSystemId());
                DescriptorDocumentImpl.this.syncFileModificationStamp();
            }
        });
    }

    public boolean isFileModified() {
        return this.myFileModificationStamp != this.myFile.getModificationStamp();
    }

    private void syncFileModificationStamp() {
        this.myFileModificationStamp = this.myFile.getModificationStamp();
    }

    public abstract String getSpecVersion();
}

