/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.descriptor.DescriptorPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class DescriptorChangesTracker
extends AbstractProvider
implements DescriptorDeltaListener {
    public static final Object DELTA_KEY = "delta";
    private AbstractJ2eeDescriptorProject myJ2eeProject;
    private List myPendingChanges = new LinkedList();

    protected abstract AbstractJ2eeDescriptorProject getJ2eeProject();

    protected abstract DescriptorEntity getProvidedDescriptorEntity(DescriptorEntity var1);

    protected abstract UniqueName getUniqueName(DescriptorEntity var1);

    public void registered(Model model) {
        super.registered(model);
        this.myJ2eeProject = this.getJ2eeProject();
        if (this.myJ2eeProject != null) {
            this.myJ2eeProject.addDescriptorDeltaListener(this);
            UtilsPlugin.logInfo((String)("Descriptor delta listener added to " + this.myJ2eeProject));
        }
        UtilsPlugin.logInfo((String)("Descriptor delta provider registered in " + model));
    }

    public void unregistered(Model model) {
        if (this.myJ2eeProject != null) {
            this.myJ2eeProject.removeDescriptorDeltaListener(this);
            UtilsPlugin.logInfo((String)("Descriptor delta listener removed from " + this.myJ2eeProject));
        }
        super.unregistered(model);
        UtilsPlugin.logInfo((String)("Descriptor delta provider unregistered in " + model));
    }

    public void descriptorEntityAdded(DescriptorEntity entity) {
        this.queueDescriptorEntityChange(entity, ModelDeltaNodeKind.NEW);
    }

    public void descriptorEntityRemoved(DescriptorEntity entity) {
        this.queueDescriptorEntityChange(entity, ModelDeltaNodeKind.DELETED);
    }

    public void descriptorEntityChanged(DescriptorEntity entity) {
        this.queueDescriptorEntityChange(entity, ModelDeltaNodeKind.CHANGED);
    }

    public void descriptorEntityTotallyChanged(DescriptorEntity entity) {
        this.queueDescriptorEntityChange(entity, ModelDeltaNodeKind.TOTALLY_CHANGED);
    }

    public void commitDescriptorChanges(DescriptorDocument document) {
        DescriptorChangesTracker.fireContentsChanged(this.getModel());
    }

    protected ChangeRecord createChangeRecord(DescriptorEntity entity) {
        return new ChangeRecord();
    }

    protected final void queueDescriptorEntityChange(DescriptorEntity entity, ModelDeltaNodeKind type) {
        entity = this.getProvidedDescriptorEntity(entity);
        ChangeRecord cr = this.createChangeRecord(entity);
        cr.myType = type;
        cr.myEntity = entity;
        cr.myOldUin = (UniqueName)entity.getUserData(DELTA_KEY);
        cr.myNewUin = this.getUniqueName(entity);
        cr.myParentUin = this.getParentUin(entity);
        entity.setUserData(DELTA_KEY, cr.myNewUin);
        this.queueDescriptorEntityChange(cr);
    }

    protected final void queueDescriptorEntityChange(ChangeRecord cr) {
        DescriptorPlugin.logInfo("[dct] queue " + cr);
        if (cr == null) {
            return;
        }
        this.myPendingChanges.add(cr);
    }

    protected final Iterator getPendingChanges() {
        DescriptorPlugin.logInfo("[dct] get changes");
        Iterator pendingChanges = this.myPendingChanges.iterator();
        this.myPendingChanges = new LinkedList();
        return pendingChanges;
    }

    protected UniqueName getParentUin(DescriptorEntity entity) {
        if (entity == null) {
            return null;
        }
        if ((entity = entity.getParent()) == null) {
            return null;
        }
        if ((entity = this.getProvidedDescriptorEntity(entity)) == null) {
            return null;
        }
        UniqueName uin = (UniqueName)entity.getUserData(DELTA_KEY);
        if (uin == null) {
            UtilsPlugin.logInfo((String)("No previous uin in the parent " + entity));
            uin = this.getUniqueName(entity);
        }
        return uin;
    }

    protected static void invalidChangeRecord(ChangeRecord cr) {
        UtilsPlugin.logError((String)("Invalid change record " + cr));
    }

    protected static void fireContentsChanged(Model model) {
        model.getExtensionManager().modelContentsChanged();
    }

    public static String toString(UniqueName[] uins) {
        if (uins == null) {
            return null;
        }
        if (uins.length == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < uins.length) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(uins[i]);
            ++i;
        }
        return s.toString();
    }

    public static class ChangeRecord {
        public ModelDeltaNodeKind myType;
        public DescriptorEntity myEntity;
        public UniqueName myOldUin;
        public UniqueName myNewUin;
        public UniqueName myParentUin;

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("CR [");
            s.append(this.myType);
            s.append("] : ");
            s.append(this.myEntity);
            s.append(" ");
            s.append(this.myOldUin);
            s.append(" -> ");
            s.append(this.myNewUin);
            s.append(" in ");
            s.append(this.myParentUin);
            return s.toString();
        }
    }
}

