/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.StringDescriptorPropertyManager;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

public class AsChildTagStringPropertyManager
extends StringDescriptorPropertyManager {
    private String myTagName;
    private String[] myChildOrder;
    private boolean myDoesNullDelete;

    public AsChildTagStringPropertyManager(String tagName, String[] childOrder) {
        this(tagName, childOrder, true);
    }

    public AsChildTagStringPropertyManager(String tagName, String[] childOrder, boolean nullDeletes) {
        this.myTagName = tagName;
        this.myChildOrder = childOrder;
        this.myDoesNullDelete = nullDeletes;
    }

    public String evaluateString(DescriptorEntityImpl entity) {
        if (!entity.getDocument().isRecognized()) {
            return null;
        }
        Element element = this.getElement(entity, false);
        if (element == null) {
            return null;
        }
        String result = DomUtils.getChildTextNodeValue(element, this.myTagName);
        return result;
    }

    public boolean canChangeString(DescriptorEntityImpl entity, String val) {
        return entity.getDocument().isRecognized();
    }

    public boolean changeString(DescriptorEntityImpl entity, String val) {
        if (!this.canChangeString(entity, val)) {
            throw new IllegalArgumentException(val);
        }
        String cur = this.evaluateString(entity);
        if (AsChildTagStringPropertyManager.equals(val, cur)) {
            return false;
        }
        if (!entity.edit(null)) {
            return false;
        }
        this.doChangeString(entity, val);
        return true;
    }

    protected void doChangeString(DescriptorEntityImpl entity, String val) {
        if (val == null && this.myDoesNullDelete) {
            DomUtils.removeChildNodes(this.getElement(entity, true), this.myTagName);
        } else {
            DomUtils.setChildTextNodeValue(this.getElement(entity, true), this.myChildOrder, this.myTagName, val);
        }
    }

    protected static final boolean equals(String one, String another) {
        if (one == another) {
            return true;
        }
        return one != null && one.equals(another);
    }

    protected Element getElement(DescriptorEntityImpl entity, boolean create) {
        return entity.getElement();
    }
}

