/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.internal.core.descriptor.BooleanDescriptorPropertyManager;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

public class AsChildTagBooleanPropertyManager
extends BooleanDescriptorPropertyManager {
    private String[] myChildOrder;
    private String myTagName;
    private String myTrue;
    private String myFalse;

    public AsChildTagBooleanPropertyManager(String tagName, String[] childOrder) {
        this(tagName, childOrder, Boolean.TRUE.toString(), null);
    }

    public AsChildTagBooleanPropertyManager(String tagName, String[] childOrder, String trueRepresentation, String falseRepresentation) {
        this.myTagName = tagName;
        this.myChildOrder = childOrder;
        this.myTrue = trueRepresentation;
        this.myFalse = falseRepresentation;
    }

    public boolean evaluateBoolean(DescriptorEntityImpl entity) {
        if (!entity.getDocument().isRecognized()) {
            return false;
        }
        Element element = this.getElement(entity, false);
        if (element == null) {
            return false;
        }
        String result = DomUtils.getChildTextNodeValue(element, this.myTagName);
        return this.myTrue.equals(result);
    }

    public boolean canChangeBoolean(DescriptorEntityImpl entity, boolean val) {
        return entity.getDocument().isRecognized();
    }

    public boolean changeBoolean(DescriptorEntityImpl entity, boolean val) {
        if (!this.canChangeBoolean(entity, val)) {
            Boolean temp = new Boolean(val);
            throw new IllegalArgumentException(temp.toString());
        }
        boolean cur = this.evaluateBoolean(entity);
        if (val == cur) {
            return false;
        }
        if (!entity.edit(null)) {
            return false;
        }
        this.doChangeBoolean(entity, val);
        return true;
    }

    protected void doChangeBoolean(DescriptorEntityImpl entity, boolean val) {
        String textVal;
        String string = textVal = val ? this.myTrue : this.myFalse;
        if (textVal == null) {
            DomUtils.removeChildNodes(this.getElement(entity, true), this.myTagName);
        } else {
            DomUtils.setChildTextNodeValue(this.getElement(entity, true), this.myChildOrder, this.myTagName, textVal);
        }
    }

    protected Element getElement(DescriptorEntityImpl entity, boolean create) {
        return entity.getElement();
    }
}

