/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import com.tssap.selena.model.util.extension.AbstractProvider;
import com.tssap.selena.model.util.various.DeltaDumper;

public abstract class AbstractDeltaProvider
extends AbstractProvider
implements DeltaTreeProvider,
DescriptorDeltaListener {
    public static final Object DELTA_KEY = "delta";
    public static final Object DELTA_NODE_KEY = "deltaNode";
    public static final Object DELTA_LINK_KEY = "deltaLink";
    private RootModelDeltaNode myRoot;
    private AbstractJ2eeDescriptorProject myJ2eeProject;

    public void registered(Model model) {
        super.registered(model);
        this.myJ2eeProject = this.getJ2eeProject();
        if (this.myJ2eeProject != null) {
            this.myJ2eeProject.addDescriptorDeltaListener(this);
            UtilsPlugin.logInfo((String)("Descriptor delta listener added to " + this.myJ2eeProject));
        }
        this.getModelChanges();
        UtilsPlugin.logInfo((String)("Descriptor delta provider registered in " + model));
    }

    public void unregistered(Model model) {
        if (this.myJ2eeProject != null) {
            this.myJ2eeProject.removeDescriptorDeltaListener(this);
            UtilsPlugin.logInfo((String)("Descriptor delta listener removed from " + this.myJ2eeProject));
        }
        super.unregistered(model);
        UtilsPlugin.logInfo((String)("Descriptor delta provider unregistered in " + model));
    }

    public ModelDeltaNode getModelChanges() {
        RootModelDeltaNode prevRoot = this.myRoot;
        this.myRoot = new RootModelDeltaNode(this.getModel());
        if (prevRoot != null && UtilsPlugin.getDefault().isDebuggingDelta()) {
            System.err.println("################ [descriptor delta] ################");
            DeltaDumper.dumpDelta((ModelDeltaNode)prevRoot);
        }
        return prevRoot;
    }

    protected final RootModelDeltaNode getRoot() {
        return this.myRoot;
    }

    protected static void fireContentsChanged(Model model) {
        model.getExtensionManager().modelContentsChanged();
    }

    protected DefaultModelDeltaNode addDeltaNode(Model model, UniqueName parentUin, UniqueName uin, ModelDeltaNodeKind kind) {
        return this.addDeltaNode(model, parentUin, uin, null, kind);
    }

    protected DefaultModelDeltaNode addDeltaNode(Model model, final UniqueName parentUin, UniqueName uin, final UniqueName originalUin, ModelDeltaNodeKind kind) {
        UtilsPlugin.logInfo((String)("Adding delta [" + kind + "] for [" + uin + "] with parent [" + parentUin + "]"));
        DefaultModelDeltaNode node = new DefaultModelDeltaNode(model, uin, kind){

            public UniqueName getParentUniqueName() {
                if (parentUin != null) {
                    return parentUin;
                }
                return super.getParentUniqueName();
            }

            public UniqueName getOriginalElementUniqueName() {
                if (originalUin != null) {
                    return originalUin;
                }
                return super.getOriginalElementUniqueName();
            }

            public boolean isEmpty() {
                return false;
            }
        };
        if (parentUin != null) {
            this.myRoot.addDeltaNode((TreeModelDeltaNode)node);
        } else {
            UtilsPlugin.logInfo((String)"Delta not added since parent is unknown (it may be deleted)");
        }
        return node;
    }

    protected UniqueName getParentUin(DescriptorEntity entity) {
        if ((entity = entity.getParent()) == null) {
            return null;
        }
        if ((entity = this.getProvidedDescriptorEntity(entity)) == null) {
            return null;
        }
        UniqueName uin = (UniqueName)entity.getUserData(DELTA_KEY);
        if (uin == null) {
            UtilsPlugin.logInfo((String)("No previous uin in the parent " + entity));
            uin = this.getUniqueName(entity);
        }
        return uin;
    }

    protected void doTotalUpdate(DescriptorEntity entity) {
        block1: {
            UniqueName uin;
            do {
                if ((entity = entity.getParent()) != null) continue;
                this.myRoot.makeTotallyChanged();
                break block1;
            } while ((uin = this.getUniqueName(entity)) == null);
            this.addDeltaNode(this.getModel(), this.getParentUin(entity), uin, ModelDeltaNodeKind.TOTALLY_CHANGED);
        }
    }

    public void descriptorEntityAdded(DescriptorEntity entity) {
        if (this.getModel() == null) {
            UtilsPlugin.logWarning((String)("Descriptor entity [" + entity + "] added but delta provider is not registered; ignoring"));
            return;
        }
        entity = this.getProvidedDescriptorEntity(entity);
        UniqueName uin = this.getUniqueName(entity);
        UniqueName originalUin = (UniqueName)entity.getUserData(DELTA_KEY);
        if (uin == null) {
            UtilsPlugin.logInfo((String)("Unable to create uin for the " + entity));
            this.doTotalUpdate(entity);
            return;
        }
        entity.setUserData(DELTA_KEY, uin);
        this.addDeltaNode(this.getModel(), this.getParentUin(entity), uin, originalUin, ModelDeltaNodeKind.NEW);
    }

    public void descriptorEntityRemoved(DescriptorEntity entity) {
        if (this.getModel() == null) {
            UtilsPlugin.logWarning((String)("Descriptor entity [" + entity + "] removed but delta provider is not registered; ignoring"));
            return;
        }
        entity = this.getProvidedDescriptorEntity(entity);
        UniqueName uin = this.getUniqueName(entity);
        UniqueName originalUin = (UniqueName)entity.getUserData(DELTA_KEY);
        if (uin == null && (uin = (UniqueName)entity.getUserData(DELTA_KEY)) == null) {
            UtilsPlugin.logInfo((String)("Unable to create/retrieve previous uin for the " + entity));
            this.doTotalUpdate(entity);
            return;
        }
        this.addDeltaNode(this.getModel(), this.getParentUin(entity), uin, originalUin, ModelDeltaNodeKind.DELETED);
    }

    private void descriptorEntityChangesHandler(DescriptorEntity entity, ModelDeltaNodeKind kind) {
        if (this.getModel() == null) {
            UtilsPlugin.logWarning((String)("Descriptor entity [" + entity + "] changed [" + kind + "] but delta provider is not registered; ignoring"));
            return;
        }
        entity = this.getProvidedDescriptorEntity(entity);
        UniqueName uin = this.getUniqueName(entity);
        UniqueName prevUin = (UniqueName)entity.getUserData(DELTA_KEY);
        if (uin == null) {
            UtilsPlugin.logInfo((String)("Unable to create uin for the " + entity));
            if (prevUin != null) {
                UtilsPlugin.logInfo((String)("Previous uin available; deleting " + entity));
                this.addDeltaNode(this.getModel(), this.getParentUin(entity), prevUin, ModelDeltaNodeKind.DELETED);
                return;
            }
            this.doTotalUpdate(entity);
            return;
        }
        if (prevUin == null) {
            UtilsPlugin.logInfo((String)("No previous uin in the " + entity));
            entity.setUserData(DELTA_KEY, uin);
            this.addDeltaNode(this.getModel(), this.getParentUin(entity), uin, kind);
        } else if (prevUin.equals(uin)) {
            this.addDeltaNode(this.getModel(), this.getParentUin(entity), uin, kind);
        } else {
            entity.setUserData(DELTA_KEY, uin);
            DefaultModelDeltaNode node = this.addDeltaNode(this.getModel(), this.getParentUin(entity), uin, prevUin, ModelDeltaNodeKind.NEW);
            this.addDeltaNode(this.getModel(), node.getParentUniqueName(), prevUin, uin, ModelDeltaNodeKind.DELETED);
        }
    }

    public void descriptorEntityChanged(DescriptorEntity entity) {
        this.descriptorEntityChangesHandler(entity, ModelDeltaNodeKind.CHANGED);
    }

    public void descriptorEntityTotallyChanged(DescriptorEntity entity) {
        this.descriptorEntityChangesHandler(entity, ModelDeltaNodeKind.TOTALLY_CHANGED);
    }

    public void commitDescriptorChanges(DescriptorDocument document) {
        AbstractDeltaProvider.fireContentsChanged(this.getModel());
    }

    protected abstract AbstractJ2eeDescriptorProject getJ2eeProject();

    protected abstract UniqueName getUniqueName(DescriptorEntity var1);

    protected abstract DescriptorEntity getProvidedDescriptorEntity(DescriptorEntity var1);
}

