/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.descriptor;

import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.descriptor.DescriptorChangesTracker;
import com.tssap.j2ee.internal.core.descriptor.DescriptorRootModelDeltaNode;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import com.tssap.selena.model.util.various.DeltaDumper;
import java.util.Enumeration;
import java.util.Iterator;

public abstract class AbstractDeferredDeltaProvider
extends DescriptorChangesTracker
implements DeltaTreeProvider {
    public ModelDeltaNode getModelChanges() {
        DescriptorRootModelDeltaNode deltaRoot = new DescriptorRootModelDeltaNode(this.getModel());
        Iterator pendingChanges = this.getPendingChanges();
        while (pendingChanges.hasNext()) {
            DescriptorChangesTracker.ChangeRecord cr = (DescriptorChangesTracker.ChangeRecord)pendingChanges.next();
            if (cr.myType.isNew()) {
                this.handleAddedDescriptorEntity(deltaRoot, cr);
                continue;
            }
            if (cr.myType.isDeleted()) {
                this.handleRemovedDescriptorEntity(deltaRoot, cr);
                continue;
            }
            if (cr.myType.isTotallyChanged()) {
                this.handleTotallyChangedDescriptorEntity(deltaRoot, cr);
                continue;
            }
            if (!cr.myType.isChanged()) continue;
            this.handleChangedDescriptorEntity(deltaRoot, cr);
        }
        if (UtilsPlugin.getDefault().isDebuggingDelta()) {
            System.err.println("################ [descriptor delta] ################");
            DeltaDumper.dumpDelta((ModelDeltaNode)deltaRoot);
        }
        return deltaRoot;
    }

    protected void handleAddedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (this.getModel() == null) {
            UtilsPlugin.logWarning((String)("Descriptor entity [" + entity + "] added but delta provider is not registered; ignoring"));
            return;
        }
        UniqueName originalUin = cr.myOldUin;
        UniqueName uin = cr.myNewUin;
        if (uin == null) {
            uin = this.getUniqueName(entity);
        }
        if (uin == null) {
            UtilsPlugin.logInfo((String)("Unable to create uin for the " + entity));
            this.doTotalUpdate(deltaRoot, entity);
            return;
        }
        UniqueName parentUin = cr.myParentUin;
        if (parentUin == null) {
            parentUin = this.getParentUin(entity);
        }
        this.addDeltaNode(deltaRoot, this.getModel(), parentUin, uin, originalUin, ModelDeltaNodeKind.NEW);
    }

    protected void handleRemovedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (this.getModel() == null) {
            UtilsPlugin.logWarning((String)("Descriptor entity [" + entity + "] removed but delta provider is not registered; ignoring"));
            return;
        }
        UniqueName originalUin = cr.myOldUin;
        UniqueName uin = cr.myNewUin;
        if (uin == null) {
            uin = this.getUniqueName(entity);
        }
        if (uin == null && (uin = originalUin) == null) {
            UtilsPlugin.logInfo((String)("Unable to create/retrieve previous uin for the " + entity));
            this.doTotalUpdate(deltaRoot, entity);
            return;
        }
        UniqueName parentUin = cr.myParentUin;
        if (parentUin == null) {
            parentUin = this.getParentUin(entity);
        }
        this.addDeltaNode(deltaRoot, this.getModel(), parentUin, uin, originalUin, ModelDeltaNodeKind.DELETED);
    }

    protected void handleChangedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        this.handleChangedDescriptorEntityHelper(deltaRoot, cr, ModelDeltaNodeKind.CHANGED);
    }

    protected void handleTotallyChangedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        Entity entity;
        this.handleChangedDescriptorEntityHelper(deltaRoot, cr, ModelDeltaNodeKind.TOTALLY_CHANGED);
        if (cr.myEntity instanceof DescriptorDocument && (entity = this.getModel().findEntity(cr.myNewUin)) != null) {
            this.addAllLinksDelta(deltaRoot, entity);
        }
    }

    private void handleChangedDescriptorEntityHelper(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr, ModelDeltaNodeKind kind) {
        UniqueName parentUin;
        DescriptorEntity entity = cr.myEntity;
        if (this.getModel() == null) {
            UtilsPlugin.logWarning((String)("Descriptor entity [" + entity + "] changed [" + kind + "] but delta provider is not registered; ignoring"));
            return;
        }
        UniqueName prevUin = cr.myOldUin;
        UniqueName uin = cr.myNewUin;
        if (uin == null) {
            uin = this.getUniqueName(entity);
        }
        if ((parentUin = cr.myParentUin) == null) {
            parentUin = this.getParentUin(entity);
        }
        if (uin == null) {
            UtilsPlugin.logInfo((String)("Unable to create uin for the " + entity));
            if (prevUin != null) {
                UtilsPlugin.logInfo((String)("Previous uin available; deleting " + entity));
                this.addDeltaNode(deltaRoot, this.getModel(), parentUin, prevUin, ModelDeltaNodeKind.DELETED);
                return;
            }
            this.doTotalUpdate(deltaRoot, entity);
            return;
        }
        if (prevUin == null) {
            UtilsPlugin.logInfo((String)("No previous uin in the " + entity));
            this.addDeltaNode(deltaRoot, this.getModel(), parentUin, uin, kind);
        } else if (prevUin.equals(uin)) {
            this.addDeltaNode(deltaRoot, this.getModel(), parentUin, uin, kind);
        } else {
            DefaultModelDeltaNode node = this.addDeltaNode(deltaRoot, this.getModel(), parentUin, uin, prevUin, ModelDeltaNodeKind.NEW);
            this.addDeltaNode(deltaRoot, this.getModel(), node.getParentUniqueName(), prevUin, uin, ModelDeltaNodeKind.DELETED);
        }
    }

    protected void doTotalUpdate(RootModelDeltaNode deltaRoot, DescriptorEntity entity) {
        block1: {
            UniqueName uin;
            do {
                if ((entity = entity.getParent()) != null) continue;
                deltaRoot.makeTotallyChanged();
                break block1;
            } while ((uin = this.getUniqueName(entity)) == null);
            this.addDeltaNode(deltaRoot, this.getModel(), this.getParentUin(entity), uin, ModelDeltaNodeKind.TOTALLY_CHANGED);
        }
    }

    protected DefaultModelDeltaNode addDeltaNode(RootModelDeltaNode deltaRoot, Model model, UniqueName parentUin, UniqueName uin, ModelDeltaNodeKind kind) {
        return this.addDeltaNode(deltaRoot, model, parentUin, uin, null, kind);
    }

    protected DefaultModelDeltaNode addDeltaNode(RootModelDeltaNode deltaRoot, Model model, UniqueName parentUin, UniqueName uin, UniqueName originalUin, ModelDeltaNodeKind kind) {
        UtilsPlugin.logInfo((String)("Adding delta [" + kind + "] for [" + uin + "] with parent [" + parentUin + "]"));
        DescriptorDeltaNode node = new DescriptorDeltaNode(model, parentUin, uin, originalUin, kind);
        parentUin = node.getParentUniqueName();
        if (parentUin != null) {
            TreeModelDeltaNode xnode = deltaRoot.addDeltaNode((TreeModelDeltaNode)node);
            if (originalUin != null && xnode instanceof DescriptorDeltaNode) {
                ((DescriptorDeltaNode)xnode).setOriginalElementUniqueName(originalUin);
            }
            if (xnode != null && xnode.isNew()) {
                this.addInboundLinksDelta(deltaRoot, model, parentUin, uin);
            }
        } else {
            UtilsPlugin.logInfo((String)"Delta not added since parent is unknown (it may be deleted)");
        }
        return node;
    }

    /*
     * Unable to fully structure code
     */
    public final void addInboundLinksDelta(RootModelDeltaNode deltaRoot, Model model, UniqueName parentUin, UniqueName uin) {
        parent = model.findEntity(parentUin);
        if (parent == null) {
            return;
        }
        siblings = parent.childEntities();
        if (siblings != null) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            sibling = siblings.next();
            if (sibling != null && !sibling.getUniqueName().equals(uin) && (children = sibling.childEntities()) != null) ** GOTO lbl18
            continue;
lbl-1000:
            // 1 sources

            {
                child = children.next();
                if (child != null && (participants = child.participants("Supplier")) != null) ** GOTO lbl17
                continue;
lbl-1000:
                // 1 sources

                {
                    participant = participants.next();
                    if (participant == null || !participant.getUniqueName().equals(uin)) continue;
                    this.addDeltaNode(deltaRoot, model, sibling.getUniqueName(), child.getUniqueName(), ModelDeltaNodeKind.CHANGED);
lbl17:
                    // 3 sources

                    ** while (participants.hasMoreElements())
                }
lbl18:
                // 3 sources

                ** while (children.hasMoreElements())
            }
lbl19:
            // 3 sources

            ** while (siblings.hasMoreElements())
        }
lbl20:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public final void addAllLinksDelta(RootModelDeltaNode deltaRoot, Entity entity) {
        dchildren = entity.childEntities();
        if (dchildren != null) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            dchild = dchildren.next();
            if (dchild != null && (children = dchild.childEntities()) != null) ** GOTO lbl11
            continue;
lbl-1000:
            // 1 sources

            {
                child = children.next();
                if (child == null || (participants = child.participants("Supplier")) == null || !participants.hasMoreElements()) continue;
                this.addDeltaNode(deltaRoot, entity.getModel(), dchild.getUniqueName(), child.getUniqueName(), ModelDeltaNodeKind.CHANGED);
lbl11:
                // 3 sources

                ** while (children.hasMoreElements())
            }
lbl12:
            // 3 sources

            ** while (dchildren.hasMoreElements())
        }
lbl13:
        // 1 sources

    }

    private static class DescriptorDeltaNode
    extends DefaultModelDeltaNode {
        private UniqueName myParentUin;
        private UniqueName myOriginalUin;
        private ModelDeltaNodeKind myKind;

        public DescriptorDeltaNode(Model model, UniqueName parentUin, UniqueName uin, UniqueName originalUin, ModelDeltaNodeKind kind) {
            super(model, uin, kind);
            this.myParentUin = parentUin;
            this.myOriginalUin = originalUin;
            this.myKind = kind;
        }

        public UniqueName getParentUniqueName() {
            if (this.myParentUin != null) {
                return this.myParentUin;
            }
            return super.getParentUniqueName();
        }

        public UniqueName getOriginalElementUniqueName() {
            if (this.myOriginalUin != null) {
                return this.myOriginalUin;
            }
            return super.getOriginalElementUniqueName();
        }

        public void setOriginalElementUniqueName(UniqueName uin) {
            this.myOriginalUin = uin;
        }

        public boolean isEmpty() {
            return false;
        }

        public void mergeModelDeltaNodes(ModelDeltaNode modelDeltaNode) {
            if (this.getElementUniqueName().equals(modelDeltaNode.getElementUniqueName())) {
                ModelDeltaNodeKind otherKind = ModelDeltaNodeKind.guess((ModelDeltaNode)modelDeltaNode);
                this.myKind = ModelDeltaNodeKind.DELETED == this.myKind && ModelDeltaNodeKind.NEW == otherKind ? ModelDeltaNodeKind.TOTALLY_CHANGED : this.myKind.merge(otherKind);
            }
            Enumeration newChildren = modelDeltaNode.changedChildren();
            while (newChildren.hasMoreElements()) {
                TreeModelDeltaNode node;
                ModelDeltaNode child = (ModelDeltaNode)newChildren.nextElement();
                if (!(child instanceof TreeModelDeltaNode) || (node = this.addChild((TreeModelDeltaNode)child)) == child) continue;
                node.mergeModelDeltaNodes(child);
            }
        }

        public boolean isNew() {
            return this.myKind.isNew();
        }

        public boolean isChanged() {
            return this.myKind.isChanged();
        }

        public boolean isDeleted() {
            return this.myKind.isDeleted();
        }

        public boolean isTotallyChanged() {
            return this.myKind.isTotallyChanged();
        }
    }
}

