/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.descriptor;

import com.tssap.j2ee.internal.core.descriptor.DescriptorPlugin;
import com.tssap.j2ee.internal.core.util.LoggingErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorStorage {
    private static ErrorHandler ourErrorHandler;

    public static Document readDescriptor(final IFile file, String systemId, final String dtd) {
        final String id = systemId;
        return DescriptorStorage.readDescriptor(file, new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (dtd == null || dtd.trim().length() == 0) {
                    return null;
                }
                if (!id.equals(systemId)) {
                    DescriptorPlugin.logWarning("System ID does not match the expected string '" + id + "' for file " + file.getFullPath());
                }
                return new InputSource(new StringReader(dtd));
            }
        }, null);
    }

    public static Document readDescriptor(IFile file, EntityResolver resolver) {
        return DescriptorStorage.readDescriptor(file, resolver, null);
    }

    public static Document readDescriptor(IFile file, EntityResolver resolver, ErrorHandler handler) {
        Document document;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(false);
            dbf.setExpandEntityReferences(false);
            dbf.setNamespaceAware(false);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (resolver != null) {
                db.setEntityResolver(resolver);
            } else {
                DescriptorPlugin.logInfo("Entity resolver is not specified");
            }
            if (handler == null) {
                handler = DescriptorStorage.getErrorHandler();
            }
            db.setErrorHandler(handler);
            document = db.parse(file.getContents());
        }
        catch (Throwable t) {
            document = null;
            DescriptorPlugin.logWarning("Unable to parse descriptor file [" + file.getFullPath() + "] " + t);
        }
        return document;
    }

    public static void writeDescriptor(Document document, IFile file, String publicId, String systemId) {
        try {
            ByteArrayOutputStream temporaryStream = new ByteArrayOutputStream();
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)temporaryStream, outputFormat);
            serializer.serialize(document);
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(temporaryStream.toByteArray()), true, true, null);
            } else {
                file.create((InputStream)new ByteArrayInputStream(temporaryStream.toByteArray()), false, null);
            }
        }
        catch (Throwable t) {
            DescriptorPlugin.logError("Unable to serialize descriptor file [" + file.getFullPath() + "] " + t);
        }
    }

    public static ErrorHandler getErrorHandler() {
        if (ourErrorHandler == null) {
            ourErrorHandler = new LoggingErrorHandler();
        }
        return ourErrorHandler;
    }
}

