/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.descriptor;

import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.AbstractJ2eeProject;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractJ2eeDescriptorProject
extends AbstractJ2eeProject
implements DescriptorDeltaListener {
    public static final String FIXED_PROPERTY = "fixed";
    private List myDescriptorDeltaListeners;
    private boolean myDescriptorDeltaFired;

    public void addDescriptorDeltaListener(DescriptorDeltaListener listener) {
        if (this.myDescriptorDeltaListeners == null) {
            this.myDescriptorDeltaListeners = new ArrayList();
        }
        this.myDescriptorDeltaListeners.add(listener);
    }

    public void removeDescriptorDeltaListener(DescriptorDeltaListener listener) {
        if (this.myDescriptorDeltaListeners == null) {
            return;
        }
        this.myDescriptorDeltaListeners.remove(listener);
        if (this.myDescriptorDeltaListeners.isEmpty()) {
            this.myDescriptorDeltaListeners = null;
        }
    }

    protected boolean hasDescriptorDeltaListeners() {
        return this.myDescriptorDeltaListeners != null && !this.myDescriptorDeltaListeners.isEmpty();
    }

    public void descriptorEntityAdded(DescriptorEntity entity) {
        this.myDescriptorDeltaFired = true;
        if (this.myDescriptorDeltaListeners == null) {
            return;
        }
        int i = this.myDescriptorDeltaListeners.size() - 1;
        while (i >= 0) {
            try {
                ((DescriptorDeltaListener)this.myDescriptorDeltaListeners.get(i)).descriptorEntityAdded(entity);
            }
            catch (Throwable cause) {
                UtilsPlugin.logError((String)"Failed to process descriptor delta event", (Throwable)cause);
            }
            --i;
        }
    }

    public void descriptorEntityRemoved(DescriptorEntity entity) {
        this.myDescriptorDeltaFired = true;
        if (this.myDescriptorDeltaListeners == null) {
            return;
        }
        int i = this.myDescriptorDeltaListeners.size() - 1;
        while (i >= 0) {
            try {
                ((DescriptorDeltaListener)this.myDescriptorDeltaListeners.get(i)).descriptorEntityRemoved(entity);
            }
            catch (Throwable cause) {
                UtilsPlugin.logError((String)"Failed to process descriptor delta event", (Throwable)cause);
            }
            --i;
        }
    }

    public void descriptorEntityChanged(DescriptorEntity entity) {
        this.myDescriptorDeltaFired = true;
        if (this.myDescriptorDeltaListeners == null) {
            return;
        }
        int i = this.myDescriptorDeltaListeners.size() - 1;
        while (i >= 0) {
            try {
                ((DescriptorDeltaListener)this.myDescriptorDeltaListeners.get(i)).descriptorEntityChanged(entity);
            }
            catch (Throwable cause) {
                UtilsPlugin.logError((String)"Failed to process descriptor delta event", (Throwable)cause);
            }
            --i;
        }
    }

    public void descriptorEntityTotallyChanged(DescriptorEntity entity) {
        this.myDescriptorDeltaFired = true;
        if (this.myDescriptorDeltaListeners == null) {
            return;
        }
        int i = this.myDescriptorDeltaListeners.size() - 1;
        while (i >= 0) {
            try {
                ((DescriptorDeltaListener)this.myDescriptorDeltaListeners.get(i)).descriptorEntityTotallyChanged(entity);
            }
            catch (Throwable cause) {
                UtilsPlugin.logError((String)"Failed to process descriptor delta event", (Throwable)cause);
            }
            --i;
        }
    }

    public void commitDescriptorChanges(DescriptorDocument document) {
        this.myDescriptorDeltaFired = true;
        if (this.myDescriptorDeltaListeners == null) {
            return;
        }
        int i = this.myDescriptorDeltaListeners.size() - 1;
        while (i >= 0) {
            try {
                ((DescriptorDeltaListener)this.myDescriptorDeltaListeners.get(i)).commitDescriptorChanges(document);
            }
            catch (Throwable cause) {
                UtilsPlugin.logError((String)"Failed to process descriptor delta event", (Throwable)cause);
            }
            --i;
        }
    }

    protected boolean isDescriptorDeltaFired() {
        return this.myDescriptorDeltaFired;
    }

    protected void clearDescriptorDeltaFired() {
        this.myDescriptorDeltaFired = false;
    }

    public static String getFixedLocation(Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        String value = UtilsPlugin.getProperty((IPluginDescriptor)plugin.getDescriptor(), (String)FIXED_PROPERTY);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }
}

