/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.structureeditor;

import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.structureeditor.StructureFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fieldwizard.TableEditRowActionDelegate;
import com.sap.dictionary.tools.tableeditor.fieldwizard.TableRenameColumnActionDelegate;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTypeInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.ArrayList;
import java.util.Enumeration;

public class StructureFieldsTableModel
extends AbstractTableFieldsTableModel {
    protected static Object[] columnNames = new Object[]{" ", "Element Name", "Key", "Simple Type Package", "Simple Type", "Built-In Type", "Length", "Decimals", "Not Null", "DB Default", "Description"};
    private DtGeneralStructure mDtDbTable;

    public StructureFieldsTableModel(StructureFieldsSectionForm form, DtDictionaryRoot dtDictionaryRoot, boolean advancedPermissions, DtGeneralStructure dtTable) {
        super((AbstractTableFieldsSectionForm)form, dtDictionaryRoot, advancedPermissions, (DtStructure)dtTable, columnNames);
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.advancedPermissions = advancedPermissions;
        this.mDtDbTable = dtTable;
    }

    protected void editRow(int index) {
        int numOfRows = this.getRowCount();
        if (index < 0 || index >= numOfRows) {
            TableMessageHandler.sendErrorMessage((String)"Edit Column", (String)"Select a valid row");
            return;
        }
        TableEditRowActionDelegate tableEditRowActionDelegate = new TableEditRowActionDelegate();
        String fieldName = (String)this.getValueAt(index, 1);
        if (TableUtil.stringIsEmpty((String)fieldName)) {
            TableMessageHandler.sendErrorMessage((String)"Edit Structure Element", (String)MessagePool.getMessage((String)"Select a valid row", (String)Integer.toString(index)));
            return;
        }
        DatabaseEnum[] selectedDbs = this.getSelectedDbSystems();
        DtDbTypeInfo[] info = ((DtField)this.mDtDbTable.getStructureElement(fieldName)).getTypeInfos();
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        if (info.length > 0) {
            int i = 0;
            while (i < info.length) {
                DtTypeInfoForDatabase typeInfo = new DtTypeInfoForDatabase(info[i].getDatabase().toString(), info[i].getJdbcTypeName(), info[i].getDatabaseTypeName());
                list.add(typeInfo);
                ++i;
            }
        }
        tableEditRowActionDelegate.run((AbstractTableFieldsTableModel)this, 'E', index, this.mDtDictionaryRoot, this.advancedPermissions, selectedDbs, list, false, "Element name:", "Edit Structure Element", "Change the attributes of the structure element", "NEW_ELEMENT", this.mDtDbTable.isReadOnly());
    }

    protected void renameColumn(int index) {
        int numOfRows = this.getRowCount();
        if (index < 0 || index >= numOfRows) {
            TableMessageHandler.sendErrorMessage((String)"Rename Structure Element", (String)"Select a valid row");
            return;
        }
        String fieldName = (String)this.getValueAt(index, 1);
        if (TableUtil.stringIsEmpty((String)fieldName)) {
            TableMessageHandler.sendErrorMessage((String)"Rename Structure Element", (String)MessagePool.getMessage((String)"Select a valid row", (String)Integer.toString(index)));
            return;
        }
        TableRenameColumnActionDelegate tableRenameColumnActionDelegate = new TableRenameColumnActionDelegate();
        tableRenameColumnActionDelegate.run((AbstractTableFieldsTableModel)this, index, "Rename Structure Element", "Enter the new element name", "Old element name:", "New element name:", false);
    }

    protected Object[] fillRow(DtStructureElement dtStructureElement) throws LoadException {
        DtField dtField = null;
        DtDataType dtDataType = null;
        DtSimpleType dtSimpleType = null;
        Object dtPrimaryKey = null;
        Object[] attributes = new Object[11];
        Object[] row = new Object[11];
        if (!(dtStructureElement instanceof DtField)) {
            throw new LoadException("DtStructure: Only fields are supported");
        }
        System.arraycopy(AbstractTableFieldsTableModel.emptyRow, 0, row, 0, 11);
        dtField = (DtField)dtStructureElement;
        row[1] = dtField.getName();
        if (dtField.getBuiltInType() == null) {
            dtDataType = dtField.getReferencedType();
            if (dtDataType != null) {
                row[4] = dtDataType.getName();
            }
        } else {
            dtDataType = null;
        }
        if (dtDataType != null && !(dtDataType instanceof DtSimpleType)) {
            throw new LoadException("Referenced type is not a simple type");
        }
        if (dtDataType instanceof DtSimpleType && dtDataType != null) {
            dtSimpleType = (DtSimpleType)dtDataType;
            attributes = TableUtil.getSimpleTypeAttributes((DtSimpleType)dtSimpleType);
            row[3] = attributes[3];
            row[5] = attributes[5];
            row[6] = attributes[6];
            row[7] = attributes[7];
            row[10] = attributes[10];
            row[8] = attributes[8];
            row[9] = attributes[9];
        } else if (dtDataType == null) {
            attributes = TableUtil.getFieldAttributes((DtField)dtField);
            row[5] = attributes[5];
            row[6] = attributes[6];
            row[7] = attributes[7];
            row[10] = attributes[10];
            row[8] = attributes[8];
            row[9] = attributes[9];
        }
        row[2] = new Boolean(false);
        return row;
    }

    protected void insertRowViaWizard(int index) {
        int numOfRows = this.getRowCount();
        if (index < 0 || index >= numOfRows) {
            TableMessageHandler.sendErrorMessage((String)"Insert Element", (String)"Select a valid row");
            return;
        }
        String fieldName = (String)this.getValueAt(index, 1);
        if (TableUtil.stringIsEmpty((String)fieldName)) {
            TableMessageHandler.sendErrorMessage((String)"Create Structure Element", (String)MessagePool.getMessage((String)"Select a valid row", (String)Integer.toString(index)));
            return;
        }
        DatabaseEnum[] selectedDbs = this.getSelectedDbSystems();
        DtDbTypeInfo[] info = ((DtField)this.mDtDbTable.getStructureElement(fieldName)).getTypeInfos();
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        if (info.length > 0) {
            int i = 0;
            while (i < info.length) {
                DtTypeInfoForDatabase typeInfo = new DtTypeInfoForDatabase(info[i].getDatabase().toString(), info[i].getJdbcTypeName(), info[i].getDatabaseTypeName());
                list.add(typeInfo);
                ++i;
            }
        }
        TableEditRowActionDelegate tableEditRowActionDelegate = new TableEditRowActionDelegate();
        tableEditRowActionDelegate.run((AbstractTableFieldsTableModel)this, 'I', index, this.mDtDictionaryRoot, this.advancedPermissions, selectedDbs, list, false, "Element name:", "Create Structure Element", "Enter the attributes of the structure element", "NEW_ELEMENT", this.mDtDbTable.isReadOnly());
    }

    protected void addRowViaWizard() {
        TableEditRowActionDelegate tableEditRowActionDelegate = new TableEditRowActionDelegate();
        tableEditRowActionDelegate.run((AbstractTableFieldsTableModel)this, 'A', -1, this.mDtDictionaryRoot, this.advancedPermissions, this.getSelectedDbSystems(), null, false, "Element name:", "Create Structure Element", "Enter the attributes of the structure element", "NEW_ELEMENT", this.mDtDbTable.isReadOnly());
    }

    protected boolean setKeyElement(DtStructureElement dtStructureElement, boolean isKeyElement) {
        return true;
    }

    protected void removeKeyElement(DtStructureElement dtStructureElement) {
    }

    protected void checkPrimaryKey() {
    }

    protected DatabaseEnum[] getSelectedDbSystems() {
        Enumeration enumeration = DatabaseEnum.enumerate();
        ArrayList<DatabaseEnum> selectedDbSystem = new ArrayList<DatabaseEnum>();
        boolean no = false;
        while (enumeration.hasMoreElements()) {
            DatabaseEnum db = (DatabaseEnum)enumeration.nextElement();
            selectedDbSystem.add(db);
        }
        DatabaseEnum[] selectedDbs = new DatabaseEnum[selectedDbSystem.size()];
        int i = 0;
        while (i < selectedDbSystem.size()) {
            selectedDbs[i] = (DatabaseEnum)selectedDbSystem.get(i);
            ++i;
        }
        return selectedDbs;
    }

    public DtStructure getStructure() {
        return this.mDtDbTable;
    }
}

