/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.structureeditor;

import com.sap.dictionary.tools.structureeditor.StructureEditorPlugin;
import com.sap.dictionary.tools.structureeditor.StructureFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditStructureInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StructureEditor
extends AbstractTableEditor
implements IDevelopmentObjectEditor {
    public DtGeneralStructure mDtDbTable = null;

    protected void createPages() {
        this.readUserXMLFile();
        this.createFieldsPage();
        this.readOnly = this.isReadOnly() ? 0 : 1;
    }

    protected void createFieldsPage() {
        ScrolledComposite sc = new ScrolledComposite(this.getContainer(), 768);
        sc.setLayout((Layout)new FillLayout());
        sc.setAlwaysShowScrollBars(false);
        sc.getVerticalBar().setIncrement(10);
        sc.getVerticalBar().setPageIncrement(100);
        sc.getHorizontalBar().setIncrement(10);
        sc.getHorizontalBar().setPageIncrement(100);
        Composite composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)composite);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mTableFieldsSectionForm = new StructureFieldsSectionForm((IWidgetFactory)new LiteWidgetFactory(), 1, "Edit Structure", this, this.mTableName, this.mDtDbTable, this.mDtDictionaryRoot);
        PaneFactory.establishGridLayoutPaneContainer((Composite)composite, (IGridLayoutPaneContainer)this.mTableFieldsSectionForm);
        Table lTable = ((StructureFieldsSectionForm)this.mTableFieldsSectionForm).getTableSection().getTableViewer().getTable();
        if (this.isReadOnly()) {
            TableItem[] lItems = lTable.getItems();
            int i = 0;
            while (i < lItems.length) {
                lItems[i].setForeground(Display.getCurrent().getSystemColor(15));
                ++i;
            }
        }
        composite.setSize(800, 600);
        int index = this.addPage((Control)sc);
        this.setPageText(index, "");
        lTable.getColumn(2).setResizable(false);
    }

    protected void createAdGui() {
    }

    public boolean isReadOnly() {
        if (this.mDtDbTable.isReadOnly()) {
            return true;
        }
        if (this.mDtDbTable.hasLogicalDictionary()) {
            return true;
        }
        String masterLanguage = this.mDtDbTable.getMasterLanguage();
        TextPool textPool = this.mDtDbTable.getTextPool();
        return textPool != null && textPool.isReadOnly(masterLanguage);
    }

    public boolean isDeleted() {
        return false;
    }

    protected void initMetamodelFile(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        String lFileName;
        IFile file = ((IFileEditorInput)editorInput).getFile();
        this.mTableName = lFileName = file.getFullPath().removeFileExtension().lastSegment();
        this.setTitle(lFileName);
        IProject project = file.getProject();
        String lProjectName = project.getName();
        if (!ServicesEclipse.projectHasDictionaryNature((String)lProjectName)) {
            return;
        }
        IJavaProject javaProject = null;
        IProjectNature nature = null;
        try {
            nature = project.getNature("org.eclipse.jdt.core.javanature");
            if (nature instanceof IJavaProject) {
                javaProject = (IJavaProject)nature;
            }
        }
        catch (CoreException e) {
            StructureEditorPlugin.tracer.error("get java project", (Throwable)e);
        }
        String lPackageName = null;
        try {
            IPackageFragment fragment = javaProject.findPackageFragment(file.getParent().getFullPath());
            if (fragment != null) {
                lPackageName = fragment.getElementName();
            }
        }
        catch (JavaModelException e) {
            StructureEditorPlugin.tracer.error("get package fragment", (Throwable)e);
        }
        try {
            this.mMetamodelManager = MetamodelManager.getMetamodelManager((String)lProjectName);
            this.mMetamodel = this.mMetamodelManager.getMetamodel();
            this.mDtDictionaryRoot = MetamodelServices.getDictionaryRoot((String)lProjectName);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new PartInitException(e.getMessage());
        }
        if (!this.mDtDictionaryRoot.hasStructure(lPackageName, this.mTableName)) {
            this.mDtDbTable = null;
        } else {
            try {
                this.mDtDbTable = this.mDtDictionaryRoot.getStructure(lPackageName, this.mTableName);
                if (this.mDtDbTable == null) {
                    throw new LoadException("Structure not found: " + this.mTableName);
                }
            }
            catch (LoadException e) {
                TableMessageHandler.sendErrorMessage((String)"Metadata API", (String)e.getMessage());
                throw new PartInitException(e.getMessage());
            }
        }
    }

    protected void initMetamodelUml(IEditorInput editorInput) throws PartInitException {
        try {
            this.mMetamodel = ((EditStructureInput)editorInput).metamodel;
            this.mDtDictionaryRoot = ((EditStructureInput)editorInput).dictRoot;
            this.mDtDbTable = (DtGeneralStructure)((EditStructureInput)editorInput).structure;
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage());
        }
        this.mTableName = this.mDtDbTable.getName();
        if (this.mTableName == null) {
            this.mTableName = "";
        }
    }

    public StructureFieldsSectionForm getTableFieldsSectionForm() {
        return (StructureFieldsSectionForm)this.mTableFieldsSectionForm;
    }

    public StructureFieldsSectionForm getTableForm() {
        return (StructureFieldsSectionForm)this.mTableFieldsSectionForm;
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public DtGeneralStructure getDtDbTable() {
        return this.mDtDbTable;
    }

    protected DtStructure getStructure() {
        return this.mDtDbTable;
    }

    protected void refreshIndexPage(boolean setReadOnlyColors) {
    }

    protected AbstractUIPlugin getPluginInstance() {
        return StructureEditorPlugin.getInstance();
    }

    protected DictionaryImage getDictionaryImage() {
        return DictionaryImage.ICON_STRUCTURE;
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.mDtDbTable;
    }

    public void updateUI() {
    }
}

