/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleItemSorter {
    private Vector m_itemList = new Vector();

    public void addItem(String sortCriteria, Object itemData) {
        this.m_itemList.add(new Item(sortCriteria, itemData));
    }

    public void sort(boolean ascending) {
        Collections.sort(this.m_itemList, new SimpleComparator(ascending));
    }

    public Enumeration elements() {
        return this.m_itemList.elements();
    }

    public static final void main(String[] args) {
        SimpleItemSorter sorter = new SimpleItemSorter();
        sorter.addItem("1", "2");
        sorter.addItem("2", "3");
        sorter.sort(true);
    }

    public class SimpleComparator
    implements Comparator {
        private boolean m_ascending = true;

        public SimpleComparator(boolean ascending) {
            this.m_ascending = ascending;
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((Item)o1).getSortCriteria();
            String s2 = ((Item)o2).getSortCriteria();
            if (this.m_ascending) {
                return s1.compareTo(s2);
            }
            return -1 * s1.compareTo(s2);
        }
    }

    public class Item {
        private String m_sortCriteria;
        private Object m_itemData;

        public Item(String sortCriteria, Object itemData) {
            this.m_sortCriteria = sortCriteria;
            this.m_itemData = itemData;
        }

        public String getSortCriteria() {
            return this.m_sortCriteria;
        }

        public Object getItemData() {
            return this.m_itemData;
        }
    }
}

