/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.machine;

import com.sap.caf.mp.base.swift.machine.StackMachineCommand;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StackMachineProgram
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector m_operations = new Vector();
    protected Hashtable m_labels = new Hashtable();
    protected int m_lineCount = 0;

    public void addCommand(int op, String arg) {
        this.m_operations.add(new StackMachineCommand(this.m_lineCount, op, arg));
        ++this.m_lineCount;
    }

    public int getCommandCount() {
        return this.m_lineCount;
    }

    public StackMachineCommand getCommand(int line) {
        return (StackMachineCommand)this.m_operations.get(line);
    }

    public void printProgram(PrintStream stream) {
        Enumeration enumeration = this.m_operations.elements();
        while (enumeration.hasMoreElements()) {
            StackMachineCommand cmd = (StackMachineCommand)enumeration.nextElement();
            stream.println(cmd.toString());
        }
    }

    public ProgramLabel addLabel() {
        int pos = this.m_labels.size() + 1;
        ProgramLabel lbl = new ProgramLabel("label_" + pos);
        this.m_labels.put(lbl.getLabel(), lbl);
        return lbl;
    }

    public int getTargetAddress(String labelName) {
        ProgramLabel lbl = (ProgramLabel)this.m_labels.get(labelName);
        return lbl.getTargetLine();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Enumeration enumeration = this.m_operations.elements();
        while (enumeration.hasMoreElements()) {
            result.append(((StackMachineCommand)enumeration.nextElement()).toString() + "\r\n");
        }
        return result.toString();
    }

    public class ProgramLabel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_label;
        private int m_targetLine;

        public ProgramLabel(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }

        public int getTargetLine() {
            return this.m_targetLine;
        }

        public void setTargetLine(int line) {
            this.m_targetLine = line;
        }
    }
}

