/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.machine;

public class StackMachineOperations {
    public static final int OP_LOAD = 1;
    public static final int OP_PUSH_LIT = 2;
    public static final int OP_PUSH_NAME = 3;
    public static final int OP_POP = 10;
    public static final int OP_STORE = 15;
    public static final int OP_EXISTS = 16;
    public static final int OP_CLEAR = 17;
    public static final int OP_REMOVE = 18;
    public static final int OP_APPEND = 19;
    public static final int OP_COUNT = 14;
    public static final int OP_PRINT = 20;
    public static final int OP_PRINTLN = 21;
    public static final int OP_MATH_ADD = 30;
    public static final int OP_MATH_SUB = 31;
    public static final int OP_MATH_MUL = 32;
    public static final int OP_MATH_DIV = 33;
    public static final int OP_MATH_MOD = 34;
    public static final int OP_COMP_EQ = 40;
    public static final int OP_COMP_LT = 41;
    public static final int OP_COMP_GT = 42;
    public static final int OP_COMP_LE = 43;
    public static final int OP_COMP_GE = 44;
    public static final int OP_COMP_NE = 45;
    public static final int OP_BOOL_NOT = 50;
    public static final int OP_JUMP = 60;
    public static final int OP_JUMP_COND = 61;
    public static final int OP_BREAK = 70;
    public static final int OP_BLOCK_START = 71;
    public static final int OP_BLOCK_END = 72;
    public static final int OP_STOP = 80;
    public static final int OP_LOOP_CHECK = 90;
    public static final int OP_LOOP_FIELD = 92;
    public static final int OP_LOOP_GETIDX = 93;
    public static final int OP_LOOP_INIT = 94;
    public static final int OP_LOOP_FINALIZE = 95;
    public static final int OP_SUBSTR = 100;
    public static final int OP_LEN = 101;
    public static final int OP_FMT_HTML = 110;
    public static final int OP_FMT_URL = 111;
    public static final int OP_FMT_XML = 112;
    public static final int OP_FMT_JS = 113;
    public static final int OP_FMT_USER = 114;
    public static final int OP_FMT_DATE = 115;

    private StackMachineOperations() {
    }

    public static String getOpName(int op) {
        String result = null;
        switch (op) {
            case 90: {
                result = "OP_LOOP_CHECK";
                break;
            }
            case 92: {
                result = "OP_LOOP_FIELD";
                break;
            }
            case 71: {
                result = "OP_BLOCK_START";
                break;
            }
            case 72: {
                result = "OP_BLOCK_END";
                break;
            }
            case 95: {
                result = "OP_LOOP_FINALIZE";
                break;
            }
            case 93: {
                result = "OP_LOOP_GETIDX";
                break;
            }
            case 94: {
                result = "OP_LOOP_INIT";
                break;
            }
            case 70: {
                result = "OP_BREAK";
                break;
            }
            case 80: {
                result = "OP_STOP";
                break;
            }
            case 1: {
                result = "OP_LOAD";
                break;
            }
            case 2: {
                result = "OP_PUSH_LIT";
                break;
            }
            case 3: {
                result = "OP_PUSH_NAME";
                break;
            }
            case 10: {
                result = "OP_POP";
                break;
            }
            case 20: {
                result = "OP_PRINT";
                break;
            }
            case 21: {
                result = "OP_PRINTLN";
                break;
            }
            case 15: {
                result = "OP_STORE";
                break;
            }
            case 30: {
                result = "OP_MATH_ADD";
                break;
            }
            case 31: {
                result = "OP_MATH_SUB";
                break;
            }
            case 32: {
                result = "OP_MATH_MUL";
                break;
            }
            case 33: {
                result = "OP_MATH_DIV";
                break;
            }
            case 34: {
                result = "OP_MATH_MOD";
                break;
            }
            case 40: {
                result = "OP_COMP_EQ";
                break;
            }
            case 41: {
                result = "OP_COMP_LT";
                break;
            }
            case 42: {
                result = "OP_COMP_GT";
                break;
            }
            case 43: {
                result = "OP_COMP_LE";
                break;
            }
            case 44: {
                result = "OP_COMP_GE";
                break;
            }
            case 45: {
                result = "OP_COMP_NE";
                break;
            }
            case 50: {
                result = "OP_BOOL_NOT";
                break;
            }
            case 16: {
                result = "OP_EXISTS";
                break;
            }
            case 17: {
                result = "OP_CLEAR";
                break;
            }
            case 18: {
                result = "OP_REMOVE";
                break;
            }
            case 19: {
                result = "OP_APPEND";
                break;
            }
            case 14: {
                result = "OP_COUNT";
                break;
            }
            case 60: {
                result = "OP_JUMP";
                break;
            }
            case 61: {
                result = "OP_JUMP_COND";
                break;
            }
            case 115: {
                result = "OP_FMT_DATE";
                break;
            }
            case 110: {
                result = "OP_FMT_HTML";
                break;
            }
            case 113: {
                result = "OP_FMT_JS";
                break;
            }
            case 111: {
                result = "OP_FMT_URL";
                break;
            }
            case 114: {
                result = "OP_FMT_USER";
                break;
            }
            case 112: {
                result = "OP_FMT_XML";
            }
        }
        if (result == null) {
            return "[OPCODE_" + op + "]";
        }
        return "[" + result + "]";
    }
}

