/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.machine;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.swift.fields.DataFields;
import com.sap.caf.mp.base.swift.machine.LoopStatementController;
import java.util.Stack;

public class DataFieldController {
    private Stack m_loopStack = new Stack();
    private DataFields m_fields;

    public DataFieldController(DataFields fields) {
        this.m_fields = fields;
    }

    public void pushLoop() {
        LoopStatementController lsc = new LoopStatementController(this.m_fields);
        this.m_loopStack.push(lsc);
    }

    public void addLoopField(String name) {
        LoopStatementController lsc = (LoopStatementController)this.m_loopStack.get(this.m_loopStack.size() - 1);
        lsc.addLoopField(name);
    }

    public boolean hasMoreLoops() {
        LoopStatementController lsc = (LoopStatementController)this.m_loopStack.get(this.m_loopStack.size() - 1);
        if (lsc.moreLoops()) {
            lsc.increment();
            return true;
        }
        return false;
    }

    public int getCurrentLoopIdx() {
        if (this.m_loopStack.size() > 0) {
            LoopStatementController lsc = (LoopStatementController)this.m_loopStack.get(this.m_loopStack.size() - 1);
            return lsc.getLoopIndex();
        }
        return -1;
    }

    public void popLoop() {
        this.m_loopStack.pop();
    }

    public String getValue(String name) {
        for (int j = this.m_loopStack.size() - 1; j >= 0; --j) {
            LoopStatementController ctrl = (LoopStatementController)this.m_loopStack.get(j);
            if (!ctrl.containsField(name)) continue;
            return ctrl.getValue(name);
        }
        return this.m_fields.getValue(name);
    }

    public void setValue(String name, String value) {
        for (int j = this.m_loopStack.size() - 1; j >= 0; --j) {
            LoopStatementController ctrl = (LoopStatementController)this.m_loopStack.get(j);
            if (!ctrl.containsField(name)) continue;
            try {
                ctrl.setCurrentValue(name, value);
            }
            catch (InvocationException ex) {
                // empty catch block
            }
            return;
        }
        this.m_fields.setValue(name, value);
    }

    public void removeValue(String name) throws InvocationException {
        for (int j = this.m_loopStack.size() - 1; j >= 0; --j) {
            LoopStatementController ctrl = (LoopStatementController)this.m_loopStack.get(j);
            if (!ctrl.containsField(name)) continue;
            ctrl.removeCurrentValue(name);
            return;
        }
        this.m_fields.removeValue(name, 0);
    }
}

