/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.rfc;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.ExternalException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.rfc.SAPConnectionPoolManager;
import com.sap.caf.mp.base.rfc.SLDConnectionPooling;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class SAPSystemConnector {
    public static final String MODE_OF_RFC = "rfc.mode";
    public static final int MODE_SLD_RFC = 1;
    public static final int MODE_SELF_DEFINED_RFC = 2;
    public static final int MODE_ENDPOINT_RFC = 3;
    public static final String ENDPOINT_NAME_RFC_DESTINATION = "endpoint.name";
    public static final String ENDPOINT_TYPE_RFC_DESTINATION = "endpoint.type";
    public static final String ENDPOINT_TYPE_RFC_SELF_DEFINED = "ENDPOINT_RFC_SELF";
    public static final String ENDPOINT_TYPE_RFC_SLD = "RFC_ENDPOINT_SLD";
    public static final String NAME_OF_SLD_DEFINED_RFC_DESTINATION = "rfc.destination";
    public static final String FUNCTION_MODULE_NAME = "rfc.functionname";
    public static final String FAULT_TABLE_NAME = "rfc.fault.table";
    public static final String FAULT_STRUCTURE_NAME = "rfc.fault.structure";
    public static final String FAULT_FIELD_NAME = "rfc.fault.faultfield.name";
    public static final String FAULT_FIELD_FAULT_VALUES = "rfc.fault.faultfield.faultval";
    public static final String FAULT_FIELD_FAULT_MESSAGE = "rfc.fault.faultfield.message";
    static /* synthetic */ Class class$com$sap$caf$mp$base$rfc$SAPSystemConnector;

    public static JCO.Function getNonExcecutedJCOFunctionOfFunctionModule(Properties properties, Locale locale) throws EngineException, InvocationException, JCO.Exception {
        JCO.Function jcoFunction = null;
        JCO.Client jcoClient = null;
        try {
            jcoClient = SAPSystemConnector.getJCOClient(properties, locale);
            JCO.Function function = jcoFunction = SAPSystemConnector.createFunction(properties.getProperty(FUNCTION_MODULE_NAME), jcoClient);
            return function;
        }
        catch (ExternalException ex) {
            throw new EngineException(ex.getMessage(), (Exception)((Object)ex));
        }
        finally {
            if (jcoClient != null) {
                JCO.releaseClient((JCO.Client)jcoClient);
            }
        }
    }

    public static JCO.Function getExecutedJCOFunctionOfFunctionModule(Properties properties, Hashtable importParametersValues, Locale locale) throws ExternalException, EngineException, InvocationException, JCO.Exception {
        JCO.Function jcoFunction = null;
        JCO.Client jcoClient = null;
        boolean modeRfc = false;
        try {
            JCO.ParameterList jcoParListTables;
            int i;
            jcoClient = SAPSystemConnector.getJCOClient(properties, locale);
            jcoFunction = SAPSystemConnector.createFunction(properties.getProperty(FUNCTION_MODULE_NAME), jcoClient);
            if (importParametersValues == null) {
                jcoClient.execute(jcoFunction);
                JCO.Function function = jcoFunction;
                return function;
            }
            if (importParametersValues.isEmpty()) {
                jcoClient.execute(jcoFunction);
                JCO.Function function = jcoFunction;
                return function;
            }
            if (jcoFunction.getImportParameterList() != null) {
                JCO.ParameterList jcoParameterlistImport = jcoFunction.getImportParameterList();
                block11: for (i = 0; i < jcoParameterlistImport.getFieldCount(); ++i) {
                    JCO.Field jcoFieldImport = jcoParameterlistImport.getField(i);
                    int parameterType = jcoFieldImport.getType();
                    switch (parameterType) {
                        case 17: {
                            if (!importParametersValues.containsKey(jcoFieldImport.getName())) continue block11;
                            JCO.Structure jcoStructure = (JCO.Structure)importParametersValues.get(jcoFieldImport.getName());
                            jcoParameterlistImport.setValue(jcoStructure, jcoFieldImport.getName());
                            continue block11;
                        }
                        case 99: {
                            JCO.Table jcoTable;
                            if (!importParametersValues.containsKey(jcoFieldImport.getName()) || (jcoTable = (JCO.Table)importParametersValues.get(jcoFieldImport.getName())).getNumRows() == 0) continue block11;
                            jcoParameterlistImport.setValue(jcoTable, jcoFieldImport.getName());
                            continue block11;
                        }
                        default: {
                            if (!importParametersValues.containsKey(jcoFieldImport.getName())) continue block11;
                            String value = (String)importParametersValues.get(jcoFieldImport.getName());
                            jcoParameterlistImport.setValue(value, jcoFieldImport.getName());
                        }
                    }
                }
            }
            if (jcoFunction.getTableParameterList() != null) {
                jcoParListTables = jcoFunction.getTableParameterList();
                for (i = 0; i < jcoParListTables.getFieldCount(); ++i) {
                    JCO.Table jcoTable;
                    JCO.Field jcoFieldTable = jcoParListTables.getField(i);
                    if (!importParametersValues.containsKey(jcoFieldTable.getName()) || (jcoTable = (JCO.Table)importParametersValues.get(jcoFieldTable.getName())).getNumRows() == 0) continue;
                    jcoParListTables.setValue(jcoTable, jcoFieldTable.getName());
                }
            }
            jcoClient.execute(jcoFunction);
            jcoParListTables = jcoFunction;
            return jcoParListTables;
        }
        catch (JCO.AbapException abapexception) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "The following abap exception ocurred: " + abapexception.getMessage(), (Exception)((Object)abapexception));
            throw new ExternalException((Exception)((Object)abapexception));
        }
        finally {
            if (jcoClient != null) {
                JCO.releaseClient((JCO.Client)jcoClient);
            }
        }
    }

    private static IRepository createRepository(JCO.Client jcoClient, String functionModuleName) throws ExternalException {
        try {
            JCO.Repository repository = new JCO.Repository(functionModuleName, jcoClient);
            return repository;
        }
        catch (Exception exception) {
            throw new ExternalException(exception);
        }
    }

    private static synchronized JCO.Function createFunction(String functionModuleName, JCO.Client jcoClient) throws ExternalException {
        try {
            JCO.Function jcoFunction = SAPSystemConnector.createRepository(jcoClient, functionModuleName).getFunctionTemplate(functionModuleName.toUpperCase()).getFunction();
            return jcoFunction;
        }
        catch (NullPointerException ex) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, ex);
            String message = MessageFormat.format("The function module: \"{0}\" does not exist.", functionModuleName);
            throw new ExternalException(message, ex);
        }
        catch (JCO.Exception exception) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, (Exception)((Object)exception));
            throw new ExternalException("The occurred exception: " + exception.getGroup(), (Exception)((Object)exception));
        }
        catch (Exception exception) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, exception);
            throw new ExternalException(exception);
        }
    }

    private static JCO.Client getJCOClient(Properties properties, Locale locale) throws EngineException, InvocationException, JCO.Exception {
        JCO.Client jcoClient = null;
        int modeRfc = 0;
        try {
            if (properties.getProperty(MODE_OF_RFC) == null) {
                throw new EngineException("The mode of remote function call must not be null");
            }
        }
        catch (NullPointerException ex) {
            throw new EngineException("The mode of remote function call must not be null", ex);
        }
        try {
            if (properties.getProperty(FUNCTION_MODULE_NAME) == null) {
                throw new EngineException("The name of the function module must not be null");
            }
        }
        catch (NullPointerException ex) {
            throw new EngineException("The name of the function module must not be null", ex);
        }
        try {
            modeRfc = Integer.parseInt(properties.getProperty(MODE_OF_RFC));
        }
        catch (NumberFormatException ex) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "Unable to convert value of mode of remote function call: " + ex.getMessage());
            throw new EngineException("Unable to convert value of mode of remote function call: " + ex.getMessage(), ex);
        }
        switch (modeRfc) {
            case 1: {
                if (properties.getProperty(NAME_OF_SLD_DEFINED_RFC_DESTINATION) == null) {
                    throw new EngineException("Missing name of JCODestination of SLD.");
                }
                String nameSLDDestination = properties.getProperty(NAME_OF_SLD_DEFINED_RFC_DESTINATION);
                try {
                    if (locale != null) {
                        jcoClient = SLDConnectionPooling.getClientConnection(nameSLDDestination, locale);
                        break;
                    }
                    String language = "EN";
                    Locale userLocale = new Locale(language);
                    jcoClient = SLDConnectionPooling.getClientConnection(nameSLDDestination, userLocale);
                    break;
                }
                catch (JCO.Exception jcoEx) {
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, (Exception)((Object)jcoEx));
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "Unable to create function using using SLD occurred JCOException: " + jcoEx.getMessage());
                    throw new JCO.Exception(jcoEx.getGroup(), jcoEx.getKey(), jcoEx.getMessage());
                }
                catch (Exception exception) {
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, exception);
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "Unable to create function using SLD: " + exception.getMessage());
                    throw new EngineException(exception);
                }
            }
            case 2: {
                try {
                    if (locale != null) {
                        properties.remove("jco.language");
                        String language = locale.getLanguage();
                        properties.setProperty("jco.language", language.toUpperCase());
                        BaseLogManager.info(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "The language of locale is: " + locale.getLanguage());
                    }
                    jcoClient = SAPConnectionPoolManager.getJCOClient(properties);
                    break;
                }
                catch (JCO.Exception jcoEx) {
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, (Exception)((Object)jcoEx));
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "Unable to create function using self defined RFC occurred JCOException: " + jcoEx.getMessage());
                    throw new JCO.Exception(jcoEx.getGroup(), jcoEx.getKey(), jcoEx.getMessage());
                }
                catch (Exception exception) {
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, exception);
                    BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "Unable to create function using self defined RFC: " + exception.getMessage());
                    throw new EngineException(exception);
                }
            }
            case 3: {
                String endpointName = properties.getProperty(ENDPOINT_NAME_RFC_DESTINATION);
                String endpointType = properties.getProperty(ENDPOINT_TYPE_RFC_DESTINATION);
                if (endpointName == null) {
                    throw new InvocationException("The endpoint name must be set");
                }
                if (endpointName.equals("")) {
                    throw new InvocationException("The endpoint name must be set");
                }
                if (endpointType == null) {
                    throw new InvocationException("The endpoint type must be set");
                }
                if (endpointType.equals("")) {
                    throw new InvocationException("The endpoint type must be set");
                }
                BaseLogManager.info(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "The endpoint name is: " + endpointName);
                BaseLogManager.info(class$com$sap$caf$mp$base$rfc$SAPSystemConnector == null ? (class$com$sap$caf$mp$base$rfc$SAPSystemConnector = SAPSystemConnector.class$("com.sap.caf.mp.base.rfc.SAPSystemConnector")) : class$com$sap$caf$mp$base$rfc$SAPSystemConnector, "The endpoint type is: " + endpointType);
            }
            default: {
                throw new EngineException("Invalid mode of remote function call: " + modeRfc);
            }
        }
        return jcoClient;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

