/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.protocol.webdav.WebDAVConstants;
import com.sap.caf.mp.base.protocol.webdav.WebDAVPropertyValue;
import com.sap.caf.mp.base.util.ClassUtils;
import com.sap.caf.mp.base.util.ExternalDate;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebDAVResource {
    private String m_resourceId;
    private Hashtable m_propertyValues;
    private boolean m_isCollection = false;
    private Date m_creationDate = null;
    private String m_contentLanguage = null;
    private long m_contentLength = -1L;
    private String m_contentType = null;
    private String m_eTag = null;
    private Date m_lastModified = null;
    private String m_displayName = null;

    protected WebDAVResource(String resourceId, Hashtable propertyValues, boolean isCollection) {
        this.m_resourceId = resourceId;
        this.m_propertyValues = propertyValues;
    }

    protected WebDAVResource(Node element) throws EngineException {
        this.m_propertyValues = new Hashtable();
        NodeList children = element.getChildNodes();
        int count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String name = child.getLocalName();
            if (name == null) continue;
            if (name.equals("href")) {
                this.parseHRef(child);
                continue;
            }
            if (!name.equals("propstat")) continue;
            this.parsePropstat(child);
        }
    }

    private void parseHRef(Node element) throws EngineException {
        this.m_resourceId = element.getFirstChild().getNodeValue();
    }

    private void parsePropstat(Node element) throws EngineException {
        String content;
        Node propNode = null;
        Node statNode = null;
        NodeList list = element.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = list.item(i);
            String name = child.getLocalName();
            if (name == null) continue;
            if (name.equals("prop")) {
                propNode = child;
                continue;
            }
            if (!name.equals("status")) continue;
            statNode = child;
        }
        int statusCode = 404;
        if (statNode != null && (content = statNode.getFirstChild().getNodeValue()).startsWith("HTTP/1.1")) {
            String responseCode = content.substring(9, 12);
            try {
                statusCode = Integer.parseInt(responseCode);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (statusCode == 200) {
            NodeList props = propNode.getChildNodes();
            count = props.getLength();
            for (int i = 0; i < count; ++i) {
                Node prop = props.item(i);
                String name = prop.getLocalName();
                if (name == null) continue;
                this.parseProperty(name, prop);
            }
        }
    }

    private void parseProperty(String name, Node element) throws EngineException {
        Node content = element.getFirstChild();
        if (content != null) {
            String value = content.getNodeValue();
            String nameSpace = element.getNamespaceURI();
            int propCode = 0;
            if (nameSpace.equals("DAV:")) {
                propCode = WebDAVConstants.propertyName2Code(name);
            }
            switch (propCode) {
                case 1: {
                    try {
                        this.m_creationDate = ExternalDate.parseTimeStamp(value);
                        break;
                    }
                    catch (Exception ex) {
                        throw new EngineException(ex);
                    }
                }
                case 2: {
                    this.m_displayName = value;
                    break;
                }
                case 3: {
                    this.m_contentLanguage = value;
                    break;
                }
                case 4: {
                    this.m_contentLength = Long.parseLong(value);
                    break;
                }
                case 5: {
                    this.m_contentType = value;
                    break;
                }
                case 6: {
                    this.m_eTag = value;
                    break;
                }
                case 7: {
                    try {
                        this.m_lastModified = ExternalDate.parseTimeStamp(value);
                        break;
                    }
                    catch (Exception ex) {
                        throw new EngineException(ex);
                    }
                }
                case 8: {
                    NodeList typeNodes = element.getChildNodes();
                    int typeCount = typeNodes.getLength();
                    for (int j = 0; j < typeCount; ++j) {
                        Node typeNode = typeNodes.item(j);
                        String typeName = typeNode.getLocalName();
                        if (typeName == null) continue;
                        this.m_isCollection = typeName.equals("collection");
                    }
                    break;
                }
                default: {
                    WebDAVPropertyValue property = new WebDAVPropertyValue(element.getNamespaceURI(), name, value);
                    this.m_propertyValues.put(property.getKey(), property);
                }
            }
        }
    }

    public String getResourceId() {
        return this.m_resourceId;
    }

    public boolean isCollection() {
        return this.m_isCollection;
    }

    public Enumeration properties() {
        return this.m_propertyValues.elements();
    }

    public WebDAVPropertyValue getPropertyValue(String nameSpace, String name) {
        int propCode = 0;
        if (nameSpace.equals("DAV:")) {
            propCode = WebDAVConstants.propertyName2Code(name);
        }
        switch (propCode) {
            case 1: {
                if (this.m_creationDate != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(this.m_creationDate);
                    return new WebDAVPropertyValue(nameSpace, name, ExternalDate.buildTimeStampISO8601(cal, false, true));
                }
                return null;
            }
            case 2: {
                if (this.m_displayName != null) {
                    return new WebDAVPropertyValue(nameSpace, name, this.m_displayName);
                }
                return null;
            }
            case 3: {
                if (this.m_contentLanguage != null) {
                    return new WebDAVPropertyValue(nameSpace, name, this.m_contentLanguage);
                }
                return null;
            }
            case 4: {
                if (this.m_contentLength != -1L) {
                    return new WebDAVPropertyValue(nameSpace, name, "" + this.m_contentLength);
                }
                return null;
            }
            case 5: {
                if (this.m_contentLength != -1L) {
                    return new WebDAVPropertyValue(nameSpace, name, this.m_contentType);
                }
                return null;
            }
            case 6: {
                if (this.m_eTag != null) {
                    return new WebDAVPropertyValue(nameSpace, name, this.m_eTag);
                }
                return null;
            }
            case 7: {
                if (this.m_lastModified != null) {
                    return new WebDAVPropertyValue(nameSpace, name, ExternalDate.buildTimeStampRFC1123(this.m_lastModified));
                }
                return null;
            }
        }
        String key = nameSpace + name;
        WebDAVPropertyValue value = (WebDAVPropertyValue)this.m_propertyValues.get(key);
        return value;
    }

    public String toString() {
        return ClassUtils.getInstanceInfo(this);
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public String getContentLanguage() {
        return this.m_contentLanguage;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public long getContentLength() {
        return this.m_contentLength;
    }

    public String getETag() {
        return this.m_eTag;
    }

    public Date getLastModified() {
        return this.m_lastModified;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }
}

