/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.protocol.webdav.WebDAVProperty;

public class WebDAVPropertyValue {
    private String m_nameSpace;
    private String m_name;
    private String m_value;
    private String m_key;

    public WebDAVPropertyValue(String nameSpace, String name, String value) {
        this.m_nameSpace = nameSpace;
        this.m_name = name;
        this.m_value = value;
        this.m_key = nameSpace + name;
    }

    public WebDAVPropertyValue(WebDAVProperty prop, String value) {
        this.m_name = prop.getName();
        this.m_nameSpace = prop.getNameSpace();
        this.m_key = this.m_nameSpace + this.m_name;
        this.m_value = value;
    }

    public String getNameSpace() {
        return this.m_nameSpace;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebDAVPropertyValue) {
            WebDAVPropertyValue test = (WebDAVPropertyValue)obj;
            return test.getName().equals(this.m_name) && test.getNameSpace().equals(this.m_nameSpace) && test.getValue().equals(this.m_value);
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getNameSpace().hashCode() + this.getValue().hashCode();
    }

    public String toString() {
        return this.m_nameSpace + ":" + this.m_name + " Value=" + this.m_value;
    }
}

