/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.http.HttpHeader;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import java.util.StringTokenizer;

public class WebDAVOptionsServer {
    private boolean m_webDAVSupported;
    private boolean m_webDAVV2;
    private boolean m_webDAVAccessControl;
    private String m_serverDescription;

    protected WebDAVOptionsServer(HttpResponse response) throws InvocationException {
        HttpHeader header = response.getResponseHeader(15);
        this.m_serverDescription = header != null ? header.getHeaderValue() : null;
        this.m_webDAVSupported = false;
        this.m_webDAVV2 = false;
        this.m_webDAVAccessControl = false;
        header = response.getResponseHeader("DAV");
        if (header != null) {
            StringTokenizer tokenizer = new StringTokenizer(header.getHeaderValue(), ",", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.equals("1")) {
                    this.m_webDAVSupported = true;
                    continue;
                }
                if (token.equals("2")) {
                    this.m_webDAVV2 = true;
                    continue;
                }
                if (!token.equalsIgnoreCase("access-control")) continue;
                this.m_webDAVAccessControl = true;
            }
        }
    }

    public boolean isWebDAVSupported() {
        return this.m_webDAVSupported;
    }

    public boolean isVersion2Supported() {
        return this.m_webDAVV2;
    }

    public boolean isAccessControlSupported() {
        return this.m_webDAVAccessControl;
    }

    public String getServerDescription() {
        return this.m_serverDescription;
    }

    public String toString() {
        return "ServerOptions: DAV=" + this.m_webDAVSupported + ", DAV_V2=" + this.m_webDAVV2 + ", DAV_ACL=" + this.m_webDAVAccessControl + ", Server=" + this.m_serverDescription;
    }
}

