/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.webdav.WebDAVProperty;
import java.util.Hashtable;

public class WebDAVConstants {
    public static final int HTTP_RESPONSE_CODE_PROCESSING = 102;
    public static final int HTTP_RESPONSE_CODE_MULTI_STATUS = 207;
    public static final int HTTP_RESPONSE_CODE_UNPROCESSABLE_ENTITY = 422;
    public static final int HTTP_RESPONSE_CODE_LOCKED = 423;
    public static final int HTTP_RESPONSE_CODE_FAILED_DEPENDENCY = 424;
    public static final int HTTP_RESPONSE_CODE_INSUFFICIENT_STORAGE = 507;
    public static final String WEBDAV_NAMESPACE = "DAV:";
    public static final String PROPERTY_CREATIONDATE = "creationdate";
    public static final String PROPERTY_DISPLAYNAME = "displayname";
    public static final String PROPERTY_GETCONTENTLANGUAGE = "getcontentlanguage";
    public static final String PROPERTY_GETCONTENTLENGTH = "getcontentlength";
    public static final String PROPERTY_GETCONTENTTYPE = "getcontenttype";
    public static final String PROPERTY_GETETAG = "getetag";
    public static final String PROPERTY_GETLASTMODIFIED = "getlastmodified";
    public static final String PROPERTY_LOCKDISCOVERY = "lockdiscovery";
    public static final String PROPERTY_RESOURCETYPE = "resourcetype";
    public static final String PROPERTY_SOURCE = "source";
    public static final String PROPERTY_SUPPORTEDLOCK = "supportedlock";
    public static final int PROP_CUSTOM = 0;
    public static final int PROP_CREATIONDATE = 1;
    public static final int PROP_DISPLAYNAME = 2;
    public static final int PROP_GETCONTENTLANGUAGE = 3;
    public static final int PROP_GETCONTENTLENGTH = 4;
    public static final int PROP_GETCONTENTTYPE = 5;
    public static final int PROP_GETETAG = 6;
    public static final int PROP_GETLASTMODIFIED = 7;
    public static final int PROP_LOCKDISCOVERY = 8;
    public static final int PROP_RESOURCETYPE = 8;
    public static final int PROP_SOURCE = 9;
    public static final int PROP_SUPPORTEDLOCK = 9;
    public static final String ENCODING_UTF_8 = "utf-8";
    public static final String REQUEST_METHOD_PROPFIND = "PROPFIND";
    public static final String REQUEST_CONTENT_TYPE = "text/xml; charset=\"utf-8\"";
    public static final String SUPPORTED_HTTP_PROTOCOL_VERSION = "HTTP/1.1";
    private static Hashtable m_properties = new Hashtable();
    private static Hashtable m_propertyTranslations;

    public static WebDAVProperty constructProperty(String nameSpace, String name) throws InvocationException {
        if (nameSpace.equals(WEBDAV_NAMESPACE)) {
            return WebDAVConstants.constructStandardProperty(name);
        }
        WebDAVProperty prop = new WebDAVProperty(nameSpace, name);
        return prop;
    }

    public static WebDAVProperty constructStandardProperty(String name) throws InvocationException {
        WebDAVProperty prop = (WebDAVProperty)m_properties.get(name);
        if (prop == null) {
            throw new InvocationException("Invalid WebDAV standard property: " + name);
        }
        return prop;
    }

    public static int propertyName2Code(String name) {
        Integer value = (Integer)m_propertyTranslations.get(name);
        if (value == null) {
            return 0;
        }
        return value;
    }

    static {
        m_properties.put(PROPERTY_CREATIONDATE, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_CREATIONDATE));
        m_properties.put(PROPERTY_DISPLAYNAME, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_DISPLAYNAME));
        m_properties.put(PROPERTY_GETCONTENTLANGUAGE, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_GETCONTENTLANGUAGE));
        m_properties.put(PROPERTY_GETCONTENTLENGTH, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_GETCONTENTLENGTH));
        m_properties.put(PROPERTY_GETCONTENTTYPE, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_GETCONTENTTYPE));
        m_properties.put(PROPERTY_GETETAG, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_GETETAG));
        m_properties.put(PROPERTY_GETLASTMODIFIED, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_GETLASTMODIFIED));
        m_properties.put(PROPERTY_LOCKDISCOVERY, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_LOCKDISCOVERY));
        m_properties.put(PROPERTY_RESOURCETYPE, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_RESOURCETYPE));
        m_properties.put(PROPERTY_SOURCE, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_SOURCE));
        m_properties.put(PROPERTY_SUPPORTEDLOCK, new WebDAVProperty(WEBDAV_NAMESPACE, PROPERTY_SUPPORTEDLOCK));
        m_propertyTranslations = new Hashtable();
        m_propertyTranslations.put(PROPERTY_CREATIONDATE, new Integer(1));
        m_propertyTranslations.put(PROPERTY_DISPLAYNAME, new Integer(2));
        m_propertyTranslations.put(PROPERTY_GETCONTENTLANGUAGE, new Integer(3));
        m_propertyTranslations.put(PROPERTY_GETCONTENTLENGTH, new Integer(4));
        m_propertyTranslations.put(PROPERTY_GETCONTENTTYPE, new Integer(5));
        m_propertyTranslations.put(PROPERTY_GETETAG, new Integer(6));
        m_propertyTranslations.put(PROPERTY_GETLASTMODIFIED, new Integer(7));
        m_propertyTranslations.put(PROPERTY_LOCKDISCOVERY, new Integer(8));
        m_propertyTranslations.put(PROPERTY_RESOURCETYPE, new Integer(8));
        m_propertyTranslations.put(PROPERTY_SOURCE, new Integer(9));
        m_propertyTranslations.put(PROPERTY_SUPPORTEDLOCK, new Integer(9));
    }
}

