/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.http.content;

import com.sap.caf.mp.base.protocol.http.content.IResponseContent;
import com.sap.caf.mp.base.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResponseMemory
implements IResponseContent {
    private static final int CHUNK_SIZE = 4096;
    private byte[] m_content;
    private int m_contentLength;

    public ResponseMemory(byte[] content, int length) {
        this.m_content = content;
        this.m_contentLength = length;
    }

    public ResponseMemory(InputStream stream, int size) throws IOException {
        this.m_content = null;
        this.m_contentLength = size;
        if (size == -1) {
            ByteArray ba = new ByteArray(stream);
            this.m_content = ba.toByteArray(false);
        } else {
            ByteArray ba = new ByteArray(stream, size);
            this.m_content = ba.toByteArray(false);
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.m_content, 0, this.m_contentLength);
    }

    public long getLength() {
        return this.m_contentLength;
    }

    public String toString() {
        return new String(this.m_content);
    }
}

